/*
 * Decompiled with CFR 0.152.
 */
package jsx3.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jsx3.xml.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Record
extends Node {
    private Map<String, String> attributes = new HashMap<String, String>();
    private Boolean disabled = null;
    private Boolean divider = null;
    private String execute = null;
    private String groupName = null;
    private String image = null;
    private String keycodeString = null;
    private String noMask = null;
    private Boolean selected = null;
    private String style = null;
    private String text = null;
    private String tip = null;
    private Boolean unselectable = null;

    public Record(String id) {
        super(id);
    }

    public Record(Object data) {
        this.introspectBean(data);
    }

    public Record(String id, Object data) {
        this.introspectBean(data);
        this.setId(id);
    }

    private void introspectBean(Object data) {
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo info = Introspector.getBeanInfo(data.getClass());
            for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
                Object reply;
                Method getter;
                String name = descriptor.getName();
                if ("class".equals(name) || (getter = descriptor.getReadMethod()) == null || (reply = getter.invoke(data, new Object[0])) == null) continue;
                this.setAttribute(name, reply.toString());
                if (!"id".equals(name)) continue;
                this.setId(reply.toString());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getAttribute(String name) {
        this.checkForJsxAttribute(name);
        return this.attributes.get(name);
    }

    public Record setAttribute(String name, String value) {
        this.checkForJsxAttribute(name);
        this.attributes.put(name, value);
        return this;
    }

    public String removeAttribute(String name) {
        this.checkForJsxAttribute(name);
        return this.attributes.remove(name);
    }

    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    private void checkForJsxAttribute(String name) {
        if (name.startsWith("jsx")) {
            throw new IllegalArgumentException("Special JSX Attribute keys should be set directly");
        }
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Record setDisabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public Boolean getDivider() {
        return this.divider;
    }

    public Record setDivider(Boolean divider) {
        this.divider = divider;
        return this;
    }

    public String getExecute() {
        return this.execute;
    }

    public Record setExecute(String execute) {
        this.execute = execute;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Record setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getImage() {
        return this.image;
    }

    public Record setImage(String image) {
        this.image = image;
        return this;
    }

    public String getKeycodeString() {
        return this.keycodeString;
    }

    public Record setKeycodeString(String keycodeString) {
        this.keycodeString = keycodeString;
        return this;
    }

    public String getNoMask() {
        return this.noMask;
    }

    public Record setNoMask(String noMask) {
        this.noMask = noMask;
        return this;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public Record setSelected(Boolean selected) {
        this.selected = selected;
        return this;
    }

    public String getStyle() {
        return this.style;
    }

    public Record setStyle(String style) {
        this.style = style;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Record setText(String text) {
        this.text = text;
        return this;
    }

    public String getTip() {
        return this.tip;
    }

    public Record setTip(String tip) {
        this.tip = tip;
        return this;
    }

    public Boolean getUnselectable() {
        return this.unselectable;
    }

    public Record setUnselectable(Boolean unselectable) {
        this.unselectable = unselectable;
        return this;
    }

    protected String toXml(int depth) {
        StringBuilder buffer = new StringBuilder();
        for (Record record : this) {
            buffer.append(Node.indent(depth));
            buffer.append(record.toXml(depth + 1));
            buffer.append("\n");
        }
        StringBuilder reply = new StringBuilder();
        reply.append("<record jsxid=\"" + this.getId() + "\"");
        this.createAttributeOutput(reply, "jsxdisabled", this.disabled);
        this.createAttributeOutput(reply, "jsxdivider", this.divider);
        this.createAttributeOutput(reply, "jsxexecute", this.execute);
        this.createAttributeOutput(reply, "jsxgroupname", this.groupName);
        this.createAttributeOutput(reply, "jsximage", this.image);
        this.createAttributeOutput(reply, "jsxkeycode", this.keycodeString);
        this.createAttributeOutput(reply, "jsxnomask", this.noMask);
        this.createAttributeOutput(reply, "jsxselected", this.selected);
        this.createAttributeOutput(reply, "jsxstyle", this.style);
        this.createAttributeOutput(reply, "jsxtext", this.text);
        this.createAttributeOutput(reply, "jsxtip", this.tip);
        this.createAttributeOutput(reply, "jsxunselectable", this.unselectable);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.createAttributeOutput(reply, entry.getKey(), entry.getValue());
        }
        if (buffer.length() == 0) {
            reply.append("/>\n");
        } else {
            reply.append(">\n");
            reply.append(buffer.toString());
            reply.append("</record>");
        }
        return reply.toString();
    }

    private void createAttributeOutput(StringBuilder reply, String name, Object value) {
        if (value != null) {
            reply.append(" ");
            reply.append(name);
            reply.append("=\"");
            reply.append(value);
            reply.append("\"");
        }
    }

    public String toString() {
        return this.toXml(0);
    }
}

