/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.hibernate;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.Hibernate;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.hibernate.H2PropertyDescriptorProperty;

public class H2BeanConverter
extends BeanConverter
implements Converter {
    protected static Map methods = new HashMap();

    public Map getPropertyMapFromObject(Object example, boolean readRequired, boolean writeRequired) throws MarshallException {
        Class clazz = Hibernate.getClass((Object)example);
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            HashMap<String, H2PropertyDescriptorProperty> properties = new HashMap<String, H2PropertyDescriptorProperty>();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                if (name.equals("class") || !this.isAllowedByIncludeExcludeRules(name) || readRequired && descriptor.getReadMethod() == null || writeRequired && descriptor.getWriteMethod() == null) continue;
                properties.put(name, new H2PropertyDescriptorProperty(descriptor));
            }
            return properties;
        }
        catch (Exception ex) {
            throw new MarshallException(clazz, (Throwable)ex);
        }
    }

    protected Method findGetter(Object data, String property) throws IntrospectionException {
        String key = data.getClass().getName() + ":" + property;
        Method method = (Method)methods.get(key);
        if (method == null) {
            PropertyDescriptor[] props = Introspector.getBeanInfo(data.getClass()).getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equalsIgnoreCase(property)) continue;
                method = props[i].getReadMethod();
            }
            methods.put(key, method);
        }
        return method;
    }
}

