/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class ParseUtil {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$dwrp$ParseUtil == null ? (class$org$directwebremoting$dwrp$ParseUtil = ParseUtil.class$("org.directwebremoting.dwrp.ParseUtil")) : class$org$directwebremoting$dwrp$ParseUtil);
    static /* synthetic */ Class class$org$directwebremoting$dwrp$ParseUtil;

    public static Map parsePost(HttpServletRequest req) throws ServerException {
        HashMap paramMap = new HashMap();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(38) != -1) {
                    log.debug("Using iframe POST mode");
                    StringTokenizer st = new StringTokenizer(line, "&");
                    while (st.hasMoreTokens()) {
                        String part = st.nextToken();
                        part = LocalUtil.decode(part);
                        ParseUtil.parsePostLine(part, paramMap);
                    }
                    continue;
                }
                ParseUtil.parsePostLine(line, paramMap);
            }
        }
        catch (Exception ex) {
            throw new ServerException(Messages.getString("ParseUtil.InputReadFailed"), ex);
        }
        if (paramMap.size() == 1) {
            log.debug("Using Broken Safari POST mode");
            Iterator it = paramMap.keySet().iterator();
            if (!it.hasNext()) {
                throw new IllegalStateException("No entries in non empty map!");
            }
            String key = (String)it.next();
            String value = (String)paramMap.get(key);
            String line = key + "=" + value;
            StringTokenizer st = new StringTokenizer(line, "\n");
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                part = LocalUtil.decode(part);
                ParseUtil.parsePostLine(part, paramMap);
            }
        }
        return paramMap;
    }

    private static void parsePostLine(String line, Map paramMap) {
        if (line.length() == 0) {
            return;
        }
        int sep = line.indexOf("=");
        if (sep == -1) {
            log.warn("Missing separator in POST line: " + line);
        } else {
            String key = line.substring(0, sep);
            String value = line.substring(sep + "=".length());
            paramMap.put(key, value);
        }
    }

    public static Map parseGet(HttpServletRequest req) throws ServerException {
        HashMap<String, String> convertedMap = new HashMap<String, String>();
        Map paramMap = req.getParameterMap();
        Iterator it = paramMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String[] array = (String[])paramMap.get(key);
            if (array.length == 1) {
                convertedMap.put(key, array[0]);
                continue;
            }
            throw new ServerException(Messages.getString("ParseUtil.MultiValues", key));
        }
        return convertedMap;
    }

    public static String[] splitInbound(String data) {
        String[] reply = new String[2];
        int colon = data.indexOf(":");
        if (colon == -1) {
            log.error("Missing : in conversion data (" + data + ')');
            reply[0] = "string";
            reply[1] = data;
        } else {
            reply[0] = data.substring(0, colon);
            reply[1] = data.substring(colon + 1);
        }
        return reply;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

