/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.extend.DebugPageGenerator;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class DefaultDebugPageGenerator
implements DebugPageGenerator {
    protected String engineHandlerUrl;
    protected String utilHandlerUrl;
    protected String testHandlerUrl;
    protected String interfaceHandlerUrl;
    protected ConverterManager converterManager = null;
    protected CreatorManager creatorManager = null;
    protected AccessControl accessControl = null;
    private boolean allowImpossibleTests = false;
    protected final Map scriptCache = new HashMap();
    private Collection availableLibraries = null;
    private static final String PATH_UP = "..";
    public static final String BLANK = "";
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultDebugPageGenerator == null ? (class$org$directwebremoting$impl$DefaultDebugPageGenerator = DefaultDebugPageGenerator.class$("org.directwebremoting.impl.DefaultDebugPageGenerator")) : class$org$directwebremoting$impl$DefaultDebugPageGenerator);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultDebugPageGenerator;

    public String generateIndexPage(String root) throws SecurityException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            throw new SecurityException(Messages.getString("DefaultDebugPageGenerator.AccessDenied"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<head><title>DWR Test Index</title></head>\n");
        buffer.append("<body>\n");
        buffer.append("<h2>Classes known to DWR:</h2>\n");
        buffer.append("<ul>\n");
        Iterator it = this.creatorManager.getCreatorNames().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Creator creator = this.creatorManager.getCreator(name);
            buffer.append("<li><a href='");
            buffer.append(root);
            buffer.append(this.testHandlerUrl);
            buffer.append(name);
            buffer.append("'>");
            buffer.append(name);
            buffer.append("</a> (");
            buffer.append(creator.getType().getName());
            buffer.append(")</li>\n");
        }
        buffer.append("</ul>\n");
        buffer.append("</body></html>\n");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateTestPage(String root, String scriptName) throws SecurityException {
        if (!this.creatorManager.isDebug()) {
            log.warn("Failed attempt to access test pages outside of debug mode. Set the debug init-parameter to true to enable.");
            throw new SecurityException(Messages.getString("DefaultAccessControl.AccessDenied"));
        }
        String interfaceURL = root + this.interfaceHandlerUrl + scriptName + ".js";
        String engineURL = root + this.engineHandlerUrl;
        String utilURL = root + this.utilHandlerUrl;
        String proxyInterfaceURL = PATH_UP + this.interfaceHandlerUrl + scriptName + ".js";
        String proxyEngineURL = PATH_UP + this.engineHandlerUrl;
        String proxyUtilURL = PATH_UP + this.utilHandlerUrl;
        Creator creator = this.creatorManager.getCreator(scriptName);
        Method[] methods = creator.getType().getMethods();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<head>\n");
        buffer.append("  <title>DWR Test</title>\n");
        buffer.append("  <!-- These paths use .. so that they still work behind a path mapping proxy. The fully qualified version is more cut and paste friendly. -->\n");
        buffer.append("  <script type='text/javascript' src='" + proxyInterfaceURL + "'></script>\n");
        buffer.append("  <script type='text/javascript' src='" + proxyEngineURL + "'></script>\n");
        buffer.append("  <script type='text/javascript' src='" + proxyUtilURL + "'></script>\n");
        buffer.append("  <script type='text/javascript'>\n");
        buffer.append("  function objectEval(text)\n");
        buffer.append("  {\n");
        buffer.append("    // eval() breaks when we use it to get an object using the { a:42, b:'x' }\n");
        buffer.append("    // syntax because it thinks that { and } surround a block and not an object\n");
        buffer.append("    // So we wrap it in an array and extract the first element to get around\n");
        buffer.append("    // this.\n");
        buffer.append("    // This code is only needed for interpreting the parameter input fields,\n");
        buffer.append("    // so you can ignore this for normal use.\n");
        buffer.append("    // The regex = [start of line][whitespace]{[stuff]}[whitespace][end of line]\n");
        buffer.append("    text = text.replace(/\\n/g, ' ');\n");
        buffer.append("    text = text.replace(/\\r/g, ' ');\n");
        buffer.append("    if (text.match(/^\\s*\\{.*\\}\\s*$/))\n");
        buffer.append("    {\n");
        buffer.append("      text = '[' + text + '][0]';\n");
        buffer.append("    }\n");
        buffer.append("    return eval(text);\n");
        buffer.append("  }\n");
        buffer.append("  </script>\n");
        buffer.append("  <style>\n");
        buffer.append("    input.itext { font-size: smaller; background: #E4E4E4; border: 0; }\n");
        buffer.append("    input.ibutton { font-size: xx-small; border: 1px outset; margin: 0px; padding: 0px; }\n");
        buffer.append("    span.reply { background: #ffffdd; white-space: pre; }\n");
        buffer.append("    span.warning { font-size: smaller; color: red; }\n");
        buffer.append("  </style>\n");
        buffer.append("</head>\n");
        buffer.append("<body onload='dwr.util.useLoadingMessage()'>\n");
        buffer.append(BLANK);
        buffer.append("<h2>Methods For: " + scriptName + " (" + creator.getType().getName() + ")</h2>\n");
        buffer.append("<p>To use this class in your javascript you will need the following script includes:</p>\n");
        buffer.append("<pre>\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + interfaceURL + "'>" + interfaceURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + engineURL + "'>" + engineURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("</pre>\n");
        buffer.append("<p>In addition there is an optional utility script:</p>\n");
        buffer.append("<pre>\n");
        buffer.append("  &lt;script type='text/javascript' src='<a href='" + utilURL + "'>" + utilURL + "</a>'&gt;&lt;/script&gt;\n");
        buffer.append("</pre>\n");
        buffer.append("<p>Replies from DWR are shown with a yellow background if they are simple or in an alert box otherwise.<br/>\n");
        buffer.append("The inputs are evaluated as Javascript so strings must be quoted before execution.</p>\n");
        buffer.append("<p>There are " + methods.length + " declared methods:</p><ul>\n");
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Method method = methods[i];
            String methodName = method.getName();
            try {
                this.accessControl.assertIsDisplayable(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                buffer.append(BLANK);
                buffer.append("<li style='color: #A88;'>  " + methodName + "() is not available: " + ex.getMessage() + "</li>\n");
                if (!this.allowImpossibleTests) continue;
            }
            if (JavascriptUtil.isReservedWord(methodName)) {
                buffer.append(BLANK);
                buffer.append("<li style='color: #88A;'>" + methodName + "() is not available because it is a reserved word.</li>\n");
                continue;
            }
            buffer.append(BLANK);
            buffer.append("<li>\n");
            buffer.append("  " + methodName + '(');
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int j2 = 0; j2 < paramTypes.length; ++j2) {
                Class<?> paramType = paramTypes[j2];
                if (LocalUtil.isServletClass(paramType)) {
                    buffer.append("AUTO");
                } else {
                    String value = BLANK;
                    if (paramType == (class$java$lang$String == null ? DefaultDebugPageGenerator.class$("java.lang.String") : class$java$lang$String)) {
                        value = "\"\"";
                    } else if (paramType == (class$java$lang$Boolean == null ? DefaultDebugPageGenerator.class$("java.lang.Boolean") : class$java$lang$Boolean) || paramType == Boolean.TYPE) {
                        value = "true";
                    } else if (paramType == (class$java$lang$Integer == null ? DefaultDebugPageGenerator.class$("java.lang.Integer") : class$java$lang$Integer) || paramType == Integer.TYPE || paramType == (class$java$lang$Short == null ? DefaultDebugPageGenerator.class$("java.lang.Short") : class$java$lang$Short) || paramType == Short.TYPE || paramType == (class$java$lang$Long == null ? DefaultDebugPageGenerator.class$("java.lang.Long") : class$java$lang$Long) || paramType == Long.TYPE || paramType == (class$java$lang$Byte == null ? DefaultDebugPageGenerator.class$("java.lang.Byte") : class$java$lang$Byte) || paramType == Byte.TYPE) {
                        value = "0";
                    } else if (paramType == (class$java$lang$Float == null ? DefaultDebugPageGenerator.class$("java.lang.Float") : class$java$lang$Float) || paramType == Float.TYPE || paramType == (class$java$lang$Double == null ? DefaultDebugPageGenerator.class$("java.lang.Double") : class$java$lang$Double) || paramType == Double.TYPE) {
                        value = "0.0";
                    } else if (paramType.isArray() || (class$java$util$Collection == null ? DefaultDebugPageGenerator.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(paramType)) {
                        value = "[]";
                    } else if ((class$java$util$Map == null ? DefaultDebugPageGenerator.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(paramType)) {
                        value = "{}";
                    }
                    buffer.append("    <input class='itext' type='text' size='10' value='" + value + "' id='p" + i + j2 + "' title='Will be converted to: " + paramType.getName() + "'/>");
                }
                buffer.append(j2 == paramTypes.length - 1 ? BLANK : ", \n");
            }
            buffer.append("  );\n");
            String onclick = scriptName + '.' + methodName + "(";
            for (int j3 = 0; j3 < paramTypes.length; ++j3) {
                if (LocalUtil.isServletClass(paramTypes[j3])) continue;
                onclick = onclick + "objectEval($(\"p" + i + j3 + "\").value), ";
            }
            onclick = onclick + "reply" + i + ");";
            buffer.append("  <input class='ibutton' type='button' onclick='" + onclick + "' value='Execute'  title='Calls " + scriptName + '.' + methodName + "(). View source for details.'/>\n");
            buffer.append("  <script type='text/javascript'>\n");
            buffer.append("    var reply" + i + " = function(data)\n");
            buffer.append("    {\n");
            buffer.append("      if (data != null && typeof data == 'object') alert(dwr.util.toDescriptiveString(data, 2));\n");
            buffer.append("      else dwr.util.setValue('d" + i + "', dwr.util.toDescriptiveString(data, 1));\n");
            buffer.append("    }\n");
            buffer.append("  </script>\n");
            buffer.append("  <span id='d" + i + "' class='reply'></span>\n");
            boolean overloaded = false;
            for (j = 0; j < methods.length; ++j) {
                if (j == i || !methods[j].getName().equals(methodName)) continue;
                overloaded = true;
            }
            if (overloaded) {
                buffer.append("<br/><span class='warning'>(Warning: overloaded methods are not recommended. See <a href='#overloadedMethod'>below</a>)</span>\n");
            }
            for (j = 0; j < paramTypes.length; ++j) {
                if (this.converterManager.isConvertable(paramTypes[j])) continue;
                buffer.append("<br/><span class='warning'>(Warning: No Converter for " + paramTypes[j].getName() + ". See <a href='#missingConverter'>below</a>)</span>\n");
            }
            if (!this.converterManager.isConvertable(method.getReturnType())) {
                buffer.append("<br/><span class='warning'>(Warning: No Converter for " + method.getReturnType().getName() + ". See <a href='#missingConverter'>below</a>)</span>\n");
            }
            try {
                this.accessControl.assertExecutionIsPossible(creator, scriptName, method);
            }
            catch (SecurityException ex) {
                buffer.append("<br/><span class='warning'>(Security restructions in place: " + ex.getMessage() + ".)</span>\n");
            }
            buffer.append("</li>\n");
        }
        buffer.append(BLANK);
        buffer.append("</ul>\n");
        buffer.append("<h2>Other Links</h2>\n");
        buffer.append("<ul>\n");
        buffer.append("<li>Back to <a href='" + root + "/'>class index</a>.</li>\n");
        buffer.append("</ul>\n");
        Map map = this.scriptCache;
        synchronized (map) {
            String output = (String)this.scriptCache.get("/help.html");
            if (output == null) {
                InputStream raw = this.getClass().getResourceAsStream("/org/directwebremoting/help.html");
                if (raw == null) {
                    log.error(Messages.getString("DefaultProcessor.MissingHelp", "/help.html"));
                    output = "<p>Failed to read help text from resource file. Check dwr.jar is built to include html files.</p>";
                } else {
                    StringBuffer fileBuffer = new StringBuffer();
                    BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                    try {
                        String line;
                        while ((line = in.readLine()) != null) {
                            fileBuffer.append(line);
                            fileBuffer.append('\n');
                        }
                    }
                    catch (IOException ex) {
                        fileBuffer.append(ex.toString());
                        fileBuffer.append('\n');
                    }
                    output = fileBuffer.toString();
                }
                this.scriptCache.put("/help.html", output);
            }
            buffer.append(output);
        }
        buffer.append("</body></html>\n");
        return buffer.toString();
    }

    public String generateInterfaceUrl(String root, String scriptName) {
        return root + this.interfaceHandlerUrl + scriptName + ".js";
    }

    public String generateEngineUrl(String root) {
        return root + this.engineHandlerUrl;
    }

    public String generateLibraryUrl(String root, String library) {
        return root + library;
    }

    public Collection getAvailableLibraries() {
        if (this.availableLibraries == null) {
            this.availableLibraries = Collections.unmodifiableCollection(Arrays.asList(this.utilHandlerUrl));
        }
        return this.availableLibraries;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setCreatorManager(CreatorManager creatorManager) {
        this.creatorManager = creatorManager;
    }

    public void setAccessControl(AccessControl accessControl) {
        this.accessControl = accessControl;
    }

    public void setAllowImpossibleTests(boolean allowImpossibleTests) {
        this.allowImpossibleTests = allowImpossibleTests;
    }

    public void setEngineHandlerUrl(String engineHandlerUrl) {
        this.engineHandlerUrl = engineHandlerUrl;
    }

    public void setUtilHandlerUrl(String utilHandlerUrl) {
        this.utilHandlerUrl = utilHandlerUrl;
    }

    public void setTestHandlerUrl(String testHandlerUrl) {
        this.testHandlerUrl = testHandlerUrl;
    }

    public void setInterfaceHandlerUrl(String interfaceHandlerUrl) {
        this.interfaceHandlerUrl = interfaceHandlerUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

