/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.Messages;

public class Batch {
    private List inboundContexts = new ArrayList();
    private String scriptSessionId;
    private String httpSessionId;
    private String page;
    private Calls calls;
    private Map allParameters = new HashMap();
    private Map spareParameters = new HashMap();

    public Batch(HttpServletRequest request, boolean crossDomainSessionSecurity, boolean allowGetForSafariButMakeForgeryEasier) throws ServerException {
        boolean isGet = request.getMethod().equals("GET");
        if (isGet) {
            this.setAllParameters(ParseUtil.parseGet(request));
        } else {
            this.setAllParameters(ParseUtil.parsePost(request));
        }
        this.parseParameters();
        if (!allowGetForSafariButMakeForgeryEasier && isGet) {
            throw new SecurityException("GET Disalowed");
        }
        if (crossDomainSessionSecurity) {
            this.checkNotCsrfAttack(request);
        }
    }

    public Map getAllParameters() {
        return new HashMap(this.allParameters);
    }

    public void setAllParameters(Map allParameters) {
        this.allParameters = allParameters;
    }

    public List getInboundContexts() {
        return this.inboundContexts;
    }

    public void setInboundContexts(List inboundContexts) {
        this.inboundContexts = inboundContexts;
    }

    public Map getSpareParameters() {
        return this.spareParameters;
    }

    public void setSpareParameters(Map spareParameters) {
        this.spareParameters = spareParameters;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getScriptSessionId() {
        return this.scriptSessionId;
    }

    public void setScriptSessionId(String scriptSessionId) {
        this.scriptSessionId = scriptSessionId;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    public void setHttpSessionId(String httpSessionId) {
        this.httpSessionId = httpSessionId;
    }

    public Calls getCalls() {
        return this.calls;
    }

    public void setCalls(Calls calls) {
        this.calls = calls;
    }

    private void checkNotCsrfAttack(HttpServletRequest request) {
        String bodySessionId;
        String headerSessionId;
        if (request.isRequestedSessionIdValid() && request.isRequestedSessionIdFromCookie() && (headerSessionId = request.getRequestedSessionId()).length() > 0 && !(bodySessionId = this.getHttpSessionId()).startsWith(headerSessionId)) {
            throw new SecurityException("Session Error");
        }
    }

    protected void parseParameters() throws ServerException {
        int callCount;
        Map paramMap = this.getAllParameters();
        this.calls = new Calls();
        String callStr = (String)paramMap.remove("callCount");
        try {
            callCount = Integer.parseInt(callStr);
        }
        catch (NumberFormatException ex) {
            throw new ServerException(Messages.getString("BaseCallMarshaller.BadCallCount", callStr));
        }
        for (int callNum = 0; callNum < callCount; ++callNum) {
            Call call = new Call();
            this.calls.addCall(call);
            InboundContext inctx = new InboundContext();
            this.inboundContexts.add(inctx);
            String prefix = "c" + callNum + "-";
            call.setCallId((String)paramMap.remove(prefix + "id"));
            call.setScriptName((String)paramMap.remove(prefix + "scriptName"));
            call.setMethodName((String)paramMap.remove(prefix + "methodName"));
            Iterator it = paramMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(prefix)) continue;
                String data = (String)entry.getValue();
                String[] split = ParseUtil.splitInbound(data);
                String value = split[1];
                String type = split[0];
                inctx.createInboundVariable(callNum, key, type, value);
                it.remove();
            }
        }
        this.calls.setBatchId((String)paramMap.remove("batchId"));
        this.httpSessionId = (String)paramMap.remove("httpSessionId");
        this.scriptSessionId = (String)paramMap.remove("scriptSessionId");
        this.page = (String)paramMap.remove("page");
        this.setSpareParameters(paramMap);
    }
}

