/*
 * Decompiled with CFR 0.152.
 */
package org.getahead.dwrdemo.people;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.directwebremoting.util.Logger;
import org.getahead.dwrdemo.people.Person;

public class People {
    private Set people = new HashSet();
    private static int nextId = 1;
    private Random random = new Random();
    private static final String[] FIRSTNAMES = new String[]{"Fred", "Jim", "Shiela", "Jack", "Betty", "Jacob", "Martha", "Kelly", "Luke", "Matt", "Gemma", "Joe", "Ben", "Jessie", "Leanne", "Becky"};
    private static final String[] SURNAMES = new String[]{"Sutcliffe", "MacDonald", "Duckworth", "Smith", "Wisner", "Iversen", "Nield", "Turton", "Trelfer", "Wilson", "Johnson", "Cowan", "Daniels"};
    private static final String[] ROADS1 = new String[]{"Green", "Red", "Yellow", "Brown", "Blue", "Black", "White"};
    private static final String[] ROADS2 = new String[]{"Close", "Drive", "Street", "Avenue", "Crescent", "Road", "Place"};
    private static final String[] TOWNS = new String[]{"Birmingham", "Kettering", "Paris", "San Francisco", "New York", "San Mateo", "Barcelona"};
    private static final Logger log = Logger.getLogger(class$org$getahead$dwrdemo$people$People == null ? (class$org$getahead$dwrdemo$people$People = People.class$("org.getahead.dwrdemo.people.People")) : class$org$getahead$dwrdemo$people$People);
    static /* synthetic */ Class class$org$getahead$dwrdemo$people$People;

    public People() {
        log.debug("Generating a new set of random people");
        for (int i = 0; i < 5; ++i) {
            this.people.add(this.getRandomPerson());
        }
    }

    public Set getAllPeople() {
        return this.people;
    }

    public void setPerson(Person person) {
        log.debug("Adding person: " + person);
        if (person.getId() == -1) {
            person.setId(People.getNextId());
        }
        this.people.remove(person);
        this.people.add(person);
    }

    public void deletePerson(Person person) {
        log.debug("Removing person: " + person);
        this.people.remove(person);
        this.debug();
    }

    private Person getRandomPerson() {
        Person person = new Person();
        person.setId(People.getNextId());
        String firstname = FIRSTNAMES[this.random.nextInt(FIRSTNAMES.length)];
        String surname = SURNAMES[this.random.nextInt(SURNAMES.length)];
        person.setName(firstname + " " + surname);
        String housenum = this.random.nextInt(99) + 1 + " ";
        String road1 = ROADS1[this.random.nextInt(ROADS1.length)];
        String road2 = ROADS2[this.random.nextInt(ROADS2.length)];
        String town = TOWNS[this.random.nextInt(TOWNS.length)];
        String address = housenum + road1 + " " + road2 + ", " + town;
        person.setAddress(address);
        float salary = Math.round(10.0f + 90.0f * this.random.nextFloat()) * 1000;
        person.setSalary(salary);
        return person;
    }

    protected void debug() {
        Iterator it = this.people.iterator();
        while (it.hasNext()) {
            Person person = (Person)it.next();
            log.debug(person.toString());
        }
    }

    private static synchronized int getNextId() {
        return nextId++;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

