/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.directwebremoting.spring.ConverterConfig;
import org.directwebremoting.util.Logger;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ChildBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DwrNamespaceHandler
extends NamespaceHandlerSupport {
    protected static final String DEFAULT_SPRING_CONFIGURATOR_ID = "__dwrConfiguration";
    protected static final Logger log = Logger.getLogger(class$org$directwebremoting$spring$DwrNamespaceHandler == null ? (class$org$directwebremoting$spring$DwrNamespaceHandler = DwrNamespaceHandler.class$("org.directwebremoting.spring.DwrNamespaceHandler")) : class$org$directwebremoting$spring$DwrNamespaceHandler);
    private static final String ELEMENT_CONVERTER = "dwr:converter";
    private static final String ELEMENT_CREATOR = "dwr:creator";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    static /* synthetic */ Class class$org$directwebremoting$spring$SpringConfigurator;
    static /* synthetic */ Class class$org$directwebremoting$filter$ExtraLatencyAjaxFilter;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrController;
    static /* synthetic */ Class class$org$directwebremoting$spring$BeanCreator;
    static /* synthetic */ Class class$org$directwebremoting$spring$CreatorConfig;
    static /* synthetic */ Class class$org$directwebremoting$create$NewCreator;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrNamespaceHandler;

    public void init() {
        this.registerBeanDefinitionParser("configuration", new ConfigurationBeanDefinitionParser());
        this.registerBeanDefinitionParser("controller", new ControllerBeanDefinitionParser());
        this.registerBeanDefinitionDecorator("init", new InitDefinitionDecorator());
        this.registerBeanDefinitionDecorator("create", new CreatorBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("convert", new ConverterBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("signatures", new SignaturesBeanDefinitionDecorator());
        this.registerBeanDefinitionDecorator("remote", new RemoteBeanDefinitionDecorator());
    }

    protected BeanDefinition registerSpringConfiguratorIfNecessary(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$SpringConfigurator == null ? (class$org$directwebremoting$spring$SpringConfigurator = DwrNamespaceHandler.class$("org.directwebremoting.spring.SpringConfigurator")) : class$org$directwebremoting$spring$SpringConfigurator));
            builder.addPropertyValue("creators", (Object)new ManagedMap());
            builder.addPropertyValue("converters", (Object)new ManagedMap());
            registry.registerBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID, (BeanDefinition)builder.getBeanDefinition());
        }
        return registry.getBeanDefinition(DEFAULT_SPRING_CONFIGURATOR_ID);
    }

    protected void registerCreator(BeanDefinitionRegistry registry, String javascript, BeanDefinitionBuilder creatorConfig, Map params, NodeList children) {
        this.registerSpringConfiguratorIfNecessary(registry);
        ArrayList<String> includes = new ArrayList<String>();
        creatorConfig.addPropertyValue("includes", includes);
        ArrayList<String> excludes = new ArrayList<String>();
        creatorConfig.addPropertyValue("excludes", excludes);
        Properties auth = new Properties();
        creatorConfig.addPropertyValue("auth", (Object)auth);
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if (node.getNodeName().equals("dwr:latencyfilter")) {
                BeanDefinitionBuilder beanFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$filter$ExtraLatencyAjaxFilter == null ? DwrNamespaceHandler.class$("org.directwebremoting.filter.ExtraLatencyAjaxFilter") : class$org$directwebremoting$filter$ExtraLatencyAjaxFilter));
                beanFilter.addPropertyValue("delay", (Object)child.getAttribute("delay"));
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__latencyFilter_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__latencyFilter_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            if (node.getNodeName().equals("dwr:include")) {
                includes.add(child.getAttribute("method"));
                continue;
            }
            if (node.getNodeName().equals("dwr:exclude")) {
                excludes.add(child.getAttribute("method"));
                continue;
            }
            if (node.getNodeName().equals("dwr:auth")) {
                auth.setProperty(child.getAttribute("method"), child.getAttribute("role"));
                continue;
            }
            if (node.getNodeName().equals("dwr:convert")) {
                element = (Element)node;
                String type = element.getAttribute("type");
                String className = element.getAttribute(ATTRIBUTE_CLASS);
                ConverterConfig converterConfig = new ConverterConfig();
                converterConfig.setType(type);
                this.parseConverterSettings(converterConfig, element);
                this.lookupConverters(registry).put(className, converterConfig);
                continue;
            }
            if (node.getNodeName().equals("dwr:filter")) {
                BeanDefinitionBuilder beanFilter;
                element = (Element)node;
                String filterClass = element.getAttribute(ATTRIBUTE_CLASS);
                try {
                    beanFilter = BeanDefinitionBuilder.rootBeanDefinition((Class)ClassUtils.forName((String)filterClass));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("DWR filter class '" + filterClass + "' was not found. " + "Check the class name specified in <dwr:filter class=\"" + filterClass + "\" /> exists");
                }
                BeanDefinitionHolder holder2 = new BeanDefinitionHolder((BeanDefinition)beanFilter.getBeanDefinition(), "__filter_" + filterClass + "_" + javascript);
                BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder2, (BeanDefinitionRegistry)registry);
                ManagedList filterList = new ManagedList();
                filterList.add((Object)new RuntimeBeanReference("__filter_" + filterClass + "_" + javascript));
                creatorConfig.addPropertyValue("filters", (Object)filterList);
                continue;
            }
            if (node.getNodeName().equals("dwr:param")) {
                element = (Element)node;
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                params.put(name, value);
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was fouund: " + node.getNodeName());
        }
        creatorConfig.addPropertyValue("params", (Object)params);
        String creatorConfigName = "__" + javascript;
        BeanDefinitionHolder holder3 = new BeanDefinitionHolder((BeanDefinition)creatorConfig.getBeanDefinition(), creatorConfigName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder3, (BeanDefinitionRegistry)registry);
        this.lookupCreators(registry).put(javascript, new RuntimeBeanReference(creatorConfigName));
    }

    protected void parseConverterSettings(ConverterConfig converterConfig, Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
            Element child = (Element)node;
            if (child.getNodeName().equals("dwr:include")) {
                converterConfig.addInclude(child.getAttribute("method"));
                continue;
            }
            if (child.getNodeName().equals("dwr:exclude")) {
                converterConfig.addExclude(child.getAttribute("method"));
                continue;
            }
            throw new RuntimeException("an unknown dwr:remote sub node was found: " + node.getNodeName());
        }
    }

    protected Map lookupCreators(BeanDefinitionRegistry registry) {
        BeanDefinition config = this.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("creators").getValue();
    }

    protected Map lookupConverters(BeanDefinitionRegistry registry) {
        BeanDefinition config = this.registerSpringConfiguratorIfNecessary(registry);
        return (Map)config.getPropertyValues().getPropertyValue("converters").getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SignaturesBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected SignaturesBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition config = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(registry);
            StringBuffer sigtext = new StringBuffer();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    log.warn("Ignoring illegal node type: " + child.getNodeType());
                    continue;
                }
                sigtext.append(child.getNodeValue());
            }
            config.getPropertyValues().addPropertyValue("signatures", (Object)sigtext.toString());
            return definition;
        }
    }

    protected class CreatorBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected CreatorBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String javascript = element.getAttribute("javascript");
            String creatorType = element.getAttribute("type");
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$CreatorConfig == null ? (class$org$directwebremoting$spring$CreatorConfig = DwrNamespaceHandler.class$("org.directwebremoting.spring.CreatorConfig")) : class$org$directwebremoting$spring$CreatorConfig));
            HashMap<String, String> params = new HashMap<String, String>();
            if ("spring".equals(creatorType)) {
                BeanDefinitionBuilder springCreator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$BeanCreator == null ? (class$org$directwebremoting$spring$BeanCreator = DwrNamespaceHandler.class$("org.directwebremoting.spring.BeanCreator")) : class$org$directwebremoting$spring$BeanCreator));
                springCreator.addPropertyValue("javascript", (Object)javascript);
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    if (childNode.getNodeType() == 3 || childNode.getNodeType() == 8) continue;
                    Element child = (Element)childNode;
                    String paramName = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    if ("beanName".equals(paramName) || "beanId".equals(paramName)) {
                        springCreator.addPropertyValue("beanId", (Object)value);
                        continue;
                    }
                    params.put(paramName, value);
                }
                creatorConfig.addPropertyValue("creator", (Object)springCreator.getBeanDefinition());
            } else if ("new".equals(creatorType)) {
                BeanDefinitionBuilder creator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$create$NewCreator == null ? (class$org$directwebremoting$create$NewCreator = DwrNamespaceHandler.class$("org.directwebremoting.create.NewCreator")) : class$org$directwebremoting$create$NewCreator));
                creator.addPropertyValue("className", (Object)node.getAttributes().getNamedItem(DwrNamespaceHandler.ATTRIBUTE_CLASS).getNodeValue());
                creator.addPropertyValue("javascript", (Object)javascript);
                creatorConfig.addPropertyValue("creator", (Object)creator.getBeanDefinition());
            } else if ("null".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)"none");
                String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                if (className == null || "".equals(className)) {
                    throw new BeanInitializationException("'class' is a required attribute for the declaration <dwr:creator type=\"null\" javascript=\"" + javascript + "\" ... />");
                }
                params.put(DwrNamespaceHandler.ATTRIBUTE_CLASS, className);
            } else if ("pageflow".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)creatorType);
            } else if ("jsf".equals(creatorType) || "scripted".equals(creatorType) || "struts".equals(creatorType)) {
                creatorConfig.addPropertyValue("creatorType", (Object)creatorType);
            } else {
                BeanDefinition configurator;
                PropertyValue registeredCreators;
                Map registeredCreatorMap;
                String creatorClass;
                if (log.isDebugEnabled()) {
                    log.debug("Looking up creator type '" + creatorType + "'");
                }
                if ((creatorClass = (String)(registeredCreatorMap = (Map)(registeredCreators = (configurator = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(parserContext.getRegistry())).getPropertyValues().getPropertyValue("creatorTypes")).getValue()).get(creatorType)) == null) {
                    throw new UnsupportedOperationException("Type " + creatorType + " is not supported " + " or the custom creator has not been registered dwr:init");
                }
                try {
                    Class<?> clazz = Class.forName(creatorClass);
                    BeanDefinitionBuilder creator = BeanDefinitionBuilder.rootBeanDefinition(clazz);
                    creatorConfig.addPropertyValue("creator", (Object)creator.getBeanDefinition());
                    String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    if (StringUtils.hasText((String)className)) {
                        params.put(DwrNamespaceHandler.ATTRIBUTE_CLASS, className);
                    }
                }
                catch (ClassNotFoundException ex) {
                    throw new FatalBeanException("ClassNotFoundException trying to register  creator '" + creatorClass + "' for javascript type '" + javascript + "'. Check the " + " class in the classpath and that the creator is register in dwr:init", (Throwable)ex);
                }
            }
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creatorConfig, params, node.getChildNodes());
            return definition;
        }
    }

    protected class InitDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected InitDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node parent, BeanDefinitionHolder definition, ParserContext parserContext) {
            HashMap<String, String> converters = new HashMap<String, String>();
            HashMap<String, String> creators = new HashMap<String, String>();
            NodeList inits = parent.getChildNodes();
            for (int j = 0; j < inits.getLength(); ++j) {
                String className;
                String id;
                Node node = inits.item(j);
                if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
                Element child = (Element)inits.item(j);
                if (child.getNodeName().equals(DwrNamespaceHandler.ELEMENT_CREATOR)) {
                    id = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
                    className = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    creators.put(id, className);
                    continue;
                }
                if (child.getNodeName().equals(DwrNamespaceHandler.ELEMENT_CONVERTER)) {
                    id = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
                    className = child.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
                    converters.put(id, className);
                    continue;
                }
                throw new RuntimeException("An unknown sub node '" + child.getNodeName() + "' was found while parsing dwr:init");
            }
            BeanDefinition configurator = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(parserContext.getRegistry());
            configurator.getPropertyValues().addPropertyValue("creatorTypes", creators);
            configurator.getPropertyValues().addPropertyValue("converterTypes", converters);
            return definition;
        }
    }

    protected class ConverterBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected ConverterBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String type = element.getAttribute("type");
            String className = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_CLASS);
            String javascriptClassName = element.getAttribute("javascript");
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            ConverterConfig converterConfig = new ConverterConfig();
            converterConfig.setType(type);
            converterConfig.setJavascriptClassName(javascriptClassName);
            DwrNamespaceHandler.this.parseConverterSettings(converterConfig, element);
            DwrNamespaceHandler.this.lookupConverters(registry).put(className, converterConfig);
            return definition;
        }
    }

    protected class RemoteBeanDefinitionDecorator
    implements BeanDefinitionDecorator {
        protected RemoteBeanDefinitionDecorator() {
        }

        public BeanDefinitionHolder decorate(Node node, BeanDefinitionHolder definition, ParserContext parserContext) {
            Element element = (Element)node;
            String javascript = element.getAttribute("javascript");
            BeanDefinitionBuilder beanCreator = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$BeanCreator == null ? (class$org$directwebremoting$spring$BeanCreator = DwrNamespaceHandler.class$("org.directwebremoting.spring.BeanCreator")) : class$org$directwebremoting$spring$BeanCreator));
            try {
                String beanClassName = this.resolveBeanClassname(definition.getBeanDefinition(), parserContext.getRegistry());
                if (beanClassName == null) {
                    throw new FatalBeanException("Unabled to find type for beanName '" + definition.getBeanName() + "'. " + "Check your bean has a correctly configured parent or provide a class for " + " the bean definition");
                }
                beanCreator.addPropertyValue("beanClass", (Object)ClassUtils.forName((String)beanClassName));
            }
            catch (ClassNotFoundException e) {
                throw new FatalBeanException("Unable to create DWR bean creator for '" + definition.getBeanName() + "'.", (Throwable)e);
            }
            String name = definition.getBeanName();
            if (name.startsWith("scopedTarget.")) {
                name = name.substring(name.indexOf(".") + 1);
            }
            beanCreator.addPropertyValue("beanId", (Object)name);
            beanCreator.addPropertyValue("javascript", (Object)javascript);
            BeanDefinitionBuilder creatorConfig = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$CreatorConfig == null ? (class$org$directwebremoting$spring$CreatorConfig = DwrNamespaceHandler.class$("org.directwebremoting.spring.CreatorConfig")) : class$org$directwebremoting$spring$CreatorConfig));
            creatorConfig.addPropertyValue("creator", (Object)beanCreator.getBeanDefinition());
            DwrNamespaceHandler.this.registerCreator(parserContext.getRegistry(), javascript, creatorConfig, new HashMap(), node.getChildNodes());
            return definition;
        }

        private String resolveBeanClassname(BeanDefinition definition, BeanDefinitionRegistry registry) {
            String beanClassName = definition.getBeanClassName();
            if (!StringUtils.hasText((String)beanClassName)) {
                while (definition instanceof ChildBeanDefinition) {
                    String parentName = ((ChildBeanDefinition)definition).getParentName();
                    BeanDefinition parentDefinition = this.findParentDefinition(parentName, registry);
                    if (parentDefinition == null) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("No parent bean named '" + parentName + "' could be found in the " + "hierarchy of BeanFactorys. Check you've defined a bean called '" + parentName + "'");
                        break;
                    }
                    beanClassName = parentDefinition.getBeanClassName();
                    if (StringUtils.hasText((String)beanClassName)) break;
                    definition = parentDefinition;
                }
            }
            return beanClassName;
        }

        private BeanDefinition findParentDefinition(String parentName, BeanDefinitionRegistry registry) {
            if (registry != null) {
                if (registry.containsBeanDefinition(parentName)) {
                    return registry.getBeanDefinition(parentName);
                }
                if (registry instanceof HierarchicalBeanFactory) {
                    BeanFactory parentBeanFactory = ((HierarchicalBeanFactory)registry).getParentBeanFactory();
                    return this.findParentDefinition(parentName, (BeanDefinitionRegistry)parentBeanFactory);
                }
            }
            return null;
        }
    }

    protected class ControllerBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ControllerBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder dwrController = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$directwebremoting$spring$DwrController == null ? (class$org$directwebremoting$spring$DwrController = DwrNamespaceHandler.class$("org.directwebremoting.spring.DwrController")) : class$org$directwebremoting$spring$DwrController));
            ManagedList configurators = new ManagedList();
            configurators.add(new RuntimeBeanReference(DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID));
            dwrController.addPropertyValue("configurators", (Object)configurators);
            String debug = element.getAttribute("debug");
            if (StringUtils.hasText((String)debug)) {
                dwrController.addPropertyValue("debug", (Object)debug);
            }
            String beanName = element.getAttribute(DwrNamespaceHandler.ATTRIBUTE_ID);
            String nameAttr = element.getAttribute("name");
            String[] aliases = null;
            if (!StringUtils.hasText((String)beanName)) {
                beanName = element.getAttribute("name");
            } else {
                String aliasName = element.getAttribute("name");
                if (StringUtils.hasText((String)aliasName)) {
                    aliases = StringUtils.tokenizeToStringArray((String)nameAttr, (String)",; ");
                }
            }
            this.parseControllerParameters(dwrController, element);
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)dwrController.getBeanDefinition(), beanName, aliases);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)parserContext.getRegistry());
            return dwrController.getBeanDefinition();
        }

        protected void parseControllerParameters(BeanDefinitionBuilder dwrControllerDefinition, Element parent) {
            NodeList children = parent.getChildNodes();
            HashMap<String, String> params = new HashMap<String, String>();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (node.getNodeType() == 3 || node.getNodeType() == 8) continue;
                Element child = (Element)node;
                if (child.getNodeName().equals("dwr:config-param")) {
                    String paramName = child.getAttribute("name");
                    String value = child.getAttribute("value");
                    params.put(paramName, value);
                    continue;
                }
                throw new RuntimeException("an unknown dwr:controller sub node was found: " + node.getNodeName());
            }
            dwrControllerDefinition.addPropertyValue("configParams", params);
        }
    }

    protected class ConfigurationBeanDefinitionParser
    implements BeanDefinitionParser {
        protected ConfigurationBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            BeanDefinitionRegistry registry = parserContext.getRegistry();
            BeanDefinition beanDefinition = DwrNamespaceHandler.this.registerSpringConfiguratorIfNecessary(registry);
            Element initElement = DomUtils.getChildElementByTagName((Element)element, (String)"init");
            if (initElement != null) {
                DwrNamespaceHandler.this.decorate(initElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List createElements = DomUtils.getChildElementsByTagName((Element)element, (String)"create");
            Iterator iter = createElements.iterator();
            while (iter.hasNext()) {
                Element createElement = (Element)iter.next();
                DwrNamespaceHandler.this.decorate(createElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List convertElements = DomUtils.getChildElementsByTagName((Element)element, (String)"convert");
            iter = convertElements.iterator();
            while (iter.hasNext()) {
                Element convertElement = (Element)iter.next();
                DwrNamespaceHandler.this.decorate(convertElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            List signatureElements = DomUtils.getChildElementsByTagName((Element)element, (String)"signatures");
            Iterator i = signatureElements.iterator();
            while (i.hasNext()) {
                Element signatureElement = (Element)i.next();
                DwrNamespaceHandler.this.decorate(signatureElement, new BeanDefinitionHolder(beanDefinition, DwrNamespaceHandler.DEFAULT_SPRING_CONFIGURATOR_ID), parserContext);
            }
            return beanDefinition;
        }
    }
}

