/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.Logger;

public final class LocalUtil {
    public static final int INBOUND_INDEX_TYPE = 0;
    public static final int INBOUND_INDEX_VALUE = 1;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$util$LocalUtil == null ? (class$org$directwebremoting$util$LocalUtil = LocalUtil.class$("org.directwebremoting.util.LocalUtil")) : class$org$directwebremoting$util$LocalUtil);
    private static boolean warn13 = false;
    private static boolean testedDecoder = false;
    private static Method decode14 = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    static /* synthetic */ Class class$javax$servlet$ServletConfig;
    static /* synthetic */ Class class$javax$servlet$ServletContext;
    static /* synthetic */ Class class$javax$servlet$http$HttpSession;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URLDecoder;
    static /* synthetic */ Class class$org$directwebremoting$util$LocalUtil;

    private LocalUtil() {
    }

    public static String replace(String text, String repl, String with) {
        int foundAt;
        if (text == null || repl == null || with == null || repl.length() == 0) {
            return text;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int searchFrom = 0;
        while ((foundAt = text.indexOf(repl, searchFrom)) != -1) {
            buf.append(text.substring(searchFrom, foundAt)).append(with);
            searchFrom = foundAt + repl.length();
        }
        buf.append(text.substring(searchFrom));
        return buf.toString();
    }

    public static boolean isJavaIdentifier(String test) {
        if (test == null || test.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(test.charAt(0))) {
            return false;
        }
        for (int i = 1; i < test.length(); ++i) {
            if (Character.isJavaIdentifierPart(test.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquivalent(Class c1, Class c2) {
        if (c1 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LocalUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c1 == Boolean.TYPE) {
            return c2 == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LocalUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c2 == Boolean.TYPE;
        }
        if (c1 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LocalUtil.class$("java.lang.Byte")) : class$java$lang$Byte) || c1 == Byte.TYPE) {
            return c2 == (class$java$lang$Byte == null ? (class$java$lang$Byte = LocalUtil.class$("java.lang.Byte")) : class$java$lang$Byte) || c2 == Byte.TYPE;
        }
        if (c1 == (class$java$lang$Character == null ? (class$java$lang$Character = LocalUtil.class$("java.lang.Character")) : class$java$lang$Character) || c1 == Character.TYPE) {
            return c2 == (class$java$lang$Character == null ? (class$java$lang$Character = LocalUtil.class$("java.lang.Character")) : class$java$lang$Character) || c2 == Character.TYPE;
        }
        if (c1 == (class$java$lang$Short == null ? (class$java$lang$Short = LocalUtil.class$("java.lang.Short")) : class$java$lang$Short) || c1 == Short.TYPE) {
            return c2 == (class$java$lang$Short == null ? (class$java$lang$Short = LocalUtil.class$("java.lang.Short")) : class$java$lang$Short) || c2 == Short.TYPE;
        }
        if (c1 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LocalUtil.class$("java.lang.Integer")) : class$java$lang$Integer) || c1 == Integer.TYPE) {
            return c2 == (class$java$lang$Integer == null ? (class$java$lang$Integer = LocalUtil.class$("java.lang.Integer")) : class$java$lang$Integer) || c2 == Integer.TYPE;
        }
        if (c1 == (class$java$lang$Long == null ? (class$java$lang$Long = LocalUtil.class$("java.lang.Long")) : class$java$lang$Long) || c1 == Long.TYPE) {
            return c2 == (class$java$lang$Long == null ? (class$java$lang$Long = LocalUtil.class$("java.lang.Long")) : class$java$lang$Long) || c2 == Long.TYPE;
        }
        if (c1 == (class$java$lang$Float == null ? (class$java$lang$Float = LocalUtil.class$("java.lang.Float")) : class$java$lang$Float) || c1 == Float.TYPE) {
            return c2 == (class$java$lang$Float == null ? (class$java$lang$Float = LocalUtil.class$("java.lang.Float")) : class$java$lang$Float) || c2 == Float.TYPE;
        }
        if (c1 == (class$java$lang$Double == null ? (class$java$lang$Double = LocalUtil.class$("java.lang.Double")) : class$java$lang$Double) || c1 == Double.TYPE) {
            return c2 == (class$java$lang$Double == null ? (class$java$lang$Double = LocalUtil.class$("java.lang.Double")) : class$java$lang$Double) || c2 == Double.TYPE;
        }
        if (c1 == (class$java$lang$Void == null ? (class$java$lang$Void = LocalUtil.class$("java.lang.Void")) : class$java$lang$Void) || c1 == Void.TYPE) {
            return c2 == (class$java$lang$Void == null ? (class$java$lang$Void = LocalUtil.class$("java.lang.Void")) : class$java$lang$Void) || c2 == Void.TYPE;
        }
        return false;
    }

    public static Class getNonPrimitiveType(Class type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = LocalUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (type == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = LocalUtil.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (type == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = LocalUtil.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (type == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = LocalUtil.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (type == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = LocalUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (type == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = LocalUtil.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (type == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = LocalUtil.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (type == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = LocalUtil.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (type == Void.TYPE) {
            return class$java$lang$Void == null ? (class$java$lang$Void = LocalUtil.class$("java.lang.Void")) : class$java$lang$Void;
        }
        return null;
    }

    public static void addNoCacheHeaders(HttpServletResponse resp) {
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        resp.addHeader("Cache-Control", "post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
    }

    public static boolean isServletClass(Class paramType) {
        return paramType == (class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = LocalUtil.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest) || paramType == (class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = LocalUtil.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse) || paramType == (class$javax$servlet$ServletConfig == null ? (class$javax$servlet$ServletConfig = LocalUtil.class$("javax.servlet.ServletConfig")) : class$javax$servlet$ServletConfig) || paramType == (class$javax$servlet$ServletContext == null ? (class$javax$servlet$ServletContext = LocalUtil.class$("javax.servlet.ServletContext")) : class$javax$servlet$ServletContext) || paramType == (class$javax$servlet$http$HttpSession == null ? (class$javax$servlet$http$HttpSession = LocalUtil.class$("javax.servlet.http.HttpSession")) : class$javax$servlet$http$HttpSession);
    }

    public static String decode(String value) {
        if (!testedDecoder) {
            block6: {
                try {
                    decode14 = (class$java$net$URLDecoder == null ? (class$java$net$URLDecoder = LocalUtil.class$("java.net.URLDecoder")) : class$java$net$URLDecoder).getMethod("decode", class$java$lang$String == null ? (class$java$lang$String = LocalUtil.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = LocalUtil.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (Exception ex) {
                    if (warn13) break block6;
                    log.warn("URLDecoder.decode(String, String) is not available. Falling back to 1.3 variant.");
                    warn13 = true;
                }
            }
            testedDecoder = true;
        }
        if (decode14 != null) {
            try {
                return (String)decode14.invoke(null, value, "UTF-8");
            }
            catch (Exception ex) {
                log.warn("Failed to use JDK 1.4 decoder", ex);
            }
        }
        return URLDecoder.decode(value);
    }

    public static void setParams(Object object, Map params, List ignore) {
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(object, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (ignore == null || ignore.contains(key)) continue;
                log.warn("No property '" + key + "' on " + object.getClass().getName());
            }
            catch (InvocationTargetException ex) {
                log.warn("Error setting " + key + "=" + value + " on " + object.getClass().getName(), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn("Error setting " + key + "=" + value + " on " + object.getClass().getName(), ex);
            }
        }
    }

    public static void setProperty(Object object, String key, Object value) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> real = object.getClass();
        String setterName = "set" + key.substring(0, 1).toUpperCase(Locale.ENGLISH) + key.substring(1);
        try {
            Method method = real.getMethod(setterName, value.getClass());
            method.invoke(object, value);
            return;
        }
        catch (NoSuchMethodException ex) {
            if (!(value instanceof String)) {
                throw ex;
            }
            Method[] methods = real.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method setter = methods[i];
                if (!setter.getName().equals(setterName) || setter.getParameterTypes().length != 1) continue;
                Class<?> propertyType = setter.getParameterTypes()[0];
                try {
                    Object param = LocalUtil.simpleConvert((String)value, propertyType);
                    setter.invoke(object, param);
                    return;
                }
                catch (IllegalArgumentException ex2) {
                    // empty catch block
                }
            }
            throw new NoSuchMethodException("Failed to find a property called: " + key + " on " + object.getClass().getName());
        }
    }

    public static boolean isTypeSimplyConvertable(Class paramType) {
        return paramType == (class$java$lang$String == null ? (class$java$lang$String = LocalUtil.class$("java.lang.String")) : class$java$lang$String) || paramType == (class$java$lang$Integer == null ? (class$java$lang$Integer = LocalUtil.class$("java.lang.Integer")) : class$java$lang$Integer) || paramType == Integer.TYPE || paramType == (class$java$lang$Short == null ? (class$java$lang$Short = LocalUtil.class$("java.lang.Short")) : class$java$lang$Short) || paramType == Short.TYPE || paramType == (class$java$lang$Byte == null ? (class$java$lang$Byte = LocalUtil.class$("java.lang.Byte")) : class$java$lang$Byte) || paramType == Byte.TYPE || paramType == (class$java$lang$Long == null ? (class$java$lang$Long = LocalUtil.class$("java.lang.Long")) : class$java$lang$Long) || paramType == Long.TYPE || paramType == (class$java$lang$Float == null ? (class$java$lang$Float = LocalUtil.class$("java.lang.Float")) : class$java$lang$Float) || paramType == Float.TYPE || paramType == (class$java$lang$Double == null ? (class$java$lang$Double = LocalUtil.class$("java.lang.Double")) : class$java$lang$Double) || paramType == Double.TYPE || paramType == (class$java$lang$Character == null ? (class$java$lang$Character = LocalUtil.class$("java.lang.Character")) : class$java$lang$Character) || paramType == Character.TYPE || paramType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LocalUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean) || paramType == Boolean.TYPE;
    }

    public static Object simpleConvert(String value, Class paramType) {
        if (paramType == (class$java$lang$String == null ? (class$java$lang$String = LocalUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return value;
        }
        if (paramType == (class$java$lang$Character == null ? (class$java$lang$Character = LocalUtil.class$("java.lang.Character")) : class$java$lang$Character) || paramType == Character.TYPE) {
            if (value.length() == 1) {
                return new Character(value.charAt(0));
            }
            throw new IllegalArgumentException("Can't more than one character in string - can't convert to char: '" + value + "'");
        }
        String trimValue = value.trim();
        if (paramType == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = LocalUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Boolean.valueOf(trimValue);
        }
        if (paramType == Boolean.TYPE) {
            return Boolean.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Integer == null ? (class$java$lang$Integer = LocalUtil.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Integer.valueOf(trimValue);
        }
        if (paramType == Integer.TYPE) {
            if (trimValue.length() == 0) {
                return new Integer(0);
            }
            return Integer.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Short == null ? (class$java$lang$Short = LocalUtil.class$("java.lang.Short")) : class$java$lang$Short)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Short.valueOf(trimValue);
        }
        if (paramType == Short.TYPE) {
            if (trimValue.length() == 0) {
                return new Short(0);
            }
            return Short.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Byte == null ? (class$java$lang$Byte = LocalUtil.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Byte.valueOf(trimValue);
        }
        if (paramType == Byte.TYPE) {
            if (trimValue.length() == 0) {
                return new Byte(0);
            }
            return Byte.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Long == null ? (class$java$lang$Long = LocalUtil.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Long.valueOf(trimValue);
        }
        if (paramType == Long.TYPE) {
            if (trimValue.length() == 0) {
                return new Long(0L);
            }
            return Long.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Float == null ? (class$java$lang$Float = LocalUtil.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Float.valueOf(trimValue);
        }
        if (paramType == Float.TYPE) {
            if (trimValue.length() == 0) {
                return new Float(0.0f);
            }
            return Float.valueOf(trimValue);
        }
        if (paramType == (class$java$lang$Double == null ? (class$java$lang$Double = LocalUtil.class$("java.lang.Double")) : class$java$lang$Double)) {
            if (trimValue.length() == 0) {
                return null;
            }
            return Double.valueOf(trimValue);
        }
        if (paramType == Double.TYPE) {
            if (trimValue.length() == 0) {
                return new Double(0.0);
            }
            return Double.valueOf(trimValue);
        }
        throw new IllegalArgumentException("Unsupported conversion type: " + paramType.getName());
    }

    public static String getShortClassName(Class clazz) {
        String className = clazz.getName();
        char[] chars = className.toCharArray();
        int lastDot = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '.') {
                lastDot = i + 1;
                continue;
            }
            if (chars[i] != '$') continue;
            chars[i] = 46;
        }
        return new String(chars, lastDot, chars.length - lastDot);
    }

    public static boolean isSimpleName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (JavascriptUtil.isReservedWord(name)) {
            return false;
        }
        boolean isSimple = Character.isLetter(name.charAt(0));
        for (int i = 1; isSimple && i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            isSimple = false;
        }
        return isSimple;
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    public static Object invoke(Object object, Method method, Object[] params) throws IllegalStateException {
        Object reply = null;
        if (method != null) {
            try {
                reply = method.invoke(object, params);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException("InvocationTargetException calling " + method.getName() + ": " + ex.getTargetException().toString());
            }
            catch (Exception ex) {
                throw new IllegalStateException("Reflection error calling " + method.getName() + ": " + ex.toString());
            }
        }
        return reply;
    }

    public static Class classForName(String name, String className, Class impl) {
        Class clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug("Skipping '" + name + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug("Skipping '" + name + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug("Skipping '" + name + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage());
            log.debug("Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'.");
            return null;
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error("InstantiationException for '" + name + "' failed:", ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error("IllegalAccessException for '" + name + "' failed:", ex);
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug("Skipping '" + name + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug("Skipping '" + name + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage());
            log.debug("Maybe you need to add xalan.jar to your webserver?");
            return null;
        }
        catch (Exception ex) {
            if (ex instanceof ClassNotFoundException) {
                log.debug("Skipping '" + name + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage());
                return null;
            }
            log.error("Failed to load '" + name + "' (" + className + ")", ex);
            return null;
        }
        return clazz;
    }

    public static Object classNewInstance(String name, String className, Class impl) {
        Class clazz;
        try {
            clazz = LocalUtil.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            log.debug("Skipping '" + name + "' due to ClassNotFoundException on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        catch (NoClassDefFoundError ex) {
            log.debug("Skipping '" + name + "' due to NoClassDefFoundError on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.debug("Skipping '" + name + "' due to TransformerFactoryConfigurationError on " + className + ". Cause: " + ex.getMessage());
            return null;
        }
        if (!impl.isAssignableFrom(clazz)) {
            log.error("Class '" + clazz.getName() + "' does not implement '" + impl.getName() + "'.");
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            log.error("InstantiationException for '" + name + "' failed:", ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            log.error("IllegalAccessException for '" + name + "' failed:", ex);
            return null;
        }
        catch (TransformerFactoryConfigurationError ex) {
            log.error("TransformerFactoryConfigurationError for '" + name + "' failed:", ex);
            return null;
        }
        catch (Exception ex) {
            log.error("Failed to load creator '" + name + "', classname=" + className + ": ", ex);
            return null;
        }
    }

    public static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    public static void close(RandomAccessFile in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
    }

    public static List getAllSuperclasses(Class clazz) {
        ArrayList classes = new ArrayList();
        for (Class superclass = clazz.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Field[] getAllFields(Class clazz) {
        List classes = LocalUtil.getAllSuperclasses(clazz);
        classes.add(clazz);
        return LocalUtil.getAllFields(classes);
    }

    private static Field[] getAllFields(List classes) {
        HashSet<Field> fields = new HashSet<Field>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields.toArray(new Field[fields.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

