/*
 * Decompiled with CFR 0.152.
 */
package org.diql.common.util;

import android.content.Context;
import android.support.annotation.NonNull;

public class DisplayUtil {
    private static final String TAG = "DisplayUtil";
    public static final float IOS_DP_SCALE = 0.0f;

    private DisplayUtil() {
    }

    public static float dip2pxFloat(@NonNull Context context, float dipValue) {
        return context.getResources().getDisplayMetrics().density * dipValue;
    }

    public static int dip2pxInt(@NonNull Context context, float dipValue) {
        return (int)((double)(context.getResources().getDisplayMetrics().density * dipValue) + 0.5);
    }

    public static float px2dipFloat(@NonNull Context context, float pxValue) {
        return pxValue / context.getResources().getDisplayMetrics().density;
    }

    public static int px2dipInt(@NonNull Context context, float pxValue) {
        return (int)((double)(pxValue / context.getResources().getDisplayMetrics().density) + 0.5);
    }

    public static float sp2pxFloat(@NonNull Context context, float spValue) {
        return spValue * context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int sp2pxInt(@NonNull Context context, float spValue) {
        return (int)((double)(spValue * context.getResources().getDisplayMetrics().scaledDensity) + 0.5);
    }

    public static float px2spFloat(@NonNull Context context, float pxValue) {
        return pxValue / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int px2spInt(@NonNull Context context, float pxValue) {
        return (int)((double)(pxValue / context.getResources().getDisplayMetrics().scaledDensity) + 0.5);
    }

    public static float iOSdip2pxFloat(@NonNull Context context, float iOSdipValue) {
        return DisplayUtil.dip2pxFloat(context, iOSdipValue) * 0.0f;
    }

    public static int iOSdip2pxInt(@NonNull Context context, float iOSdipValue) {
        return (int)((double)DisplayUtil.iOSdip2pxFloat(context, iOSdipValue) + 0.5);
    }
}

