/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.validation;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.model.x509.revocation.crl.CRL;
import eu.europa.esig.dss.model.x509.revocation.ocsp.OCSP;
import eu.europa.esig.dss.spi.x509.revocation.RevocationSource;
import eu.europa.esig.dss.spi.x509.revocation.RevocationToken;
import eu.europa.esig.dss.validation.RevocationDataVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevocationDataLoadingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RevocationDataLoadingStrategy.class);
    protected RevocationSource<CRL> crlSource;
    protected RevocationSource<OCSP> ocspSource;
    protected RevocationDataVerifier revocationDataVerifier;
    protected boolean fallbackEnabled = false;

    protected RevocationDataLoadingStrategy() {
    }

    void setCrlSource(RevocationSource<CRL> crlSource) {
        this.crlSource = crlSource;
    }

    void setOcspSource(RevocationSource<OCSP> ocspSource) {
        this.ocspSource = ocspSource;
    }

    void setRevocationDataVerifier(RevocationDataVerifier revocationDataVerifier) {
        this.revocationDataVerifier = revocationDataVerifier;
    }

    void setFallbackEnabled(boolean fallbackEnabled) {
        this.fallbackEnabled = fallbackEnabled;
    }

    public abstract RevocationToken getRevocationToken(CertificateToken var1, CertificateToken var2);

    protected RevocationToken<CRL> checkCRL(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.crlSource == null) {
            LOG.debug("CRLSource is null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRL request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.crlSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.crlSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CRL for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("CRL DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A CRL for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    protected RevocationToken<OCSP> checkOCSP(CertificateToken certificateToken, CertificateToken issuerToken) {
        if (this.ocspSource == null) {
            LOG.debug("OCSPSource null");
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("OCSP request for: {} using: {}", (Object)certificateToken.getDSSIdAsString(), (Object)this.ocspSource.getClass().getSimpleName());
        }
        try {
            RevocationToken revocationToken = this.ocspSource.getRevocationToken(certificateToken, issuerToken);
            if (revocationToken != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("OCSP response for {} retrieved: {}", (Object)certificateToken.getDSSIdAsString(), (Object)revocationToken.getAbbreviation());
                    LOG.debug("OCSP Response {} status is : {}", (Object)revocationToken.getDSSIdAsString(), (Object)revocationToken.getStatus());
                }
                return revocationToken;
            }
        }
        catch (DSSException e) {
            LOG.error("OCSP DSS Exception: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("An OCSP response for token {} is not obtained! Return null value.", (Object)certificateToken.getDSSIdAsString());
        }
        return null;
    }

    protected boolean isAcceptableToken(RevocationToken<?> revocationToken) {
        if (this.revocationDataVerifier == null) {
            LOG.warn("RevocationDataVerifier is null! Validation of retrieved revocation data is skipped.");
            return true;
        }
        return this.revocationDataVerifier.isAcceptable(revocationToken);
    }
}

