/*
 * Decompiled with CFR 0.152.
 */
package org.didd.version;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.gson.Gson;
import com.transsnet.version.R;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.didd.common.network.NetUtil;
import org.didd.http.BaseModel;
import org.didd.http.HttpApi;
import org.didd.http.HttpResponse;
import org.didd.http.HttpResponseBody;
import org.didd.http.IHttpCallback;
import org.didd.version.DB;
import org.didd.version.DaoSession;
import org.didd.version.NewVersionModel;
import org.didd.version.ReqBodyUpdate;
import org.didd.version.ReqHead;
import org.didd.version.VersionActivity;
import org.didd.version.VersionBean;
import org.didd.version.VersionBeanDao;
import org.didd.version.VersionReq;
import org.didd.version.VersionResponse;

public class VersionApi
implements IHttpCallback,
View.OnClickListener,
DialogInterface.OnKeyListener,
DialogInterface.OnCancelListener {
    private static final Object LOCK = new Object();
    private static final String SH_FILE_NAME = "DIDD_VERSION_SP_FILE";
    private static final long DAY_TIME = 86400000L;
    private static final String TAG = VersionApi.class.getSimpleName();
    private static final String DB_NAME = "DIDD_VERSION_DB";
    private static VersionApi mInstance;
    static String versionHttpUrl;
    private SharedPreferences mSp;
    private Activity mContext;
    private String mAppName;
    static boolean mResumed;
    private boolean isRequesting;
    private boolean isDialog = false;
    private ICallback callback;
    private String channel;
    private String version;
    private IHttpCallback checkHttpCB = new IHttpCallback(){

        public void result(HttpResponse httpResponse) {
            String str;
            if (VersionApi.this.errorHttpCode(httpResponse)) {
                if (null != VersionApi.this.callback) {
                    VersionApi.this.callback.end(-3);
                }
                return;
            }
            HttpResponseBody body = httpResponse.getBody();
            if (null != body && !TextUtils.isEmpty((CharSequence)(str = body.getString()))) {
                VersionResponse response = (VersionResponse)new Gson().fromJson(str, VersionResponse.class);
                VersionApi.this.handleResult(response, false);
                return;
            }
            if (null != VersionApi.this.callback) {
                VersionApi.this.callback.end(-5);
            }
        }
    };
    private AlertDialog mDialog;
    private VersionBean data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionApi getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == mInstance) {
                mInstance = new VersionApi();
            }
            return mInstance;
        }
    }

    private VersionApi() {
    }

    public void setContext(Activity context) {
        this.mContext = context;
    }

    public void init(Activity context, String httpUrl, String appName, String channel, String version) {
        this.init(context, httpUrl, appName, channel, version, true);
    }

    public void init(Activity context, String httpUrl, String appName, String channel, String version, boolean isDialog) {
        if (TextUtils.isEmpty((CharSequence)httpUrl) || null == context) {
            return;
        }
        versionHttpUrl = httpUrl;
        this.mContext = context;
        this.mAppName = appName;
        this.isDialog = isDialog;
        this.channel = channel;
        this.version = version;
        this.callback = null;
        DB.getInstance().init((Context)context, DB_NAME);
        this.mSp = context.getSharedPreferences(SH_FILE_NAME, 0);
        this.requestFromServer(channel, version, this);
    }

    public VersionBean getVersion() {
        VersionBeanDao dao = this.getDao();
        if (null == dao) {
            return null;
        }
        List list = dao.queryBuilder().list();
        if (null != list && !list.isEmpty()) {
            return (VersionBean)list.get(0);
        }
        return null;
    }

    public void startCheck(ICallback cb) {
        this.startCheck(this.mContext, cb);
    }

    public void startCheck(Activity activity, ICallback cb) {
        this.callback = cb;
        if (null != this.callback) {
            this.callback.start();
        }
        this.sendHttpRequest(this.channel, this.version, this.checkHttpCB);
    }

    private void requestFromServer(String channel, String version, IHttpCallback cb) {
        if (this.isRequesting) {
            if (null != this.callback) {
                this.callback.end(-2);
            }
            return;
        }
        this.sendHttpRequest(channel, version, cb);
        this.checkLocalDB();
        this.isRequesting = true;
    }

    private void sendHttpRequest(String channel, String version, IHttpCallback callback) {
        HttpApi.getInstance().request(this.createBaseModel(channel, version, callback));
    }

    private BaseModel createBaseModel(String channel, String version, IHttpCallback callback) {
        if (null == this.mContext) {
            return null;
        }
        ReqBodyUpdate bodyUpdate = new ReqBodyUpdate();
        bodyUpdate.packageName = this.mContext.getPackageName();
        bodyUpdate.cversion = version;
        bodyUpdate.channel = channel;
        bodyUpdate.netType = this.getNetTypeForServer();
        ReqHead head = new ReqHead();
        head.sign = this.getHeadSign(bodyUpdate);
        VersionReq data = new VersionReq();
        data.reqBody = bodyUpdate;
        data.reqHead = head;
        return new NewVersionModel(data, callback);
    }

    private String getNetTypeForServer() {
        int net = NetUtil.getNetworkState((Context)this.mContext);
        switch (net) {
            case 2: {
                return "3";
            }
            case 1: {
                return "2";
            }
        }
        return "1";
    }

    private String getHeadSign(ReqBodyUpdate bodyUpdate) {
        if (null == bodyUpdate) {
            return null;
        }
        return this.md5Of32("channel=" + bodyUpdate.channel + "&cversion=" + bodyUpdate.cversion + "&packageName=" + bodyUpdate.packageName + "&netType=" + bodyUpdate.netType);
    }

    private void showDialogInUI(final VersionBean data) {
        if (mResumed && !this.isDialog) {
            return;
        }
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    VersionApi.this.toShowAct(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                VersionApi.this.saveCount(data);
            }
        });
    }

    private void toShowAct(VersionBean data) {
        if (this.isDialog) {
            this.showDialog(data);
        } else {
            Intent intent = new Intent((Context)this.mContext, VersionActivity.class);
            intent.putExtra("appName", this.mAppName);
            intent.putExtra("versionBean", (Serializable)data);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
    }

    private void saveCount(VersionBean data) {
        String spKey = this.getSPKey(data.getStrategyName());
        int totalAlertTimes = this.getIntFromSp(spKey + "_total");
        this.setIntFromSp(spKey + "_total", totalAlertTimes + 1);
        this.setLongFromSp(spKey + "_time");
    }

    public void result(HttpResponse httpResponse) {
        String str;
        this.isRequesting = false;
        if (this.errorHttpCode(httpResponse)) {
            if (null != this.callback) {
                this.callback.end(-3);
            }
            return;
        }
        HttpResponseBody body = httpResponse.getBody();
        if (null != body && !TextUtils.isEmpty((CharSequence)(str = body.getString()))) {
            VersionResponse response = (VersionResponse)new Gson().fromJson(str, VersionResponse.class);
            this.handleResult(response, true);
            return;
        }
        if (null != this.callback) {
            this.callback.end(-5);
        }
    }

    private boolean errorHttpCode(HttpResponse httpResponse) {
        return null == httpResponse || httpResponse.code < 200 || httpResponse.code >= 300;
    }

    private void checkLocalDB() {
        VersionBean bean;
        VersionBeanDao dao = this.getDao();
        if (null == dao) {
            return;
        }
        List list = dao.queryBuilder().list();
        if (null != list && !list.isEmpty() && this.isNeedUpdate(bean = (VersionBean)list.get(0))) {
            this.showUpdateMessage(bean, true);
        }
    }

    private boolean isNeedUpdate(VersionBean bean) {
        if (null == bean) {
            Log.i((String)TAG, (String)("isNotUpdate, version = " + this.version + ", bean is null"));
            return false;
        }
        Log.i((String)TAG, (String)("isNotUpdate, version = " + this.version + ", 1 public version = " + bean.getPublishVersion()));
        if (TextUtils.equals((CharSequence)this.version, (CharSequence)bean.getPublishVersion())) {
            Log.i((String)TAG, (String)("isNotUpdate, version = " + this.version + ", public version = " + bean.getPublishVersion()));
            return true;
        }
        if (this.isLowerVersion(bean.getLowerVersion())) {
            Log.i((String)TAG, (String)("isNotUpdate, version = " + this.version + ", isLowerVersion"));
            return true;
        }
        return false;
    }

    private boolean isLowerVersion(String lowerVersion) {
        int targetVersion;
        int curVersion = this.getVersionInt(this.version);
        return curVersion < (targetVersion = this.getVersionInt(lowerVersion)) && targetVersion > 0 && curVersion > 0;
    }

    public int getVersionInt(String version) {
        if (TextUtils.isEmpty((CharSequence)version)) {
            return 0;
        }
        String[] nums = version.split("\\.");
        int count = nums.length;
        int res = 0;
        for (int i = 0; i < count; ++i) {
            res += this.toInt(nums[i], count - 1 - i);
        }
        Log.i((String)TAG, (String)("getVersionInt, version = " + version + ", code = " + res));
        return res;
    }

    private int toInt(String num, int i) {
        try {
            int n = Integer.valueOf(num);
            for (int j = 0; j < i; ++j) {
                n *= 10;
            }
            return n;
        }
        catch (Exception ignore) {
            return 0;
        }
    }

    private void handleResult(VersionResponse response, boolean needAddCount) {
        if (null == response || response.getCode() != 0) {
            if (null != this.callback) {
                this.callback.end(-4);
            }
            return;
        }
        this.showUpdateMessage(response.getData(), needAddCount);
    }

    private void showUpdateMessage(VersionBean data, boolean needAddCount) {
        this.saveToLocalDB(data);
        if (null == data) {
            if (null != this.callback) {
                this.callback.end(1);
            }
            return;
        }
        if (this.checkRight(data, needAddCount)) {
            this.showDialogInUI(data);
            if (null != this.callback) {
                this.callback.end(0);
            }
        } else if (null != this.callback) {
            this.callback.end(-6);
        }
    }

    private VersionBeanDao getDao() {
        DaoSession session = DB.getInstance().getDaoSession();
        if (null == session) {
            return null;
        }
        return session.getVersionBeanDao();
    }

    private void saveToLocalDB(VersionBean data) {
        VersionBeanDao dao = this.getDao();
        if (null != dao) {
            dao.deleteAll();
            if (null != data) {
                dao.insert(data);
            }
        }
    }

    public boolean checkRight(VersionBean data, boolean needAddCount) {
        if (null == data) {
            return false;
        }
        if (!needAddCount) {
            return true;
        }
        String spKey = this.getSPKey(data.getStrategyName());
        int totalAlertTimes = this.getIntFromSp(spKey + "_total");
        long lastAlertTime = this.getLongFromSp(spKey + "_time");
        if (data.getAlertTimes() >= 0 && data.getAlertTimes() <= totalAlertTimes) {
            return false;
        }
        if (data.getAlertInterval() >= 0 && System.currentTimeMillis() - lastAlertTime <= (long)data.getAlertInterval() * 86400000L) {
            return false;
        }
        return this.isRightNet(data.getNetType());
    }

    private boolean isRightNet(int netType) {
        int net = NetUtil.getNetworkState((Context)this.mContext);
        switch (netType) {
            case 1: {
                return net == 0;
            }
            case 2: {
                return net == 1;
            }
            case 3: {
                return net == 2;
            }
        }
        return true;
    }

    private long getLongFromSp(String key) {
        if (null == this.mSp) {
            return 0L;
        }
        return this.mSp.getLong(key, 0L);
    }

    private void setLongFromSp(String key) {
        if (null == this.mSp) {
            return;
        }
        this.mSp.edit().putLong(key, System.currentTimeMillis()).apply();
    }

    private int getIntFromSp(String spKey) {
        if (null == this.mSp) {
            return 0;
        }
        return this.mSp.getInt(spKey, 0);
    }

    private void setIntFromSp(String spKey, int value) {
        if (null == this.mSp) {
            return;
        }
        this.mSp.edit().putInt(spKey, value).apply();
    }

    private String getSPKey(String key) {
        return this.md5Of32(key);
    }

    private String md5Of32(String plainText) {
        String result = "";
        if (null == plainText) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return result;
        }
    }

    private void showDialog(VersionBean data) {
        if (null != this.mDialog && this.mDialog.isShowing()) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mContext);
        View customView = View.inflate((Context)this.mContext, (int)R.layout.didd_version_layout, null);
        this.initCustomViewData(customView, data);
        builder.setView(customView);
        this.mDialog = builder.create();
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setOnKeyListener((DialogInterface.OnKeyListener)this);
        this.mDialog.setOnCancelListener((DialogInterface.OnCancelListener)this);
        this.mDialog.show();
    }

    private void initCustomViewData(View view, VersionBean data) {
        String tip;
        if (null == view) {
            return;
        }
        this.data = data;
        TextView appName = (TextView)view.findViewById(R.id.version_app_name);
        TextView info = (TextView)view.findViewById(R.id.version_message);
        Button cancelBtn = (Button)view.findViewById(R.id.version_btn_cancel);
        Button updateBtn = (Button)view.findViewById(R.id.version_btn_update);
        String title = this.getAppName() + " " + data.getStrategyName();
        appName.setText((CharSequence)title);
        info.setText((CharSequence)data.getUpdateDesc());
        if ("1".equals(data.getUpgradeStrategy())) {
            cancelBtn.setEnabled(false);
            cancelBtn.setVisibility(8);
            view.findViewById(R.id.version_line_b).setVisibility(8);
            tip = "Update";
            updateBtn.setText((CharSequence)"");
            int dp160 = this.dp2px(160);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(dp160, -1, 0.0f);
            updateBtn.setLayoutParams((ViewGroup.LayoutParams)lp);
        } else {
            cancelBtn.setOnClickListener((View.OnClickListener)this);
            tip = "Try it now";
        }
        updateBtn.setText((CharSequence)tip);
        updateBtn.setOnClickListener((View.OnClickListener)this);
    }

    private String getAppName() {
        return this.mAppName;
    }

    private int dp2px(int values) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)((float)values * scale + 0.5f);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.version_btn_cancel) {
            if (!"1".equals(this.data.getUpgradeStrategy())) {
                this.dismiss();
            }
        } else if (v.getId() == R.id.version_btn_update) {
            this.update();
        }
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        return true;
    }

    public void onCancel(DialogInterface dialog) {
        this.dismiss();
    }

    private void dismiss() {
        try {
            if (null != this.mDialog) {
                this.mDialog.dismiss();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void update() {
        String url;
        Log.i((String)TAG, (String)"update");
        if (null == this.data) {
            Toast.makeText((Context)this.mContext, (CharSequence)"Url is null, Error", (int)0).show();
            return;
        }
        if (!"1".equals(this.data.getUpgradeStrategy())) {
            this.dismiss();
        }
        if (this.isMarketUrl(url = this.data.getDownloadUrl())) {
            this.toMarket(url);
        } else {
            this.toBrowser(url);
        }
    }

    private void toBrowser(String url) {
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            Uri content_url = Uri.parse((String)url);
            intent.setData(content_url);
            intent.setFlags(0x10000000);
            this.mContext.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void toMarket(String url) {
        try {
            this.startGooglePlay(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isMarketUrl(String url) {
        return null != url && url.startsWith("market://");
    }

    private void startGooglePlay(String url) {
        Intent mIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        boolean marketExist = false;
        List otherApps = this.mContext.getPackageManager().queryIntentActivities(mIntent, 0);
        for (ResolveInfo otherApp : otherApps) {
            if (!otherApp.activityInfo.applicationInfo.packageName.equals("com.android.vending")) continue;
            ActivityInfo otherAppActivity = otherApp.activityInfo;
            ComponentName componentName = new ComponentName(otherAppActivity.applicationInfo.packageName, otherAppActivity.name);
            mIntent.setFlags(0x10000000);
            mIntent.setComponent(componentName);
            this.mContext.startActivity(mIntent);
            marketExist = true;
            break;
        }
        if (!marketExist) {
            Intent webIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + this.mContext.getPackageName())));
            this.mContext.startActivity(webIntent);
        }
    }

    public void destroy() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
        this.mDialog = null;
        this.mContext = null;
    }

    static {
        mResumed = false;
    }

    public static interface ICallback {
        public static final int SUCCESS = 0;
        public static final int SUCCESS_NONE_DATA = 1;
        public static final int FAILED = -1;
        public static final int FAILED_REQUESTING = -2;
        public static final int FAILED_NET_ERROR = -3;
        public static final int FAILED_SERVER_ERROR = -4;
        public static final int FAILED_NET_UNKNOW = -5;
        public static final int ERROR_RIGHT_SHOW_TIME = -6;

        public void start();

        public void end(int var1);
    }
}

