/*
 * Decompiled with CFR 0.152.
 */
package org.didd.http;

import android.text.TextUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.didd.http.HttpEntry;
import org.didd.http.HttpResponse;
import org.didd.http.HttpResponseBody;
import org.didd.http.HttpResponseHeader;
import org.didd.http.IHttpCallback;

public class Http {
    public static final int GET = 0;
    public static final int POST = 1;
    public static final int ERROR_NULL_URL_CODE = -2;
    public static final String ERROR_NULL_URL_MSG = "url is null.";
    public static final int ERROR_NOT_SUPPORT_CODE = -1;
    public static final String ERROR_NOT_SUPPORT_MSG = "not support cur type.";
    public static int CONNECT_TIMEOUT = 60;
    public static int READ_TIMEOUT = 120;
    public static int WRITE_TIMEOUT = 120;
    private static final String TAG = "SkyHttp";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType X = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    private static Http mInstance;
    private ExecutorService mRequestPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Http getInstance() {
        String string = TAG;
        synchronized (TAG) {
            if (null == mInstance) {
                mInstance = new Http();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void request(final HttpEntry httpEntry) throws NullPointerException {
        if (null == httpEntry) {
            throw new NullPointerException("HttpEntry is null!");
        }
        if (null == this.mRequestPool) {
            this.mRequestPool = Executors.newCachedThreadPool();
        }
        this.mRequestPool.submit(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        Http.this.doRequest(httpEntry);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (null == httpEntry.getCallback()) break block2;
                        HttpResponse err = new HttpResponse(1, "Net error");
                        httpEntry.getCallback().result(err);
                    }
                }
            }
        });
    }

    private void doRequest(HttpEntry httpEntry) throws IOException {
        if (null == httpEntry) {
            throw new NullPointerException("HttpEntry is null!");
        }
        if (httpEntry.getType() == 0) {
            this.doGet(httpEntry);
        } else if (httpEntry.getType() == 1) {
            this.doPost(httpEntry);
        } else {
            IHttpCallback callback = httpEntry.getCallback();
            if (null != callback) {
                callback.result(new HttpResponse(-1, ERROR_NOT_SUPPORT_MSG));
            }
            return;
        }
    }

    private void doPost(HttpEntry httpEntry) throws IOException {
        this.doGet(httpEntry);
    }

    private Request.Builder handlerUrlAndHeader(HttpEntry httpEntry) {
        String bodyStr;
        Map<String, String> body;
        String bodyJson;
        if (null == httpEntry) {
            return null;
        }
        String url = httpEntry.getBaseUrl();
        IHttpCallback callback = httpEntry.getCallback();
        if (TextUtils.isEmpty((CharSequence)url)) {
            if (null != callback) {
                callback.result(new HttpResponse(-2, ERROR_NULL_URL_MSG));
            }
            return null;
        }
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        Map<String, String> header = httpEntry.getHeader();
        if (null != header && header.size() > 0) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                if (null == entry.getKey() || null == entry.getValue()) continue;
                builder.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(bodyJson = httpEntry.getBodyJson()))) {
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)bodyJson.replaceAll("\\\\", "").replace("\"[", "[").replace("]\"", "]"));
            builder.post(requestBody);
        }
        if (null != (body = httpEntry.getBody()) && body.size() > 0 && !TextUtils.isEmpty((CharSequence)(bodyStr = Http.mapToString(body)))) {
            RequestBody requestBody = RequestBody.create((MediaType)X, (String)bodyStr);
            builder.post(requestBody);
        }
        return builder;
    }

    public static String mapToString(Map<String, String> map) {
        if (null == map) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return sb.toString();
    }

    private void doGet(HttpEntry httpEntry) throws IOException {
        Request.Builder builder = this.handlerUrlAndHeader(httpEntry);
        if (null == builder) {
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().readTimeout((long)READ_TIMEOUT, TimeUnit.SECONDS).writeTimeout((long)WRITE_TIMEOUT, TimeUnit.SECONDS).connectTimeout((long)CONNECT_TIMEOUT, TimeUnit.SECONDS).build();
        Request request = builder.build();
        Response response = client.newCall(request).execute();
        IHttpCallback callback = httpEntry.getCallback();
        if (null != callback) {
            HttpResponse httpResponse = this.convertHttpResponse(response, httpEntry);
            callback.result(httpResponse);
        }
    }

    private HttpResponse convertHttpResponse(Response response, HttpEntry entry) {
        return new HttpResponse(response.code(), response.message(), entry, this.convertHttpResponseHeader(response.headers()), this.convertHttpResponseBody(response.body()));
    }

    private HttpResponseBody convertHttpResponseBody(ResponseBody body) {
        MediaType contentType = body.contentType();
        try {
            return new HttpResponseBody(body.byteStream(), contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8, body.string());
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HttpResponseBody(body.byteStream(), contentType != null ? contentType.charset(Util.UTF_8) : Util.UTF_8);
        }
    }

    private HttpResponseHeader convertHttpResponseHeader(Headers headers) {
        return new HttpResponseHeader(headers.toMultimap());
    }
}

