/*
 * Decompiled with CFR 0.152.
 */
package com.bb_sz.accessibilityutils;

import android.accessibilityservice.AccessibilityService;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.EditText;
import java.io.DataOutputStream;
import java.util.List;

public class FZHelper {
    private static final String TAG = FZHelper.class.getSimpleName();
    private static final boolean debug = true;

    public static List<AccessibilityNodeInfo> getNodesForTxt(AccessibilityService service, String txt) {
        if (null == service || TextUtils.isEmpty((CharSequence)txt)) {
            return null;
        }
        AccessibilityNodeInfo eventSource = service.getRootInActiveWindow();
        if (null == eventSource) {
            return null;
        }
        return eventSource.findAccessibilityNodeInfosByText(txt);
    }

    public static List<AccessibilityNodeInfo> getNodesForId(AccessibilityService service, String id) {
        if (null == service || TextUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        AccessibilityNodeInfo eventSource = service.getRootInActiveWindow();
        if (null == eventSource) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            return eventSource.findAccessibilityNodeInfosByViewId(id);
        }
        return null;
    }

    public static boolean edittextInputById(AccessibilityService service, String id, String txt) {
        return FZHelper.edittextInputById(service, id, txt, 0);
    }

    public static boolean edittextInputById(AccessibilityService service, String id, String txt, int index) {
        Log.d((String)TAG, (String)("edittextInputById(), id = " + id + ", txt = " + txt));
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        boolean res = false;
        for (int i = 0; i < size; ++i) {
            AccessibilityNodeInfo nodeInfo = nodes.get(i);
            if (null == nodeInfo || i != index && index != -1) continue;
            String cls = (String)nodeInfo.getClassName();
            if (!EditText.class.getName().equals(cls)) continue;
            if (Build.VERSION.SDK_INT >= 21) {
                Bundle arguments = new Bundle();
                arguments.putCharSequence("ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE", (CharSequence)txt);
                res = nodeInfo.performAction(0x200000, arguments);
                continue;
            }
            if (Build.VERSION.SDK_INT < 18) continue;
            ClipboardManager clipboard = (ClipboardManager)service.getBaseContext().getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)txt);
            clipboard.setPrimaryClip(clip);
            nodeInfo.performAction(1);
            res = nodeInfo.performAction(32768);
        }
        return res;
    }

    public static boolean buttonClick(AccessibilityService service, String id) {
        Log.d((String)TAG, (String)("buttonClick(), id = " + id));
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            AccessibilityNodeInfo nodeInfo = nodes.get(i);
            if (null == nodeInfo) continue;
            String cls = (String)nodeInfo.getClassName();
            if (!Button.class.getName().equals(cls)) continue;
            boolean res = nodeInfo.performAction(16);
            Log.i((String)TAG, (String)("buttonClick(), cls = " + cls + ", res = " + res));
            return true;
        }
        return false;
    }

    public static boolean viewClickById(AccessibilityService service, String id) {
        Log.d((String)TAG, (String)("viewClickById(), id = " + id));
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        boolean res = false;
        Log.d((String)TAG, (String)("viewClickById(), size = " + size));
        for (int i = 0; i < size; ++i) {
            AccessibilityNodeInfo nodeInfo;
            String cls = nodeInfo.getClassName().toString();
            Log.d((String)TAG, (String)("viewClickById(), cls = " + cls));
            int count = 0;
            for (nodeInfo = nodes.get(i); !res && count++ < 5 && null != nodeInfo; nodeInfo = nodeInfo.getParent()) {
                res = nodeInfo.performAction(16);
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    public static boolean viewChildClickForId(AccessibilityService service, String id) {
        Log.d((String)TAG, (String)("viewChildClickForId(), id = " + id));
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        boolean res = false;
        Log.d((String)TAG, (String)("viewChildClickForId(), size = " + size));
        for (int i = 0; i < size; ++i) {
            AccessibilityNodeInfo nodeInfo;
            String cls = nodeInfo.getClassName().toString();
            int childCount = nodeInfo.getChildCount();
            Log.d((String)TAG, (String)("viewChildClickForId(), cls = " + cls + ", childCount = " + childCount));
            int count = 0;
            for (nodeInfo = nodes.get(i); !res && count++ < 5 && null != nodeInfo; nodeInfo = nodeInfo.getParent()) {
                res = nodeInfo.performAction(16);
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    public static boolean viewClickByTxt(AccessibilityService service, String txt) {
        Log.d((String)TAG, (String)("viewClickFroTxt(), txt = " + txt));
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForTxt(service, txt);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        int size = nodes.size();
        boolean res = false;
        for (int i = 0; i < size; ++i) {
            int count = 0;
            for (AccessibilityNodeInfo nodeInfo = nodes.get(i); !res && count++ < 5 && null != nodeInfo; nodeInfo = nodeInfo.getParent()) {
                res = nodeInfo.performAction(16);
            }
            if (!res) continue;
            return true;
        }
        return false;
    }

    public static boolean systemEvent(AccessibilityService service, int action) {
        if (null == service) {
            return false;
        }
        return service.performGlobalAction(action);
    }

    public static boolean viewActionById(AccessibilityService service, String id, int action) {
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return false;
        }
        Log.e((String)TAG, (String)("viewActionForId(), size = " + nodes.size()));
        for (AccessibilityNodeInfo item : nodes) {
            if (!item.performAction(action)) continue;
            return true;
        }
        return false;
    }

    public static String viewTextById(AccessibilityService service, String id) {
        List<AccessibilityNodeInfo> nodes = FZHelper.getNodesForId(service, id);
        if (null == nodes || nodes.isEmpty()) {
            return null;
        }
        Log.e((String)TAG, (String)("viewTextForId(), size = " + nodes.size()));
        for (AccessibilityNodeInfo item : nodes) {
            if (TextUtils.isEmpty((CharSequence)item.getText().toString())) continue;
            return item.getText().toString();
        }
        return null;
    }

    public static void doSuExec(String[] cmds) {
        try {
            Process process = Runtime.getRuntime().exec("su");
            DataOutputStream os = new DataOutputStream(process.getOutputStream());
            for (String cmd : cmds) {
                Log.d((String)"cmd", (String)("cmd = " + cmd));
                os.writeBytes(cmd + "\n");
            }
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void doExec(String cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

