/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.CustomDataValidation;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.HyperLink;
import org.dhatim.fastexcel.ListDataValidation;
import org.dhatim.fastexcel.Ref;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.Table;
import org.dhatim.fastexcel.Worksheet;

public class Range
implements Ref {
    private final Worksheet worksheet;
    private final int top;
    private final int left;
    private final int bottom;
    private final int right;

    Range(Worksheet worksheet, int top, int left, int bottom, int right) {
        this.worksheet = Objects.requireNonNull(worksheet);
        if (top < 0 || top >= 0x100000 || bottom < 0 || bottom >= 0x100000) {
            throw new IllegalArgumentException();
        }
        if (left < 0 || left >= 16384 || right < 0 || right >= 16384) {
            throw new IllegalArgumentException();
        }
        this.top = Math.min(top, bottom);
        this.left = Math.min(left, right);
        this.bottom = Math.max(bottom, top);
        this.right = Math.max(right, left);
    }

    public Worksheet getWorksheet() {
        return this.worksheet;
    }

    public int getTop() {
        return this.top;
    }

    public int getLeft() {
        return this.left;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getRight() {
        return this.right;
    }

    public int hashCode() {
        return Objects.hash(this.worksheet, this.top, this.left, this.bottom, this.right);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Range other = (Range)obj;
            result = Objects.equals(this.worksheet, other.worksheet) && Objects.equals(this.top, other.top) && Objects.equals(this.left, other.left) && Objects.equals(this.bottom, other.bottom) && Objects.equals(this.right, other.right);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return this.colToString(this.left) + (this.top + 1) + ":" + this.colToString(this.right) + (this.bottom + 1);
    }

    public String toAbsoluteString() {
        return "$" + this.colToString(this.left) + "$" + (this.top + 1) + ":$" + this.colToString(this.right) + "$" + (this.bottom + 1);
    }

    public StyleSetter style() {
        return new StyleSetter(this);
    }

    public void merge() {
        this.worksheet.merge(this);
    }

    public boolean contains(int r, int c) {
        return r >= this.top && r <= this.bottom && c >= this.left && c <= this.right;
    }

    void shadeAlternateRows(Fill fill) {
        this.worksheet.shadeAlternateRows(this, fill);
    }

    void shadeRows(Fill fill, int eachNRows) {
        this.worksheet.shadeRows(this, fill, eachNRows);
    }

    public ListDataValidation validateWithList(Range listRange) {
        ListDataValidation listDataValidation = new ListDataValidation(this, listRange);
        this.worksheet.addValidation(listDataValidation);
        return listDataValidation;
    }

    public CustomDataValidation validateWithFormula(String formula) {
        CustomDataValidation customDataValidation = new CustomDataValidation(this, new Formula(formula));
        this.worksheet.addValidation(customDataValidation);
        return customDataValidation;
    }

    public void setName(String name) {
        this.worksheet.addNamedRange(this, name);
    }

    Set<Integer> getStyles() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int r = this.top; r <= this.bottom; ++r) {
            for (int c = this.left; c <= this.right; ++c) {
                result.add(this.getWorksheet().cell(r, c).getStyle());
            }
        }
        return result;
    }

    void applyStyle(Map<Integer, Integer> styles) {
        for (int r = this.top; r <= this.bottom; ++r) {
            for (int c = this.left; c <= this.right; ++c) {
                Cell cell = this.getWorksheet().cell(r, c);
                cell.setStyle(styles.get(cell.getStyle()));
            }
        }
    }

    public void setHyperlink(HyperLink hyperLink) {
        this.worksheet.value(this.top, this.left, hyperLink.getDisplayStr());
        this.worksheet.addHyperlink(this, hyperLink);
    }

    public Table createTable() {
        int columnCount = this.right - this.left + 1;
        String[] headers = (String[])IntStream.rangeClosed(1, columnCount).mapToObj(i -> "Column" + i).toArray(String[]::new);
        return this.createTable(headers);
    }

    public Table createTable(String ... headers) {
        return this.worksheet.addTable(this, headers);
    }
}

