/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.dhatim.fastexcel.Writer;

class Font {
    protected static final Font DEFAULT = Font.build(false, false, false, null, null, null);
    private final boolean bold;
    private final boolean italic;
    private final boolean underlined;
    private final String name;
    private final BigDecimal size;
    private final String rgbColor;

    Font(boolean bold, boolean italic, boolean underlined, String name, BigDecimal size, String rgbColor) {
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.name = name;
        this.size = size.setScale(2, RoundingMode.HALF_UP);
        this.rgbColor = rgbColor;
    }

    static Font build(boolean bold, boolean italic, boolean underlined, String name, BigDecimal size, String rgbColor) {
        return new Font(bold, italic, underlined, name == null ? "Calibri" : name, size == null ? BigDecimal.valueOf(11.0) : size, rgbColor == null ? "FF000000" : rgbColor);
    }

    public int hashCode() {
        return Objects.hash(this.bold, this.italic, this.underlined, this.name, this.size, this.rgbColor);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Font other = (Font)obj;
            result = Objects.equals(this.bold, other.bold) && Objects.equals(this.italic, other.italic) && Objects.equals(this.underlined, other.underlined) && Objects.equals(this.name, other.name) && Objects.equals(this.size, other.size) && Objects.equals(this.rgbColor, other.rgbColor);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<font>").append(this.bold ? "<b/>" : "").append(this.italic ? "<i/>" : "").append(this.underlined ? "<u/>" : "").append("<sz val=\"").append(this.size.toString()).append("\"/>");
        if (this.rgbColor != null) {
            w.append("<color rgb=\"").append(this.rgbColor).append("\"/>");
        }
        w.append("<name val=\"").appendEscaped(this.name).append("\"/>");
        w.append("</font>");
    }
}

