/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dhatim.fastexcel.AlternateShading;
import org.dhatim.fastexcel.Cell;
import org.dhatim.fastexcel.Comments;
import org.dhatim.fastexcel.DataValidation;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Formula;
import org.dhatim.fastexcel.Range;
import org.dhatim.fastexcel.SheetProtectionOption;
import org.dhatim.fastexcel.StyleSetter;
import org.dhatim.fastexcel.VisibilityState;
import org.dhatim.fastexcel.Workbook;
import org.dhatim.fastexcel.Writer;

public class Worksheet {
    public static final int MAX_ROWS = 0x100000;
    public static final int MAX_COLS = 16384;
    public static final int MAX_COL_WIDTH = 255;
    private final Workbook workbook;
    private final String name;
    private final List<Cell[]> rows = new ArrayList<Cell[]>();
    private final Set<Range> mergedRanges = new HashSet<Range>();
    private final List<DataValidation> dataValidations = new ArrayList<DataValidation>();
    private final List<AlternateShading> alternateShadingRanges = new ArrayList<AlternateShading>();
    private final Set<Integer> hiddenRows = new HashSet<Integer>();
    private final Set<Integer> hiddenColumns = new HashSet<Integer>();
    private final Map<Integer, Double> colWidths = new HashMap<Integer, Double>();
    final Comments comments = new Comments();
    private boolean finished;
    private VisibilityState visibilityState;
    private String passwordHash;
    private Set<SheetProtectionOption> sheetProtectionOptions;
    private Writer writer;
    private int flushedRows = 0;

    Worksheet(Workbook workbook, String name) {
        this.workbook = Objects.requireNonNull(workbook);
        this.name = Objects.requireNonNull(name);
    }

    public String getName() {
        return this.name;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    Cell cell(int r, int c) {
        if (r < 0 || r >= 0x100000 || c < 0 || c >= 16384) {
            throw new IllegalArgumentException();
        }
        this.flushedCheck(r);
        while (r >= this.rows.size()) {
            this.rows.add(null);
        }
        Cell[] row = this.rows.get(r);
        if (row == null) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            row = new Cell[columns];
            this.rows.set(r, row);
        } else if (c >= row.length) {
            int columns = Math.max(c + 1, r > 0 && this.rows.get(r - 1) != null ? this.rows.get(r - 1).length : c + 1);
            Cell[] tmp = new Cell[columns];
            System.arraycopy(row, 0, tmp, 0, row.length);
            row = tmp;
            this.rows.set(r, row);
        }
        if (row[c] == null) {
            row[c] = new Cell();
        }
        return row[c];
    }

    private void flushedCheck(int r) {
        if (r < this.flushedRows) {
            throw new IllegalStateException("Row " + r + " already flushed from memory.");
        }
    }

    void merge(Range range) {
        this.mergedRanges.add(range);
    }

    void shadeAlternateRows(Range range, Fill fill) {
        this.alternateShadingRanges.add(new AlternateShading(range, this.getWorkbook().cacheAlternateShadingFillColor(fill)));
    }

    void addValidation(DataValidation validation) {
        this.dataValidations.add(validation);
    }

    public void setVisibilityState(VisibilityState visibilityState) {
        this.visibilityState = visibilityState;
    }

    public VisibilityState getVisibilityState() {
        return this.visibilityState;
    }

    public void hideRow(int row) {
        this.hiddenRows.add(row);
    }

    public void showRow(int row) {
        this.hiddenRows.remove(row);
    }

    public void hideColumn(int column) {
        this.hiddenColumns.add(column);
    }

    public void showColumn(int column) {
        this.hiddenColumns.remove(column);
    }

    public void protect(String password) {
        this.protect(password, SheetProtectionOption.DEFAULT_OPTIONS);
    }

    public void protect(String password, SheetProtectionOption ... options) {
        EnumSet<SheetProtectionOption> optionSet = EnumSet.noneOf(SheetProtectionOption.class);
        Collections.addAll(optionSet, options);
        this.protect(password, optionSet);
    }

    public void protect(String password, Set<SheetProtectionOption> options) {
        if (password == null) {
            this.sheetProtectionOptions = null;
            this.passwordHash = null;
            return;
        }
        this.sheetProtectionOptions = options;
        this.passwordHash = Worksheet.hashPassword(password);
    }

    private static String hashPassword(String password) {
        byte[] passwordCharacters = password.getBytes();
        int hash = 0;
        if (passwordCharacters.length > 0) {
            int charIndex = passwordCharacters.length;
            while (charIndex-- > 0) {
                hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
                hash ^= passwordCharacters[charIndex];
            }
            hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
            hash ^= passwordCharacters.length;
            hash ^= 0xCE4B;
        }
        return Integer.toHexString(hash & 0xFFFF);
    }

    public void width(int c, double width) {
        if (width > 255.0) {
            throw new IllegalArgumentException();
        }
        this.colWidths.put(c, width);
    }

    public void value(int r, int c, Object value) {
        this.cell(r, c).setValue(this.workbook, value);
    }

    public Object value(int r, int c) {
        this.flushedCheck(r);
        Cell[] row = r < this.rows.size() ? this.rows.get(r) : null;
        Cell cell = row == null || c >= row.length ? null : row[c];
        return cell == null ? null : cell.getValue();
    }

    public void formula(int r, int c, String expression) {
        this.cell(r, c).setFormula(expression);
    }

    public StyleSetter style(int r, int c) {
        return new Range(this, r, c, r, c).style();
    }

    public Range range(int top, int left, int bottom, int right) {
        return new Range(this, top, left, bottom, right);
    }

    private boolean isCellInMergedRanges(int r, int c) {
        return this.mergedRanges.stream().filter(range -> range.contains(r, c)).findAny().isPresent();
    }

    private void writeCols(Writer w, int nbCols) throws IOException {
        boolean started = false;
        for (int c = 0; c < nbCols; ++c) {
            double maxWidth = 0.0;
            boolean bestFit = true;
            if (this.colWidths.containsKey(c)) {
                bestFit = false;
                maxWidth = this.colWidths.get(c);
            } else {
                for (int r = 0; r < this.rows.size(); ++r) {
                    Object o;
                    Object object = o = this.hiddenRows.contains(r) || this.isCellInMergedRanges(r, c) ? null : this.value(r, c);
                    if (o == null || o instanceof Formula) continue;
                    int length = o.toString().length();
                    maxWidth = Math.max(maxWidth, (double)((int)((double)(length * 7 + 10) / 7.0 * 256.0)) / 256.0);
                }
            }
            if (!(maxWidth > 0.0)) continue;
            if (!started) {
                w.append("<cols>");
                started = true;
            }
            Worksheet.writeCol(w, c, maxWidth, bestFit, this.hiddenColumns.contains(c));
        }
        if (started) {
            w.append("</cols>");
        }
    }

    private static void writeCol(Writer w, int columnIndex, double maxWidth, boolean bestFit, boolean isHidden) throws IOException {
        int col = columnIndex + 1;
        w.append("<col min=\"").append(col).append("\" max=\"").append(col).append("\" width=\"").append(Math.min(255.0, maxWidth)).append("\" customWidth=\"true\" bestFit=\"").append(String.valueOf(bestFit));
        if (isHidden) {
            w.append("\" hidden=\"true");
        }
        w.append("\"/>");
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.flush();
        this.writer.append("</sheetData>");
        if (!this.mergedRanges.isEmpty()) {
            this.writer.append("<mergeCells>");
            for (Range r : this.mergedRanges) {
                this.writer.append("<mergeCell ref=\"").append(r.toString()).append("\"/>");
            }
            this.writer.append("</mergeCells>");
        }
        if (!this.dataValidations.isEmpty()) {
            this.writer.append("<dataValidations count=\"").append(this.dataValidations.size()).append("\">");
            for (DataValidation v : this.dataValidations) {
                v.write(this.writer);
            }
            this.writer.append("</dataValidations>");
        }
        for (AlternateShading a : this.alternateShadingRanges) {
            a.write(this.writer);
        }
        if (this.passwordHash != null) {
            this.writer.append("<sheetProtection password=\"").append(this.passwordHash).append("\" ");
            for (Iterator<Object> iterator : SheetProtectionOption.values()) {
                if (((SheetProtectionOption)((Object)iterator)).getDefaultValue() == this.sheetProtectionOptions.contains(iterator)) continue;
                this.writer.append(((SheetProtectionOption)((Object)iterator)).getName()).append("=\"").append(Boolean.toString(!((SheetProtectionOption)((Object)iterator)).getDefaultValue())).append("\" ");
            }
            this.writer.append("/>");
        }
        this.writer.append("<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/>");
        if (!this.comments.isEmpty()) {
            this.writer.append("<drawing r:id=\"d\"/>");
            this.writer.append("<legacyDrawing r:id=\"v\"/>");
        }
        this.writer.append("</worksheet>");
        this.workbook.endFile();
        this.rows.clear();
        this.finished = true;
    }

    public void flush() throws IOException {
        if (this.writer == null) {
            int index = this.workbook.getIndex(this);
            this.writer = this.workbook.beginFile("xl/worksheets/sheet" + index + ".xml");
            this.writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.append("<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">");
            this.writer.append("<dimension ref=\"A1\"/>");
            this.writer.append("<sheetViews><sheetView workbookViewId=\"0\"/></sheetViews><sheetFormatPr defaultRowHeight=\"15.0\"/>");
            int nbCols = this.rows.stream().filter(r -> r != null).map(r -> ((Cell[])r).length).reduce(0, Math::max);
            if (nbCols > 0) {
                this.writeCols(this.writer, nbCols);
            }
            this.writer.append("<sheetData>");
        }
        for (int r2 = this.flushedRows; r2 < this.rows.size(); ++r2) {
            Cell[] row = this.rows.get(r2);
            if (row != null) {
                Worksheet.writeRow(this.writer, r2, this.hiddenRows.contains(r2), row);
            }
            this.rows.set(r2, null);
        }
        this.flushedRows = this.rows.size() - 1;
        this.writer.flush();
    }

    private static void writeRow(Writer w, int r, boolean isHidden, Cell ... row) throws IOException {
        w.append("<row r=\"").append(r + 1);
        if (isHidden) {
            w.append("\" hidden=\"true");
        }
        w.append("\">");
        for (int c = 0; c < row.length; ++c) {
            if (row[c] == null) continue;
            row[c].write(w, r, c);
        }
        w.append("</row>");
    }

    public void comment(int r, int c, String comment) {
        this.comments.set(r, c, comment);
    }
}

