/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel;

import com.github.rzymek.opczip.OpcOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.dhatim.fastexcel.Alignment;
import org.dhatim.fastexcel.Border;
import org.dhatim.fastexcel.CachedString;
import org.dhatim.fastexcel.Fill;
import org.dhatim.fastexcel.Font;
import org.dhatim.fastexcel.Protection;
import org.dhatim.fastexcel.StringCache;
import org.dhatim.fastexcel.StyleCache;
import org.dhatim.fastexcel.ThrowingConsumer;
import org.dhatim.fastexcel.Worksheet;
import org.dhatim.fastexcel.Writer;

public class Workbook {
    private final String applicationName;
    private final String applicationVersion;
    private final List<Worksheet> worksheets = new ArrayList<Worksheet>();
    private final StringCache stringCache = new StringCache();
    private final StyleCache styleCache = new StyleCache();
    private final OpcOutputStream os;
    private final Writer writer;

    public Workbook(OutputStream os, String applicationName, String applicationVersion) {
        this.os = new OpcOutputStream(os);
        this.setCompressionLevel(4);
        this.writer = new Writer((OutputStream)this.os);
        this.applicationName = Objects.requireNonNull(applicationName);
        if (applicationVersion != null && !applicationVersion.matches("\\d{1,2}\\.\\d{1,4}")) {
            throw new IllegalArgumentException("Application version must be of the form XX.YYYY");
        }
        this.applicationVersion = applicationVersion;
    }

    public void setCompressionLevel(int level) {
        this.os.setLevel(level);
    }

    public void sortWorksheets(Comparator<Worksheet> comparator) {
        this.worksheets.sort(comparator);
    }

    public void finish() throws IOException {
        if (this.worksheets.isEmpty()) {
            throw new IllegalArgumentException("A workbook must contain at least one worksheet.");
        }
        for (Worksheet ws : this.worksheets) {
            ws.finish();
        }
        this.writeComments();
        this.writeFile("[Content_Types].xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Types xmlns=\"http://schemas.openxmlformats.org/package/2006/content-types\"><Default Extension=\"rels\" ContentType=\"application/vnd.openxmlformats-package.relationships+xml\"/><Default Extension=\"xml\" ContentType=\"application/xml\"/>");
            if (this.hasComments()) {
                w.append("<Default ContentType=\"application/vnd.openxmlformats-officedocument.vmlDrawing\" Extension=\"vml\"/>");
            }
            w.append("<Override PartName=\"/xl/sharedStrings.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml\"/><Override PartName=\"/xl/styles.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml\"/><Override PartName=\"/xl/workbook.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml\"/>");
            for (Worksheet ws : this.worksheets) {
                int index = this.getIndex(ws);
                w.append("<Override PartName=\"/xl/worksheets/sheet").append(index).append(".xml\" ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml\"/>");
                if (ws.comments.isEmpty()) continue;
                w.append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml\" PartName=\"/xl/comments").append(index).append(".xml\"/>");
                w.append("<Override ContentType=\"application/vnd.openxmlformats-officedocument.drawing+xml\" PartName=\"/xl/drawings/drawing").append(index).append(".xml\"/>");
            }
            w.append("<Override PartName=\"/docProps/core.xml\" ContentType=\"application/vnd.openxmlformats-package.core-properties+xml\"/><Override PartName=\"/docProps/app.xml\" ContentType=\"application/vnd.openxmlformats-officedocument.extended-properties+xml\"/></Types>");
        });
        this.writeFile("docProps/app.xml", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Properties xmlns=\"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties\"><Application>").appendEscaped(this.applicationName).append("</Application>").append(this.applicationVersion == null ? "" : "<AppVersion>" + this.applicationVersion + "</AppVersion>").append("</Properties>"));
        this.writeFile("docProps/core.xml", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><cp:coreProperties xmlns:cp=\"http://schemas.openxmlformats.org/package/2006/metadata/core-properties\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:dcterms=\"http://purl.org/dc/terms/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><dcterms:created xsi:type=\"dcterms:W3CDTF\">").append(LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)).append("Z</dcterms:created><dc:creator>").appendEscaped(this.applicationName).append("</dc:creator></cp:coreProperties>"));
        this.writeFile("_rels/.rels", w -> w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId3\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties\" Target=\"docProps/app.xml\"/><Relationship Id=\"rId2\" Type=\"http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties\" Target=\"docProps/core.xml\"/><Relationship Id=\"rId1\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument\" Target=\"xl/workbook.xml\"/></Relationships>"));
        this.writeWorkbookFile();
        this.writeFile("xl/_rels/workbook.xml.rels", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"><Relationship Id=\"rId1\" Target=\"sharedStrings.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings\"/><Relationship Id=\"rId2\" Target=\"styles.xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles\"/>");
            for (Worksheet ws : this.worksheets) {
                w.append("<Relationship Id=\"rId").append(this.getIndex(ws) + 2).append("\" Target=\"worksheets/sheet").append(this.getIndex(ws)).append(".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet\"/>");
            }
            w.append("</Relationships>");
        });
        this.writeFile("xl/sharedStrings.xml", this.stringCache::write);
        this.writeFile("xl/styles.xml", this.styleCache::write);
        this.os.finish();
    }

    private boolean hasComments() {
        for (Worksheet ws : this.worksheets) {
            if (ws.comments.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void writeComments() throws IOException {
        for (Worksheet ws : this.worksheets) {
            if (ws.comments.isEmpty()) continue;
            int index = this.getIndex(ws);
            this.writeFile("xl/comments" + index + ".xml", ws.comments::writeComments);
            this.writeFile("xl/drawings/vmlDrawing" + index + ".vml", ws.comments::writeVmlDrawing);
            this.writeFile("xl/drawings/drawing" + index + ".xml", ws.comments::writeDrawing);
            this.writeFile("xl/worksheets/_rels/sheet" + index + ".xml.rels", w -> {
                w.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
                w.append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
                w.append("<Relationship Id=\"d\" Target=\"../drawings/drawing" + index + ".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing\"/>");
                w.append("<Relationship Id=\"c\" Target=\"../comments" + index + ".xml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments\"/>");
                w.append("<Relationship Id=\"v\" Target=\"../drawings/vmlDrawing" + index + ".vml\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing\"/>");
                w.append("</Relationships>");
            });
        }
    }

    private void writeWorkbookFile() throws IOException {
        this.writeFile("xl/workbook.xml", w -> {
            w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><workbook xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"><workbookPr date1904=\"false\"/><bookViews><workbookView activeTab=\"0\"/></bookViews><sheets>");
            for (Worksheet ws : this.worksheets) {
                this.writeWorkbookSheet((Writer)w, ws);
            }
            w.append("</sheets></workbook>");
        });
    }

    private void writeWorkbookSheet(Writer w, Worksheet ws) throws IOException {
        w.append("<sheet name=\"").appendEscaped(ws.getName()).append("\" r:id=\"rId").append(this.getIndex(ws) + 2).append("\" sheetId=\"").append(this.getIndex(ws));
        if (ws.getVisibilityState() != null) {
            w.append("\" state=\"").append(ws.getVisibilityState().getName());
        }
        w.append("\"/>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String name, ThrowingConsumer<Writer> consumer) throws IOException {
        OpcOutputStream opcOutputStream = this.os;
        synchronized (opcOutputStream) {
            this.beginFile(name);
            consumer.accept(this.writer);
            this.endFile();
        }
    }

    Writer beginFile(String name) throws IOException {
        this.os.putNextEntry(new ZipEntry(name));
        return this.writer;
    }

    void endFile() throws IOException {
        this.writer.flush();
        this.os.closeEntry();
    }

    CachedString cacheString(String s) {
        return this.stringCache.cacheString(s);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment, Protection protection) {
        return this.styleCache.mergeAndCacheStyle(currentStyle, numberingFormat, font, fill, border, alignment, protection);
    }

    int cacheAlternateShadingFillColor(Fill fill) {
        return this.styleCache.cacheDxf(fill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex(Worksheet ws) {
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            return this.worksheets.indexOf(ws) + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Worksheet newWorksheet(String name) {
        String sheetName = name.replaceAll("[/\\\\\\?\\*\\]\\[\\:]", "-");
        if (sheetName.length() > 31) {
            sheetName = sheetName.substring(0, 31);
        }
        List<Worksheet> list = this.worksheets;
        synchronized (list) {
            int number = 1;
            Set names = this.worksheets.stream().map(Worksheet::getName).collect(Collectors.toSet());
            while (names.contains(sheetName)) {
                String suffix = String.format(Locale.ROOT, "_%d", number);
                sheetName = sheetName.length() + suffix.length() > 31 ? sheetName.substring(0, 31 - suffix.length()) + suffix : sheetName + suffix;
                ++number;
            }
            Worksheet worksheet = new Worksheet(this, sheetName);
            this.worksheets.add(worksheet);
            return worksheet;
        }
    }
}

