/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class SimpleXmlReader
implements Closeable {
    private final InputStream inputStream;
    private final XMLStreamReader reader;

    public SimpleXmlReader(XMLInputFactory factory, InputStream inputStream) throws XMLStreamException {
        this.inputStream = inputStream;
        this.reader = factory.createXMLStreamReader(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    public boolean goTo(BooleanSupplier predicate) throws XMLStreamException {
        while (this.reader.hasNext()) {
            this.reader.next();
            if (!predicate.getAsBoolean()) continue;
            return true;
        }
        return false;
    }

    public String getLocalName() {
        return this.reader.getLocalName();
    }

    public boolean isStartElement(String elementName) {
        return this.reader.isStartElement() && elementName.equals(this.reader.getLocalName());
    }

    public boolean isEndElement(String elementName) {
        return this.reader.isEndElement() && elementName.equals(this.reader.getLocalName());
    }

    public boolean goTo(String elementName) throws XMLStreamException {
        return this.goTo(() -> this.isStartElement(elementName));
    }

    public String getAttribute(String name) {
        return this.reader.getAttributeValue(null, name);
    }

    public String getAttributeRequired(String name) throws XMLStreamException {
        String value = this.getAttribute(name);
        if (value == null) {
            throw new XMLStreamException("missing required attribute " + name);
        }
        return value;
    }

    public String getAttribute(String namespace, String name) {
        return this.reader.getAttributeValue(namespace, name);
    }

    public Optional<String> getOptionalAttribute(String name) {
        return Optional.ofNullable(this.reader.getAttributeValue(null, name));
    }

    public Integer getIntAttribute(String name) {
        String value = this.reader.getAttributeValue(null, name);
        return value == null ? null : Integer.valueOf(value);
    }

    public void forEach(String startChildElement, String untilEndElement, Consumer<SimpleXmlReader> consumer) throws XMLStreamException {
        while (this.goTo(() -> this.isStartElement(startChildElement) || this.isEndElement(untilEndElement)) && !untilEndElement.equals(this.getLocalName())) {
            consumer.accept(this);
        }
    }

    public String getValueUntilEndElement(String elementName) throws XMLStreamException {
        return this.getValueUntilEndElement(elementName, "");
    }

    public String getValueUntilEndElement(String elementName, String skipping) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        int childElement = 1;
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            if (type == 12 || type == 4 || type == 6) {
                sb.append(this.reader.getText());
                continue;
            }
            if (type == 1) {
                if (skipping.equals(this.reader.getLocalName())) {
                    this.getValueUntilEndElement(this.reader.getLocalName());
                    continue;
                }
                ++childElement;
                continue;
            }
            if (type != 2 || !elementName.equals(this.reader.getLocalName()) || --childElement != 0) continue;
            break;
        }
        return sb.toString();
    }
}

