/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.util.Objects;
import org.dhatim.fastexcel.reader.CellAddress;

public final class CellRangeAddress {
    private final int firstRow;
    private final int lastRow;
    private final int firstCol;
    private final int lastCol;

    public CellRangeAddress(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.firstRow = firstRow;
        this.lastRow = lastRow;
        this.firstCol = firstCol;
        this.lastCol = lastCol;
        if (lastRow < firstRow || lastCol < firstCol) {
            throw new IllegalArgumentException("Invalid cell range, having lastRow < firstRow || lastCol < firstCol, had rows " + lastRow + " >= " + firstRow + " or cells " + lastCol + " >= " + firstCol);
        }
    }

    public int getFirstColumn() {
        return this.firstCol;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastColumn() {
        return this.lastCol;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public boolean isInRange(int row, int column) {
        return this.firstRow <= row && row <= this.lastRow && this.firstCol <= column && column <= this.lastCol;
    }

    public boolean isInRange(CellAddress cell) {
        return this.isInRange(cell.getRow(), cell.getColumn());
    }

    public boolean containsRow(int row) {
        return this.firstRow <= row && row <= this.lastRow;
    }

    public boolean containsColumn(int column) {
        return this.firstCol <= column && column <= this.lastCol;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CellRangeAddress other = (CellRangeAddress)obj;
        return this.firstRow == other.firstRow && this.firstCol == other.firstCol && this.lastRow == other.lastRow && this.lastCol == other.lastCol;
    }

    public int hashCode() {
        return Objects.hash(this.firstRow, this.firstCol, this.lastRow, this.lastCol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CellAddress.format(sb, this.firstRow, this.firstCol);
        sb.append(':');
        CellAddress.format(sb, this.lastRow, this.lastCol);
        return sb.toString();
    }

    public static CellRangeAddress valueOf(String ref) {
        CellAddress b;
        CellAddress a;
        int sep = ref.indexOf(58);
        if (sep == -1) {
            b = a = new CellAddress(ref);
        } else {
            a = new CellAddress(ref.substring(0, sep));
            b = new CellAddress(ref.substring(sep + 1));
        }
        return new CellRangeAddress(a.getRow(), b.getRow(), a.getColumn(), b.getColumn());
    }
}

