/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesInterpolator {
    private final Properties mProps;
    private final Matcher variableReferenceMatcher = Pattern.compile("^(.*?)\\$\\{([^}]+?)\\}(.*?)$", 32).matcher("");
    private final HashSet<String> verbatimVariables = new HashSet();

    public PropertiesInterpolator(Properties props) {
        this.mProps = props;
    }

    public String interpolate(String input) {
        if (input == null || input.length() == 0) {
            return input;
        }
        if (input.matches("^\\s*#.*$")) {
            return input;
        }
        String s = input;
        StringBuilder sb = new StringBuilder();
        while (true) {
            this.variableReferenceMatcher.reset(s);
            if (!this.variableReferenceMatcher.find()) break;
            String before = this.variableReferenceMatcher.group(1);
            String variableName = this.variableReferenceMatcher.group(2);
            String after = this.variableReferenceMatcher.group(3);
            if (this.verbatimVariables.contains(variableName)) {
                sb.append(before);
                sb.append("${");
                sb.append(variableName);
                sb.append("}");
            } else if (this.mProps.containsKey(variableName)) {
                String variableValue = this.mProps.getProperty(variableName);
                sb.append(before);
                sb.append(variableValue);
            } else {
                throw new IllegalStateException("The name '" + variableName + "' is not defined");
            }
            s = after;
        }
        sb.append(s);
        return sb.toString();
    }

    public void doNotInterpolate(String verbatimVariable) {
        this.verbatimVariables.add(verbatimVariable);
    }
}

