/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.util.Properties;
import org.devzendo.xplp.PropertiesInterpolator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class TestPropertiesInterpolation {
    private final String lineSeparator = System.getProperty("line.separator");
    private Properties mProps;
    private PropertiesInterpolator mInterpolator;
    private String mLibsString;

    @Before
    public void getPrerequisites() {
        this.mProps = new Properties();
        this.mProps.put("key", "value");
        this.mProps.put("long.key.name", "long value");
        this.mProps.put("return", "line1" + this.lineSeparator + "line2");
        StringBuilder sb = new StringBuilder();
        sb.append("            <string>$JAVAROOT/lib/BeanCounter-0.1.0-SNAPSHOT.jar</string>" + this.lineSeparator);
        sb.append("            <string>$JAVAROOT/lib/MiniMiser-0.1.0-SNAPSHOT.jar</string>" + this.lineSeparator);
        this.mLibsString = sb.toString();
        this.mProps.put("xplp.macosxclasspatharray", this.mLibsString);
        this.mInterpolator = new PropertiesInterpolator(this.mProps);
    }

    @Test
    public void nullAndEmptyPassedStraightThrough() {
        Assert.assertNull((Object)this.mInterpolator.interpolate(null));
        Assert.assertEquals((long)0L, (long)this.mInterpolator.interpolate("").length());
    }

    @Test
    public void noInterpolation() {
        Assert.assertEquals((Object)"verbatim text", (Object)this.mInterpolator.interpolate("verbatim text"));
    }

    @Test
    public void replaceOneInstance() {
        Assert.assertEquals((Object)"check value test", (Object)this.mInterpolator.interpolate("check ${key} test"));
        Assert.assertEquals((Object)"check long value test", (Object)this.mInterpolator.interpolate("check ${long.key.name} test"));
    }

    @Test
    public void replaceAtStart() {
        Assert.assertEquals((Object)"value test", (Object)this.mInterpolator.interpolate("${key} test"));
    }

    @Test
    public void replaceAtEnd() {
        Assert.assertEquals((Object)"test value", (Object)this.mInterpolator.interpolate("test ${key}"));
    }

    @Test
    public void replaceMultipleOccurrences() {
        Assert.assertEquals((Object)"check value test value investigate", (Object)this.mInterpolator.interpolate("check ${key} test ${key} investigate"));
    }

    @Test
    public void replaceMultipleOccurrencesMultipleKeys() {
        Assert.assertEquals((Object)"check value test long value foo long value", (Object)this.mInterpolator.interpolate("check ${key} test ${long.key.name} foo ${long.key.name}"));
    }

    @Test
    public void replaceMultipleOccurrencesMultipleKeysRightNextToEachOther() {
        Assert.assertEquals((Object)"valuelong valuelong value", (Object)this.mInterpolator.interpolate("${key}${long.key.name}${long.key.name}"));
    }

    @Test
    public void replaceMultipleOccurrencesMultipleKeysRightNextToEachOtherIncludingNewlines() {
        Assert.assertEquals((Object)("valueline1" + this.lineSeparator + "line2long value"), (Object)this.mInterpolator.interpolate("${key}${return}${long.key.name}"));
    }

    @Test(expected=IllegalStateException.class)
    public void variableNotFound() {
        this.mInterpolator.interpolate("wahey ${nonexistant} frugal!");
    }

    @Test
    public void replaceLongString() {
        Assert.assertEquals((Object)this.mLibsString, (Object)this.mInterpolator.interpolate("${xplp.macosxclasspatharray}"));
    }

    @Test
    public void dontInterpolateInComments() {
        Assert.assertEquals((Object)"# ${env.HOME}", (Object)this.mInterpolator.interpolate("# ${env.HOME}"));
    }

    @Test
    public void doNotReplaceNoInterpolatedVariables() {
        this.mInterpolator.doNotInterpolate("VERBATIM");
        Assert.assertEquals((Object)"check value test value don't replace ${VERBATIM} investigate", (Object)this.mInterpolator.interpolate("check ${key} test ${key} don't replace ${VERBATIM} investigate"));
    }

    @Test
    public void janelSpecialVerbatimVariablesAreNotReplaced() {
        this.mProps.put("FOUND_EXE_FOLDER", "${FOUND_EXE_FOLDER}");
        Assert.assertEquals((Object)"check value test value don't replace ${FOUND_EXE_FOLDER} investigate", (Object)this.mInterpolator.interpolate("check ${key} test ${key} don't replace ${FOUND_EXE_FOLDER} investigate"));
    }
}

