/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.devzendo.xplp.LauncherCreator;

public class WindowsLauncherCreator
extends LauncherCreator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String MSVCR71_DLL = "msvcr71.dll";
    private final String mLauncherType;
    private final String[] mJanelCustomLines;

    public WindowsLauncherCreator(AbstractMojo mojo, File outputDirectory, String mainClassName, String applicationName, String libraryDirectory, Set<Artifact> transitiveArtifacts, Set<File> resourceDirectories, Properties parameterProperties, String[] systemProperties, String[] vmArguments, String[] narClassifierTypes, String launcherType, String[] janelCustomLines) {
        super(mojo, outputDirectory, mainClassName, applicationName, libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, systemProperties, vmArguments, narClassifierTypes);
        this.mLauncherType = launcherType;
        this.mJanelCustomLines = janelCustomLines;
    }

    private void validate() {
        if (this.mLauncherType == null || this.mLauncherType.length() == 0) {
            String message = "No launcherType specified - this is mandatory for Windows";
            this.getMojo().getLog().warn((CharSequence)"No launcherType specified - this is mandatory for Windows");
            throw new IllegalStateException("No launcherType specified - this is mandatory for Windows");
        }
        if (!this.mLauncherType.equals("Console") && !this.mLauncherType.equals("GUI")) {
            String message = "launcherType must be either 'Console' or 'GUI' (GUI is the default if not specified)";
            this.getMojo().getLog().warn((CharSequence)"launcherType must be either 'Console' or 'GUI' (GUI is the default if not specified)");
            throw new IllegalStateException("launcherType must be either 'Console' or 'GUI' (GUI is the default if not specified)");
        }
    }

    @Override
    public void createLauncher() throws IOException {
        boolean allDirsOK;
        this.validate();
        this.getParameterProperties().put("xplp.windowssystemproperties", this.systemPropertiesAsJanelLines(this.getSystemProperties()));
        this.getParameterProperties().put("xplp.windowsvmarguments", this.stringsToSeparatedJanelLines(this.getVmArguments()));
        this.getParameterProperties().put("xplp.janelcustomlines", this.stringsToSeparatedJanelLines(this.mJanelCustomLines));
        this.getMojo().getLog().info((CharSequence)("Janel .EXE type:   " + this.mLauncherType));
        File osOutputDir = new File(this.getOutputDirectory(), "windows");
        File libDir = new File(osOutputDir, "lib");
        osOutputDir.mkdirs();
        libDir.mkdirs();
        boolean bl = allDirsOK = osOutputDir.exists() && libDir.exists();
        if (!allDirsOK) {
            throw new IOException("Could not create required directories under " + this.getOutputDirectory().getAbsolutePath());
        }
        File outputJanelEXE = new File(osOutputDir, this.getApplicationName() + ".exe");
        String janelEXEResource = "windows/" + (this.mLauncherType.equals("Console") ? "JanelConsole.exe" : "JanelWindows.exe");
        this.copyPluginResource(janelEXEResource, outputJanelEXE);
        this.copyPluginResource("windows/msvcr71.dll", new File(osOutputDir, MSVCR71_DLL));
        this.copyInterpolatedPluginResource("windows/launcher.lap", new File(osOutputDir, this.getApplicationName() + ".lap"));
        this.copyTransitiveArtifacts(libDir);
    }

    private String stringsToSeparatedJanelLines(String[] strings) {
        StringBuilder stringLines = new StringBuilder();
        if (strings.length > 0) {
            for (String string : strings) {
                stringLines.append(string);
                stringLines.append(LINE_SEPARATOR);
            }
        }
        return stringLines.toString();
    }

    private String systemPropertiesAsJanelLines(String[] systemProperties) {
        StringBuilder sysPropLines = new StringBuilder();
        if (systemProperties.length > 0) {
            for (String sysProp : systemProperties) {
                sysPropLines.append("-D");
                sysPropLines.append(sysProp);
                sysPropLines.append(LINE_SEPARATOR);
            }
        }
        return sysPropLines.toString();
    }
}

