/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.devzendo.xplp.LauncherCreator;

public final class MacOSXAppLauncherCreator
extends LauncherCreator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String APPLE_STUB = "Apple";
    public static final String UNIVERSAL_STUB = "Universal";
    private final String mFileType;
    private final String mIconsFileName;
    private final String mBundleSignature;
    private final String mBundleOsType;
    private final String mBundleTypeName;
    private final String mLauncherType;
    private final String mStubType;

    public MacOSXAppLauncherCreator(AbstractMojo mojo, File outputDirectory, String mainClassName, String applicationName, String libraryDirectory, Set<Artifact> transitiveArtifacts, Set<File> resourceDirectories, Properties parameterProperties, String[] systemProperties, String[] vmArguments, String[] narClassifierTypes, String launcherType, String fileType, String iconsFileName, String bundleSignature, String bundleOsType, String bundleTypeName, String stubType) {
        super(mojo, outputDirectory, mainClassName, applicationName, libraryDirectory, transitiveArtifacts, resourceDirectories, parameterProperties, systemProperties, vmArguments, narClassifierTypes);
        this.mFileType = fileType;
        this.mIconsFileName = iconsFileName;
        this.mBundleSignature = bundleSignature;
        this.mBundleOsType = bundleOsType;
        this.mBundleTypeName = bundleTypeName;
        this.mLauncherType = launcherType;
        this.mStubType = stubType;
    }

    private void validate() {
        if (this.mIconsFileName == null || this.mIconsFileName.length() == 0) {
            String message = "No iconsFileName specified - this is mandatory for Mac OS X";
            this.getMojo().getLog().warn((CharSequence)"No iconsFileName specified - this is mandatory for Mac OS X");
            throw new IllegalStateException("No iconsFileName specified - this is mandatory for Mac OS X");
        }
        if (this.mBundleSignature == null || this.mBundleSignature.length() == 0) {
            String message = "No bundleSignature specified - this is mandatory for Mac OS X";
            this.getMojo().getLog().warn((CharSequence)"No bundleSignature specified - this is mandatory for Mac OS X");
            throw new IllegalStateException("No bundleSignature specified - this is mandatory for Mac OS X");
        }
        if (this.mStubType == null || !this.mStubType.equals(APPLE_STUB) && !this.mStubType.equals(UNIVERSAL_STUB)) {
            String message = "Stub type must be 'Apple' or 'Universal'";
            this.getMojo().getLog().warn((CharSequence)"Stub type must be 'Apple' or 'Universal'");
            throw new IllegalStateException("Stub type must be 'Apple' or 'Universal'");
        }
    }

    @Override
    public void createLauncher() throws IOException {
        boolean allDirsOK;
        this.validate();
        this.getParameterProperties().put("xplp.macosxsystemproperties", this.systemPropertiesAsPlistDict(this.getSystemProperties()));
        this.getParameterProperties().put("xplp.macosxvmoptionsarray", this.vmArgumentsAsPlistArray(this.getVmArguments()));
        this.getParameterProperties().put("xplp.macosxclasspatharray", this.transitiveArtifactsAsPlistArray(this.getTransitiveArtifacts()));
        this.getMojo().getLog().info((CharSequence)("Launcher type:     " + this.mLauncherType));
        this.getMojo().getLog().info((CharSequence)("Icons file name:   " + this.mIconsFileName));
        this.getMojo().getLog().info((CharSequence)("File type:         " + this.mFileType));
        this.getMojo().getLog().info((CharSequence)("Bundle signature:  " + this.mBundleSignature));
        this.getMojo().getLog().info((CharSequence)("Bundle OS type:    " + this.mBundleOsType));
        this.getMojo().getLog().info((CharSequence)("Bundle type name:  " + this.mBundleTypeName));
        this.getMojo().getLog().info((CharSequence)("Stub type:         " + this.mStubType));
        File osOutputDir = new File(this.getOutputDirectory(), "macosx");
        File appDir = new File(osOutputDir, this.getApplicationName() + ".app");
        File contentsDir = new File(appDir, "Contents");
        File macOSDir = new File(contentsDir, "MacOS");
        File resourcesDir = new File(contentsDir, "Resources");
        File libDir = new File(resourcesDir, "Java/lib");
        osOutputDir.mkdirs();
        appDir.mkdirs();
        contentsDir.mkdirs();
        macOSDir.mkdirs();
        resourcesDir.mkdirs();
        libDir.mkdirs();
        boolean bl = allDirsOK = osOutputDir.exists() && appDir.exists() && contentsDir.exists() && macOSDir.exists() && resourcesDir.exists() && libDir.exists();
        if (!allDirsOK) {
            throw new IOException("Could not create required directories under " + appDir.getAbsolutePath());
        }
        File javaApplicationStub = new File(macOSDir, "JavaApplicationStub");
        if (this.mStubType.equals(APPLE_STUB)) {
            this.copyPluginResource("macosx/JavaApplicationStub", javaApplicationStub);
        }
        if (this.mStubType.equals(UNIVERSAL_STUB)) {
            this.copyPluginResource("macosx/universalJavaApplicationStub", javaApplicationStub);
        }
        this.makeExecutable(javaApplicationStub);
        this.copyProjectResource(this.mIconsFileName, new File(resourcesDir, this.mIconsFileName));
        this.copyInterpolatedPluginResource("macosx/Info.plist", new File(contentsDir, "Info.plist"));
        this.copyInterpolatedPluginResource("macosx/PkgInfo", new File(contentsDir, "PkgInfo"));
        this.copyTransitiveArtifacts(libDir);
    }

    private String vmArgumentsAsPlistArray(String[] vmArguments) {
        StringBuilder argsAsArray = new StringBuilder();
        if (vmArguments.length > 0) {
            argsAsArray.append("        <key>VMOptions</key>");
            argsAsArray.append(LINE_SEPARATOR);
            argsAsArray.append("        <array>");
            argsAsArray.append(LINE_SEPARATOR);
            for (String vmArg : vmArguments) {
                argsAsArray.append("           <string>");
                argsAsArray.append(vmArg);
                argsAsArray.append("</string>");
                argsAsArray.append(LINE_SEPARATOR);
            }
            argsAsArray.append("        </array>");
            argsAsArray.append(LINE_SEPARATOR);
        }
        return argsAsArray.toString();
    }

    private String systemPropertiesAsPlistDict(String[] systemProperties) {
        StringBuilder propsAsDictEntries = new StringBuilder();
        for (int i = 0; i < systemProperties.length; ++i) {
            String prop = systemProperties[i];
            this.appendSystemProperty(propsAsDictEntries, prop);
            propsAsDictEntries.append(LINE_SEPARATOR);
        }
        return propsAsDictEntries.toString();
    }

    private void appendSystemProperty(StringBuilder propsAsDictEntries, String prop) {
        String[] split = prop.split("\\s*=\\s*");
        propsAsDictEntries.append("            <key>");
        propsAsDictEntries.append(split[0]);
        propsAsDictEntries.append("</key>");
        propsAsDictEntries.append(LINE_SEPARATOR);
        propsAsDictEntries.append("            <string>");
        propsAsDictEntries.append(split[1]);
        propsAsDictEntries.append("</string>");
    }

    private String transitiveArtifactsAsPlistArray(Set<Artifact> transitiveArtifacts) {
        StringBuilder libsAsArtifacts = new StringBuilder();
        Set<String> transitiveArtifactFileNames = this.getTransitiveJarOrNarArtifactFileNames(transitiveArtifacts);
        for (String fileName : transitiveArtifactFileNames) {
            libsAsArtifacts.append("            <string>$JAVAROOT/lib/");
            libsAsArtifacts.append(fileName);
            libsAsArtifacts.append("</string>");
            libsAsArtifacts.append(LINE_SEPARATOR);
        }
        return libsAsArtifacts.toString();
    }
}

