/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.xplp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class LauncherCreator {
    private final AbstractMojo mMojo;
    private final File mOutputDirectory;
    private final String mMainClassName;
    private final String mApplicationName;
    private final String mLibraryDirectory;
    private final Set<Artifact> mTransitiveArtifacts;
    private final Set<File> mResourceDirectories;
    private final Properties mParameterProperties;
    private final String[] mSystemProperties;
    private final String[] mVmArguments;
    private final String[] mNarClassifierTypes;

    public LauncherCreator(AbstractMojo mojo, File outputDirectory, String mainClassName, String applicationName, String libraryDirectory, Set<Artifact> transitiveArtifacts, Set<File> resourceDirectories, Properties parameterProperties, String[] systemProperties, String[] vmArguments, String[] narClassifierTypes) {
        this.mMojo = mojo;
        this.mOutputDirectory = outputDirectory;
        this.mMainClassName = mainClassName;
        this.mApplicationName = applicationName;
        this.mLibraryDirectory = libraryDirectory;
        this.mTransitiveArtifacts = transitiveArtifacts;
        this.mResourceDirectories = resourceDirectories;
        this.mParameterProperties = parameterProperties;
        this.mSystemProperties = systemProperties;
        this.mVmArguments = vmArguments;
        this.mNarClassifierTypes = narClassifierTypes;
    }

    protected final AbstractMojo getMojo() {
        return this.mMojo;
    }

    protected final Set<Artifact> getTransitiveArtifacts() {
        return this.mTransitiveArtifacts;
    }

    protected final File getOutputDirectory() {
        return this.mOutputDirectory;
    }

    protected final String getMainClassName() {
        return this.mMainClassName;
    }

    protected final String getApplicationName() {
        return this.mApplicationName;
    }

    protected final String getLibraryDirectory() {
        return this.mLibraryDirectory;
    }

    protected final Set<File> getResourceDirectories() {
        return this.mResourceDirectories;
    }

    protected final Properties getParameterProperties() {
        return this.mParameterProperties;
    }

    protected final String[] getSystemProperties() {
        return this.mSystemProperties;
    }

    protected final String[] getVmArguments() {
        return this.mVmArguments;
    }

    public abstract void createLauncher() throws IOException;

    protected final void copyPluginResource(String resourceName, File destinationFile) throws IOException {
        InputStream resourceAsStream = this.getPluginResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            String message = "Could not open resource " + resourceName;
            this.mMojo.getLog().warn((CharSequence)message);
            throw new IOException(message);
        }
        OutputStream outputStream = this.createFileOutputStream(destinationFile);
        long bytesCopied = this.copyStream(resourceName, destinationFile.getAbsolutePath(), resourceAsStream, outputStream);
        this.mMojo.getLog().info((CharSequence)("Created " + destinationFile.getAbsolutePath() + " [" + bytesCopied + " byte(s)]"));
    }

    protected final void copyProjectResource(String resourceName, File destinationFile) throws IOException {
        InputStream resourceAsStream = this.getProjectResourceAsStream(resourceName);
        OutputStream outputStream = this.createFileOutputStream(destinationFile);
        long bytesCopied = this.copyStream(resourceName, destinationFile.getAbsolutePath(), resourceAsStream, outputStream);
        this.mMojo.getLog().info((CharSequence)("Created " + destinationFile.getAbsolutePath() + " [" + bytesCopied + " byte(s)]"));
    }

    private OutputStream createFileOutputStream(File destinationFile) throws IOException {
        try {
            return new FileOutputStream(destinationFile);
        }
        catch (FileNotFoundException e) {
            String message = "Could not create destination file " + destinationFile.getAbsolutePath() + ": " + e.getMessage();
            this.mMojo.getLog().warn((CharSequence)message);
            throw new IOException(message);
        }
    }

    private InputStream getProjectResourceAsStream(String resourceName) throws IOException {
        for (File resourceDir : this.mResourceDirectories) {
            try {
                FileInputStream resourceAsStream = new FileInputStream(new File(resourceDir, resourceName));
                this.mMojo.getLog().debug((CharSequence)("Located resource " + resourceName + " in directory " + resourceDir.getAbsolutePath()));
                return resourceAsStream;
            }
            catch (FileNotFoundException e) {
                this.mMojo.getLog().debug((CharSequence)("Resource " + resourceName + " not found in " + resourceDir.getAbsolutePath()));
            }
        }
        String message = "Could not open resource " + resourceName;
        this.mMojo.getLog().warn((CharSequence)message);
        throw new IOException(message);
    }

    private InputStream getPluginResourceAsStream(String resourceName) {
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        return resourceAsStream;
    }

    protected Set<String> getTransitiveJarOrNarArtifactFileNames(Set<Artifact> transitiveArtifacts) {
        HashSet<String> jarNarArtifacts = new HashSet<String>();
        for (Artifact transitiveArtifact : transitiveArtifacts) {
            if (!transitiveArtifact.getScope().equals("compile") || !transitiveArtifact.getType().equals("jar") && !transitiveArtifact.getType().equals("nar")) continue;
            String artifactFileName = transitiveArtifact.getFile().getName().replaceFirst("\\.nar$", ".jar");
            jarNarArtifacts.add(artifactFileName);
        }
        return jarNarArtifacts;
    }

    protected final void copyFile(File sourceFile, File destinationDirectory) throws IOException {
        String destinationFileName = sourceFile.getName();
        this.copyFileWithRename(sourceFile, destinationDirectory, destinationFileName);
    }

    private void copyFileWithRename(File sourceFile, File destinationDirectory, String destinationFileName) throws IOException {
        FileOutputStream outputStream;
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(sourceFile);
        }
        catch (IOException ioe) {
            String warning = "Could not open source file '" + sourceFile + "': " + ioe.getMessage();
            this.mMojo.getLog().warn((CharSequence)warning);
            throw new IOException(warning);
        }
        File destinationFile = new File(destinationDirectory, destinationFileName);
        try {
            outputStream = new FileOutputStream(destinationFile);
        }
        catch (FileNotFoundException e) {
            String message = "Could not create destination file " + destinationFile.getAbsolutePath() + ": " + e.getMessage();
            this.mMojo.getLog().warn((CharSequence)message);
            throw new IOException(message);
        }
        long bytesCopied = this.copyStream(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath(), inputStream, outputStream);
        this.mMojo.getLog().info((CharSequence)("Created " + destinationDirectory.getAbsoluteFile() + File.separatorChar + destinationFileName + " from " + sourceFile.getAbsolutePath() + " [" + bytesCopied + " byte(s) copied]"));
    }

    private long copyStream(String inName, String outName, InputStream inputStream, OutputStream outputStream) throws IOException {
        int bufsize = 16384;
        byte[] buf = new byte[16384];
        long totalRead = 0L;
        try {
            int nRead;
            while ((nRead = inputStream.read(buf, 0, 16384)) != -1) {
                outputStream.write(buf, 0, nRead);
                totalRead += (long)nRead;
            }
            long l = totalRead;
            return l;
        }
        catch (IOException e) {
            String message = "Could not copy " + inName + " to " + outName + ": " + e.getMessage();
            this.mMojo.getLog().warn((CharSequence)message);
            throw new IOException(message);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ioe) {}
            try {
                outputStream.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected final void copyTransitiveArtifacts(File destinationDirectory) throws IOException {
        this.getMojo().getLog().info((CharSequence)"Copying transitive artifacts");
        Set<Artifact> transitiveArtifacts = this.getTransitiveArtifacts();
        this.getMojo().getLog().info((CharSequence)("There are " + transitiveArtifacts.size() + " transitive artifacts"));
        for (Artifact artifact : transitiveArtifacts) {
            if (artifact.getScope().equals("compile")) {
                this.copyTransitiveArtifact(destinationDirectory, artifact);
                continue;
            }
            this.getMojo().getLog().info((CharSequence)("Not copying transitive artifact " + artifact + " since it is not a compile-scoped artifact"));
        }
    }

    private void copyTransitiveArtifact(File destinationDirectory, Artifact artifact) throws IOException {
        if (!artifact.getType().equals("jar") && !artifact.getType().equals("nar")) {
            this.getMojo().getLog().info((CharSequence)("Not copying transitive artifact " + artifact + " since it is not a jar or nar artifact"));
            return;
        }
        this.getMojo().getLog().info((CharSequence)("Copying transitive artifact " + artifact));
        File artifactFile = artifact.getFile();
        if (artifactFile.exists() && artifactFile.isFile()) {
            if (artifact.getType().equals("nar")) {
                this.copyTransitiveNarArtifact(artifact, destinationDirectory);
            } else {
                this.copyFile(artifactFile, destinationDirectory);
            }
        } else {
            this.getMojo().getLog().warn((CharSequence)("Not copying transitive artifact " + artifact + " since it either doesn't exist or is not a file"));
            this.getMojo().getLog().info((CharSequence)"(Perhaps you're running this from an IDE, and this artifact is resolved as a project in your");
            this.getMojo().getLog().info((CharSequence)" workspace and therefore on your classpath by the IDE?)");
        }
    }

    private void copyTransitiveNarArtifact(Artifact artifact, File destinationDirectory) throws IOException {
        File artifactFile = artifact.getFile();
        String destinationJarFileName = artifactFile.getName().replace(".nar", ".jar");
        this.copyFileWithRename(artifactFile, destinationDirectory, destinationJarFileName);
        for (String narClassifierType : this.mNarClassifierTypes) {
            String[] split = narClassifierType.split(":");
            this.copyNarClassifierType(artifact, destinationDirectory, split[0], split[1]);
        }
    }

    private void copyNarClassifierType(Artifact artifact, File destinationDirectory, String classifier, String type) throws IOException {
        File[] unpackedNarFiles;
        this.getMojo().getLog().info((CharSequence)("Copying unpacked NAR files for artifact: " + artifact));
        File unpackedNarDirectory = new File(this.mOutputDirectory, "nar/lib/" + classifier + "/" + type);
        if (!unpackedNarDirectory.exists() || !unpackedNarDirectory.isDirectory()) {
            this.getMojo().getLog().warn((CharSequence)("NAR unpacked library directory " + unpackedNarDirectory.getAbsolutePath() + " for classifier:type " + classifier + ":" + type + " does not exist or is not a directory"));
            this.getMojo().getLog().warn((CharSequence)"Did you forget to use the nar-assembly goal?");
            return;
        }
        for (File file : unpackedNarFiles = unpackedNarDirectory.listFiles()) {
            boolean isAnArtifactFile;
            String name = file.getName();
            this.getMojo().getLog().info((CharSequence)("Considering NAR unpacked file: " + file.getAbsolutePath()));
            if (name.equals("history.xml")) {
                this.getMojo().getLog().info((CharSequence)("Not copying " + name + " as it is NAR metadata"));
                continue;
            }
            boolean bl = isAnArtifactFile = name.contains(artifact.getArtifactId()) && name.contains(artifact.getVersion());
            if (!isAnArtifactFile) {
                this.getMojo().getLog().warn((CharSequence)("Not copying " + name + " as it does not refer to the artifact " + artifact));
                continue;
            }
            this.copyFile(file, destinationDirectory);
        }
    }

    protected final void copyInterpolatedProjectResource(String resourceName, File outputFile) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getProjectResourceAsStream(resourceName)));
        this.copyInterpolatedResource(resourceName, outputFile, br);
    }

    protected final void copyInterpolatedPluginResource(String resourceName, File outputFile) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.getPluginResourceAsStream(resourceName)));
        this.copyInterpolatedResource(resourceName, outputFile, br);
    }

    /*
     * Exception decompiling
     */
    private void copyInterpolatedResource(String resourceName, File outputFile, BufferedReader br) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FileWriter createFileWriter(File outputFile) throws IOException {
        try {
            return new FileWriter(outputFile);
        }
        catch (IOException e) {
            String message = "Could not create destination file " + outputFile.getAbsolutePath() + ": " + e.getMessage();
            this.mMojo.getLog().warn((CharSequence)message);
            throw new IOException(message);
        }
    }

    protected final void makeExecutable(File nonExecutableFile) {
        this.getMojo().getLog().info((CharSequence)("Making " + nonExecutableFile + " executable"));
        Commandline cl = new Commandline("chmod");
        cl.addArguments(new String[]{"a+x", nonExecutableFile.getAbsolutePath()});
        try {
            CommandLineUtils.StringStreamConsumer output = new CommandLineUtils.StringStreamConsumer();
            CommandLineUtils.StringStreamConsumer error = new CommandLineUtils.StringStreamConsumer();
            int returnValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)output, (StreamConsumer)error);
            if (returnValue != 0) {
                this.getMojo().getLog().warn((CharSequence)("chmod exit code is " + returnValue));
                this.getMojo().getLog().warn((CharSequence)("chmod output: " + output.getOutput()));
                this.getMojo().getLog().warn((CharSequence)("chmod error output: " + error.getOutput()));
            }
        }
        catch (CommandLineException e) {
            this.getMojo().getLog().warn((CharSequence)("Couldn't run chmod: " + e.getMessage()));
        }
    }
}

