/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.deeplearning4j.resources;

import java.io.File;
import org.deeplearning4j.common.resources.DL4JResources;
import org.eclipse.deeplearning4j.resources.BaseResource;
import org.eclipse.deeplearning4j.resources.ResourceType;

public class Dl4jZooResource
extends BaseResource {
    private String modelName;

    public Dl4jZooResource(String fileName, String archiveName, String modelName) {
        super(fileName, archiveName);
        this.modelName = modelName;
    }

    public Dl4jZooResource(String fileName, String modelName) {
        this(fileName, "", modelName);
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public String rootUrl() {
        return DL4JResources.getBaseDownloadURL() + "/models";
    }

    @Override
    public File localCacheDirectory() {
        File rootCacheDir = DL4JResources.getDirectory(org.deeplearning4j.common.resources.ResourceType.ZOO_MODEL, this.modelName);
        return rootCacheDir;
    }

    @Override
    public ResourceType resourceType() {
        return ResourceType.LEGACY_ZOO;
    }
}

