/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.util;

import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingObserver
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(BlockingObserver.class);
    protected AtomicBoolean state = new AtomicBoolean(false);
    protected AtomicBoolean exception;

    public BlockingObserver(AtomicBoolean exception) {
        this.exception = exception;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.state.set(true);
    }

    public void waitTillDone() throws InterruptedException {
        while (!this.exception.get() && !this.state.get()) {
            Thread.sleep(5L);
        }
    }

    public AtomicBoolean getState() {
        return this.state;
    }

    public AtomicBoolean getException() {
        return this.exception;
    }

    public void setState(AtomicBoolean state) {
        this.state = state;
    }

    public void setException(AtomicBoolean exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockingObserver)) {
            return false;
        }
        BlockingObserver other = (BlockingObserver)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicBoolean this$state = this.getState();
        AtomicBoolean other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        AtomicBoolean this$exception = this.getException();
        AtomicBoolean other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockingObserver;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicBoolean $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        AtomicBoolean $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public String toString() {
        return "BlockingObserver(state=" + this.getState() + ", exception=" + this.getException() + ")";
    }
}

