/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.python;

import java.io.Serializable;
import org.deeplearning4j.spark.parameterserver.python.ArrayDescriptor;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;

public class DataSetDescriptor
implements Serializable {
    private ArrayDescriptor features;
    private ArrayDescriptor labels;
    private ArrayDescriptor featuresMask;
    private ArrayDescriptor labelsMask;
    private boolean preProcessed;

    public DataSetDescriptor(ArrayDescriptor features, ArrayDescriptor labels, ArrayDescriptor featuresMask, ArrayDescriptor labelsMask) {
        this.features = features;
        this.labels = labels;
        this.featuresMask = featuresMask;
        this.labelsMask = labelsMask;
    }

    public DataSetDescriptor(DataSet ds) throws Exception {
        this.features = new ArrayDescriptor(ds.getFeatures());
        this.labels = new ArrayDescriptor(ds.getLabels());
        INDArray featuresMask = ds.getFeaturesMaskArray();
        this.featuresMask = featuresMask == null ? null : new ArrayDescriptor(featuresMask);
        INDArray labelsMask = ds.getLabelsMaskArray();
        this.labelsMask = labelsMask == null ? null : new ArrayDescriptor(labelsMask);
        this.preProcessed = ds.isPreProcessed();
    }

    public DataSet getDataSet() {
        INDArray features = this.features.getArray();
        INDArray labels = this.labels.getArray();
        INDArray featuresMask = this.featuresMask == null ? null : this.featuresMask.getArray();
        INDArray labelsMask = this.labelsMask == null ? null : this.labelsMask.getArray();
        DataSet ds = new DataSet(features, labels, featuresMask, labelsMask);
        if (this.preProcessed) {
            ds.markAsPreProcessed();
        }
        return ds;
    }

    public ArrayDescriptor getFeatures() {
        return this.features;
    }

    public ArrayDescriptor getLabels() {
        return this.labels;
    }

    public ArrayDescriptor getFeaturesMask() {
        return this.featuresMask;
    }

    public ArrayDescriptor getLabelsMask() {
        return this.labelsMask;
    }
}

