/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.networking.v2;

import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.optimize.solvers.accumulation.EncodingHandler;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ResidualPostProcessor;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ThresholdAlgorithm;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.parameterserver.distributed.v2.ModelParameterServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiredEncodingHandler
extends EncodingHandler {
    private static final Logger log = LoggerFactory.getLogger(WiredEncodingHandler.class);
    protected AtomicLong updatesCounter = new AtomicLong(0L);

    public WiredEncodingHandler(ThresholdAlgorithm thresholdAlgorithm, ResidualPostProcessor residualPostProcessor, Integer boundary, boolean encodingDebugMode) {
        super(thresholdAlgorithm, residualPostProcessor, boundary, encodingDebugMode);
    }

    protected void sendMessage(@NonNull INDArray message, int iterationNumber, int epochNumber) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try (MemoryWorkspace wsO = Nd4j.getMemoryManager().scopeOutOfWorkspaces();){
            long updateId = this.updatesCounter.getAndIncrement();
            INDArray m = message.dup();
            ModelParameterServer.getInstance().sendUpdate(m, iterationNumber, epochNumber);
        }
        super.sendMessage(message, iterationNumber, epochNumber);
    }
}

