/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.ParallelMultiDataSetIterator;

public class VirtualMultiDataSetIterator
implements ParallelMultiDataSetIterator {
    protected final List<Iterator<MultiDataSet>> iterators;
    protected final AtomicInteger position;

    public VirtualMultiDataSetIterator(@NonNull List<Iterator<MultiDataSet>> iterators) {
        if (iterators == null) {
            throw new NullPointerException("iterators is marked non-null but is null");
        }
        this.iterators = iterators;
        this.position = new AtomicInteger(0);
    }

    public MultiDataSet next(int num) {
        return this.next();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return null;
    }

    public boolean resetSupported() {
        return false;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext() {
        boolean ret = this.position.get() < this.iterators.size() - 1 || this.position.get() < this.iterators.size() && this.iterators.get(this.position.get()).hasNext();
        return ret;
    }

    public MultiDataSet next() {
        if (!this.iterators.get(this.position.get()).hasNext()) {
            this.position.getAndIncrement();
        }
        return this.iterators.get(this.position.get()).next();
    }

    public void remove() {
    }

    public void attachThread(int producer) {
    }

    public boolean hasNextFor() {
        return false;
    }

    public boolean hasNextFor(int consumer) {
        return false;
    }

    public MultiDataSet nextFor(int consumer) {
        return null;
    }

    public MultiDataSet nextFor() {
        return null;
    }
}

