/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.functions;

import java.util.Collections;
import java.util.Iterator;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.deeplearning4j.spark.api.TrainingResult;
import org.deeplearning4j.spark.api.TrainingWorker;
import org.deeplearning4j.spark.parameterserver.pw.SharedTrainingWrapper;
import org.deeplearning4j.spark.parameterserver.training.SharedTrainingResult;
import org.deeplearning4j.spark.parameterserver.training.SharedTrainingWorker;
import org.nd4j.linalg.dataset.DataSet;

public class SharedFlatMapDataSet<R extends TrainingResult>
implements FlatMapFunction<Iterator<DataSet>, R> {
    private final SharedTrainingWorker worker;

    public SharedFlatMapDataSet(TrainingWorker<R> worker) {
        this.worker = (SharedTrainingWorker)worker;
    }

    public Iterator<R> call(Iterator<DataSet> dataSetIterator) throws Exception {
        if (!dataSetIterator.hasNext()) {
            return Collections.emptyIterator();
        }
        SharedTrainingWrapper.getInstance(this.worker.getInstanceId()).attachDS(dataSetIterator);
        SharedTrainingResult result = SharedTrainingWrapper.getInstance(this.worker.getInstanceId()).run(this.worker);
        return Collections.singletonList(result).iterator();
    }
}

