/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.conf;

import java.io.Serializable;
import lombok.NonNull;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.optimize.solvers.accumulation.MessageHandler;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ResidualPostProcessor;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ThresholdAlgorithm;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;

public class SharedTrainingConfiguration
implements Serializable {
    protected VoidConfiguration voidConfiguration;
    protected WorkspaceMode workspaceMode;
    protected int prefetchSize;
    protected boolean epochReset;
    protected int numberOfWorkersPerNode;
    protected long debugLongerIterations;
    protected boolean encodingDebugMode;
    protected int bufferSize;
    protected ThresholdAlgorithm thresholdAlgorithm;
    protected ResidualPostProcessor residualPostProcessor;
    protected String messageHandlerClass;

    public void setMessageHandlerClass(@NonNull String messageHandlerClass) {
        if (messageHandlerClass == null) {
            throw new NullPointerException("messageHandlerClass is marked non-null but is null");
        }
        this.messageHandlerClass = messageHandlerClass;
    }

    public void setMessageHandlerClass(@NonNull MessageHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        this.messageHandlerClass = handler.getClass().getCanonicalName();
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static int $default$prefetchSize() {
        return 2;
    }

    private static boolean $default$epochReset() {
        return false;
    }

    private static int $default$numberOfWorkersPerNode() {
        return -1;
    }

    private static long $default$debugLongerIterations() {
        return 0L;
    }

    private static boolean $default$encodingDebugMode() {
        return false;
    }

    private static int $default$bufferSize() {
        return 0;
    }

    public static SharedTrainingConfigurationBuilder builder() {
        return new SharedTrainingConfigurationBuilder();
    }

    public VoidConfiguration getVoidConfiguration() {
        return this.voidConfiguration;
    }

    public WorkspaceMode getWorkspaceMode() {
        return this.workspaceMode;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public boolean isEpochReset() {
        return this.epochReset;
    }

    public int getNumberOfWorkersPerNode() {
        return this.numberOfWorkersPerNode;
    }

    public long getDebugLongerIterations() {
        return this.debugLongerIterations;
    }

    public boolean isEncodingDebugMode() {
        return this.encodingDebugMode;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ThresholdAlgorithm getThresholdAlgorithm() {
        return this.thresholdAlgorithm;
    }

    public ResidualPostProcessor getResidualPostProcessor() {
        return this.residualPostProcessor;
    }

    public String getMessageHandlerClass() {
        return this.messageHandlerClass;
    }

    public void setVoidConfiguration(VoidConfiguration voidConfiguration) {
        this.voidConfiguration = voidConfiguration;
    }

    public void setWorkspaceMode(WorkspaceMode workspaceMode) {
        this.workspaceMode = workspaceMode;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public void setEpochReset(boolean epochReset) {
        this.epochReset = epochReset;
    }

    public void setNumberOfWorkersPerNode(int numberOfWorkersPerNode) {
        this.numberOfWorkersPerNode = numberOfWorkersPerNode;
    }

    public void setDebugLongerIterations(long debugLongerIterations) {
        this.debugLongerIterations = debugLongerIterations;
    }

    public void setEncodingDebugMode(boolean encodingDebugMode) {
        this.encodingDebugMode = encodingDebugMode;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setThresholdAlgorithm(ThresholdAlgorithm thresholdAlgorithm) {
        this.thresholdAlgorithm = thresholdAlgorithm;
    }

    public void setResidualPostProcessor(ResidualPostProcessor residualPostProcessor) {
        this.residualPostProcessor = residualPostProcessor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedTrainingConfiguration)) {
            return false;
        }
        SharedTrainingConfiguration other = (SharedTrainingConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPrefetchSize() != other.getPrefetchSize()) {
            return false;
        }
        if (this.isEpochReset() != other.isEpochReset()) {
            return false;
        }
        if (this.getNumberOfWorkersPerNode() != other.getNumberOfWorkersPerNode()) {
            return false;
        }
        if (this.getDebugLongerIterations() != other.getDebugLongerIterations()) {
            return false;
        }
        if (this.isEncodingDebugMode() != other.isEncodingDebugMode()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        VoidConfiguration this$voidConfiguration = this.getVoidConfiguration();
        VoidConfiguration other$voidConfiguration = other.getVoidConfiguration();
        if (this$voidConfiguration == null ? other$voidConfiguration != null : !this$voidConfiguration.equals(other$voidConfiguration)) {
            return false;
        }
        WorkspaceMode this$workspaceMode = this.getWorkspaceMode();
        WorkspaceMode other$workspaceMode = other.getWorkspaceMode();
        if (this$workspaceMode == null ? other$workspaceMode != null : !this$workspaceMode.equals(other$workspaceMode)) {
            return false;
        }
        ThresholdAlgorithm this$thresholdAlgorithm = this.getThresholdAlgorithm();
        ThresholdAlgorithm other$thresholdAlgorithm = other.getThresholdAlgorithm();
        if (this$thresholdAlgorithm == null ? other$thresholdAlgorithm != null : !this$thresholdAlgorithm.equals(other$thresholdAlgorithm)) {
            return false;
        }
        ResidualPostProcessor this$residualPostProcessor = this.getResidualPostProcessor();
        ResidualPostProcessor other$residualPostProcessor = other.getResidualPostProcessor();
        if (this$residualPostProcessor == null ? other$residualPostProcessor != null : !this$residualPostProcessor.equals(other$residualPostProcessor)) {
            return false;
        }
        String this$messageHandlerClass = this.getMessageHandlerClass();
        String other$messageHandlerClass = other.getMessageHandlerClass();
        return !(this$messageHandlerClass == null ? other$messageHandlerClass != null : !this$messageHandlerClass.equals(other$messageHandlerClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharedTrainingConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPrefetchSize();
        result = result * 59 + (this.isEpochReset() ? 79 : 97);
        result = result * 59 + this.getNumberOfWorkersPerNode();
        long $debugLongerIterations = this.getDebugLongerIterations();
        result = result * 59 + (int)($debugLongerIterations >>> 32 ^ $debugLongerIterations);
        result = result * 59 + (this.isEncodingDebugMode() ? 79 : 97);
        result = result * 59 + this.getBufferSize();
        VoidConfiguration $voidConfiguration = this.getVoidConfiguration();
        result = result * 59 + ($voidConfiguration == null ? 43 : $voidConfiguration.hashCode());
        WorkspaceMode $workspaceMode = this.getWorkspaceMode();
        result = result * 59 + ($workspaceMode == null ? 43 : $workspaceMode.hashCode());
        ThresholdAlgorithm $thresholdAlgorithm = this.getThresholdAlgorithm();
        result = result * 59 + ($thresholdAlgorithm == null ? 43 : $thresholdAlgorithm.hashCode());
        ResidualPostProcessor $residualPostProcessor = this.getResidualPostProcessor();
        result = result * 59 + ($residualPostProcessor == null ? 43 : $residualPostProcessor.hashCode());
        String $messageHandlerClass = this.getMessageHandlerClass();
        result = result * 59 + ($messageHandlerClass == null ? 43 : $messageHandlerClass.hashCode());
        return result;
    }

    public String toString() {
        return "SharedTrainingConfiguration(voidConfiguration=" + this.getVoidConfiguration() + ", workspaceMode=" + this.getWorkspaceMode() + ", prefetchSize=" + this.getPrefetchSize() + ", epochReset=" + this.isEpochReset() + ", numberOfWorkersPerNode=" + this.getNumberOfWorkersPerNode() + ", debugLongerIterations=" + this.getDebugLongerIterations() + ", encodingDebugMode=" + this.isEncodingDebugMode() + ", bufferSize=" + this.getBufferSize() + ", thresholdAlgorithm=" + this.getThresholdAlgorithm() + ", residualPostProcessor=" + this.getResidualPostProcessor() + ", messageHandlerClass=" + this.getMessageHandlerClass() + ")";
    }

    public SharedTrainingConfiguration() {
        this.workspaceMode = SharedTrainingConfiguration.$default$workspaceMode();
        this.prefetchSize = SharedTrainingConfiguration.$default$prefetchSize();
        this.epochReset = SharedTrainingConfiguration.$default$epochReset();
        this.numberOfWorkersPerNode = SharedTrainingConfiguration.$default$numberOfWorkersPerNode();
        this.debugLongerIterations = SharedTrainingConfiguration.$default$debugLongerIterations();
        this.encodingDebugMode = SharedTrainingConfiguration.$default$encodingDebugMode();
        this.bufferSize = SharedTrainingConfiguration.$default$bufferSize();
    }

    public SharedTrainingConfiguration(VoidConfiguration voidConfiguration, WorkspaceMode workspaceMode, int prefetchSize, boolean epochReset, int numberOfWorkersPerNode, long debugLongerIterations, boolean encodingDebugMode, int bufferSize, ThresholdAlgorithm thresholdAlgorithm, ResidualPostProcessor residualPostProcessor, String messageHandlerClass) {
        this.voidConfiguration = voidConfiguration;
        this.workspaceMode = workspaceMode;
        this.prefetchSize = prefetchSize;
        this.epochReset = epochReset;
        this.numberOfWorkersPerNode = numberOfWorkersPerNode;
        this.debugLongerIterations = debugLongerIterations;
        this.encodingDebugMode = encodingDebugMode;
        this.bufferSize = bufferSize;
        this.thresholdAlgorithm = thresholdAlgorithm;
        this.residualPostProcessor = residualPostProcessor;
        this.messageHandlerClass = messageHandlerClass;
    }

    public static class SharedTrainingConfigurationBuilder {
        private VoidConfiguration voidConfiguration;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean prefetchSize$set;
        private int prefetchSize$value;
        private boolean epochReset$set;
        private boolean epochReset$value;
        private boolean numberOfWorkersPerNode$set;
        private int numberOfWorkersPerNode$value;
        private boolean debugLongerIterations$set;
        private long debugLongerIterations$value;
        private boolean encodingDebugMode$set;
        private boolean encodingDebugMode$value;
        private boolean bufferSize$set;
        private int bufferSize$value;
        private ThresholdAlgorithm thresholdAlgorithm;
        private ResidualPostProcessor residualPostProcessor;
        private String messageHandlerClass;

        SharedTrainingConfigurationBuilder() {
        }

        public SharedTrainingConfigurationBuilder voidConfiguration(VoidConfiguration voidConfiguration) {
            this.voidConfiguration = voidConfiguration;
            return this;
        }

        public SharedTrainingConfigurationBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder prefetchSize(int prefetchSize) {
            this.prefetchSize$value = prefetchSize;
            this.prefetchSize$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder epochReset(boolean epochReset) {
            this.epochReset$value = epochReset;
            this.epochReset$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder numberOfWorkersPerNode(int numberOfWorkersPerNode) {
            this.numberOfWorkersPerNode$value = numberOfWorkersPerNode;
            this.numberOfWorkersPerNode$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder debugLongerIterations(long debugLongerIterations) {
            this.debugLongerIterations$value = debugLongerIterations;
            this.debugLongerIterations$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder encodingDebugMode(boolean encodingDebugMode) {
            this.encodingDebugMode$value = encodingDebugMode;
            this.encodingDebugMode$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder bufferSize(int bufferSize) {
            this.bufferSize$value = bufferSize;
            this.bufferSize$set = true;
            return this;
        }

        public SharedTrainingConfigurationBuilder thresholdAlgorithm(ThresholdAlgorithm thresholdAlgorithm) {
            this.thresholdAlgorithm = thresholdAlgorithm;
            return this;
        }

        public SharedTrainingConfigurationBuilder residualPostProcessor(ResidualPostProcessor residualPostProcessor) {
            this.residualPostProcessor = residualPostProcessor;
            return this;
        }

        public SharedTrainingConfigurationBuilder messageHandlerClass(String messageHandlerClass) {
            this.messageHandlerClass = messageHandlerClass;
            return this;
        }

        public SharedTrainingConfiguration build() {
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = SharedTrainingConfiguration.$default$workspaceMode();
            }
            int prefetchSize$value = this.prefetchSize$value;
            if (!this.prefetchSize$set) {
                prefetchSize$value = SharedTrainingConfiguration.$default$prefetchSize();
            }
            boolean epochReset$value = this.epochReset$value;
            if (!this.epochReset$set) {
                epochReset$value = SharedTrainingConfiguration.$default$epochReset();
            }
            int numberOfWorkersPerNode$value = this.numberOfWorkersPerNode$value;
            if (!this.numberOfWorkersPerNode$set) {
                numberOfWorkersPerNode$value = SharedTrainingConfiguration.$default$numberOfWorkersPerNode();
            }
            long debugLongerIterations$value = this.debugLongerIterations$value;
            if (!this.debugLongerIterations$set) {
                debugLongerIterations$value = SharedTrainingConfiguration.$default$debugLongerIterations();
            }
            boolean encodingDebugMode$value = this.encodingDebugMode$value;
            if (!this.encodingDebugMode$set) {
                encodingDebugMode$value = SharedTrainingConfiguration.$default$encodingDebugMode();
            }
            int bufferSize$value = this.bufferSize$value;
            if (!this.bufferSize$set) {
                bufferSize$value = SharedTrainingConfiguration.$default$bufferSize();
            }
            return new SharedTrainingConfiguration(this.voidConfiguration, workspaceMode$value, prefetchSize$value, epochReset$value, numberOfWorkersPerNode$value, debugLongerIterations$value, encodingDebugMode$value, bufferSize$value, this.thresholdAlgorithm, this.residualPostProcessor, this.messageHandlerClass);
        }

        public String toString() {
            return "SharedTrainingConfiguration.SharedTrainingConfigurationBuilder(voidConfiguration=" + this.voidConfiguration + ", workspaceMode$value=" + this.workspaceMode$value + ", prefetchSize$value=" + this.prefetchSize$value + ", epochReset$value=" + this.epochReset$value + ", numberOfWorkersPerNode$value=" + this.numberOfWorkersPerNode$value + ", debugLongerIterations$value=" + this.debugLongerIterations$value + ", encodingDebugMode$value=" + this.encodingDebugMode$value + ", bufferSize$value=" + this.bufferSize$value + ", thresholdAlgorithm=" + this.thresholdAlgorithm + ", residualPostProcessor=" + this.residualPostProcessor + ", messageHandlerClass=" + this.messageHandlerClass + ")";
        }
    }
}

