/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.parameterserver.accumulation;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.core.storage.Persistable;
import org.deeplearning4j.core.storage.StorageMetaData;
import org.deeplearning4j.optimize.solvers.accumulation.encoding.ThresholdAlgorithmReducer;
import org.deeplearning4j.spark.api.stats.SparkTrainingStats;
import org.nd4j.linalg.api.ndarray.INDArray;

public class SharedTrainingAccumulationTuple
implements Serializable {
    private INDArray updaterStateArray;
    private double scoreSum;
    private int aggregationsCount;
    private SparkTrainingStats sparkTrainingStats;
    private Collection<StorageMetaData> listenerMetaData;
    private Collection<Persistable> listenerStaticInfo;
    private Collection<Persistable> listenerUpdates;
    private Map<String, Integer> minibatchesPerExecutor;
    private ThresholdAlgorithmReducer thresholdAlgorithmReducer;

    public static SharedTrainingAccumulationTupleBuilder builder() {
        return new SharedTrainingAccumulationTupleBuilder();
    }

    public SharedTrainingAccumulationTuple(INDArray updaterStateArray, double scoreSum, int aggregationsCount, SparkTrainingStats sparkTrainingStats, Collection<StorageMetaData> listenerMetaData, Collection<Persistable> listenerStaticInfo, Collection<Persistable> listenerUpdates, Map<String, Integer> minibatchesPerExecutor, ThresholdAlgorithmReducer thresholdAlgorithmReducer) {
        this.updaterStateArray = updaterStateArray;
        this.scoreSum = scoreSum;
        this.aggregationsCount = aggregationsCount;
        this.sparkTrainingStats = sparkTrainingStats;
        this.listenerMetaData = listenerMetaData;
        this.listenerStaticInfo = listenerStaticInfo;
        this.listenerUpdates = listenerUpdates;
        this.minibatchesPerExecutor = minibatchesPerExecutor;
        this.thresholdAlgorithmReducer = thresholdAlgorithmReducer;
    }

    public INDArray getUpdaterStateArray() {
        return this.updaterStateArray;
    }

    public double getScoreSum() {
        return this.scoreSum;
    }

    public int getAggregationsCount() {
        return this.aggregationsCount;
    }

    public SparkTrainingStats getSparkTrainingStats() {
        return this.sparkTrainingStats;
    }

    public Collection<StorageMetaData> getListenerMetaData() {
        return this.listenerMetaData;
    }

    public Collection<Persistable> getListenerStaticInfo() {
        return this.listenerStaticInfo;
    }

    public Collection<Persistable> getListenerUpdates() {
        return this.listenerUpdates;
    }

    public Map<String, Integer> getMinibatchesPerExecutor() {
        return this.minibatchesPerExecutor;
    }

    public ThresholdAlgorithmReducer getThresholdAlgorithmReducer() {
        return this.thresholdAlgorithmReducer;
    }

    public void setUpdaterStateArray(INDArray updaterStateArray) {
        this.updaterStateArray = updaterStateArray;
    }

    public void setScoreSum(double scoreSum) {
        this.scoreSum = scoreSum;
    }

    public void setAggregationsCount(int aggregationsCount) {
        this.aggregationsCount = aggregationsCount;
    }

    public void setSparkTrainingStats(SparkTrainingStats sparkTrainingStats) {
        this.sparkTrainingStats = sparkTrainingStats;
    }

    public void setListenerMetaData(Collection<StorageMetaData> listenerMetaData) {
        this.listenerMetaData = listenerMetaData;
    }

    public void setListenerStaticInfo(Collection<Persistable> listenerStaticInfo) {
        this.listenerStaticInfo = listenerStaticInfo;
    }

    public void setListenerUpdates(Collection<Persistable> listenerUpdates) {
        this.listenerUpdates = listenerUpdates;
    }

    public void setMinibatchesPerExecutor(Map<String, Integer> minibatchesPerExecutor) {
        this.minibatchesPerExecutor = minibatchesPerExecutor;
    }

    public void setThresholdAlgorithmReducer(ThresholdAlgorithmReducer thresholdAlgorithmReducer) {
        this.thresholdAlgorithmReducer = thresholdAlgorithmReducer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SharedTrainingAccumulationTuple)) {
            return false;
        }
        SharedTrainingAccumulationTuple other = (SharedTrainingAccumulationTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getScoreSum(), other.getScoreSum()) != 0) {
            return false;
        }
        if (this.getAggregationsCount() != other.getAggregationsCount()) {
            return false;
        }
        INDArray this$updaterStateArray = this.getUpdaterStateArray();
        INDArray other$updaterStateArray = other.getUpdaterStateArray();
        if (this$updaterStateArray == null ? other$updaterStateArray != null : !this$updaterStateArray.equals(other$updaterStateArray)) {
            return false;
        }
        SparkTrainingStats this$sparkTrainingStats = this.getSparkTrainingStats();
        SparkTrainingStats other$sparkTrainingStats = other.getSparkTrainingStats();
        if (this$sparkTrainingStats == null ? other$sparkTrainingStats != null : !this$sparkTrainingStats.equals(other$sparkTrainingStats)) {
            return false;
        }
        Collection<StorageMetaData> this$listenerMetaData = this.getListenerMetaData();
        Collection<StorageMetaData> other$listenerMetaData = other.getListenerMetaData();
        if (this$listenerMetaData == null ? other$listenerMetaData != null : !((Object)this$listenerMetaData).equals(other$listenerMetaData)) {
            return false;
        }
        Collection<Persistable> this$listenerStaticInfo = this.getListenerStaticInfo();
        Collection<Persistable> other$listenerStaticInfo = other.getListenerStaticInfo();
        if (this$listenerStaticInfo == null ? other$listenerStaticInfo != null : !((Object)this$listenerStaticInfo).equals(other$listenerStaticInfo)) {
            return false;
        }
        Collection<Persistable> this$listenerUpdates = this.getListenerUpdates();
        Collection<Persistable> other$listenerUpdates = other.getListenerUpdates();
        if (this$listenerUpdates == null ? other$listenerUpdates != null : !((Object)this$listenerUpdates).equals(other$listenerUpdates)) {
            return false;
        }
        Map<String, Integer> this$minibatchesPerExecutor = this.getMinibatchesPerExecutor();
        Map<String, Integer> other$minibatchesPerExecutor = other.getMinibatchesPerExecutor();
        if (this$minibatchesPerExecutor == null ? other$minibatchesPerExecutor != null : !((Object)this$minibatchesPerExecutor).equals(other$minibatchesPerExecutor)) {
            return false;
        }
        ThresholdAlgorithmReducer this$thresholdAlgorithmReducer = this.getThresholdAlgorithmReducer();
        ThresholdAlgorithmReducer other$thresholdAlgorithmReducer = other.getThresholdAlgorithmReducer();
        return !(this$thresholdAlgorithmReducer == null ? other$thresholdAlgorithmReducer != null : !this$thresholdAlgorithmReducer.equals(other$thresholdAlgorithmReducer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SharedTrainingAccumulationTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scoreSum = Double.doubleToLongBits(this.getScoreSum());
        result = result * 59 + (int)($scoreSum >>> 32 ^ $scoreSum);
        result = result * 59 + this.getAggregationsCount();
        INDArray $updaterStateArray = this.getUpdaterStateArray();
        result = result * 59 + ($updaterStateArray == null ? 43 : $updaterStateArray.hashCode());
        SparkTrainingStats $sparkTrainingStats = this.getSparkTrainingStats();
        result = result * 59 + ($sparkTrainingStats == null ? 43 : $sparkTrainingStats.hashCode());
        Collection<StorageMetaData> $listenerMetaData = this.getListenerMetaData();
        result = result * 59 + ($listenerMetaData == null ? 43 : ((Object)$listenerMetaData).hashCode());
        Collection<Persistable> $listenerStaticInfo = this.getListenerStaticInfo();
        result = result * 59 + ($listenerStaticInfo == null ? 43 : ((Object)$listenerStaticInfo).hashCode());
        Collection<Persistable> $listenerUpdates = this.getListenerUpdates();
        result = result * 59 + ($listenerUpdates == null ? 43 : ((Object)$listenerUpdates).hashCode());
        Map<String, Integer> $minibatchesPerExecutor = this.getMinibatchesPerExecutor();
        result = result * 59 + ($minibatchesPerExecutor == null ? 43 : ((Object)$minibatchesPerExecutor).hashCode());
        ThresholdAlgorithmReducer $thresholdAlgorithmReducer = this.getThresholdAlgorithmReducer();
        result = result * 59 + ($thresholdAlgorithmReducer == null ? 43 : $thresholdAlgorithmReducer.hashCode());
        return result;
    }

    public String toString() {
        return "SharedTrainingAccumulationTuple(updaterStateArray=" + this.getUpdaterStateArray() + ", scoreSum=" + this.getScoreSum() + ", aggregationsCount=" + this.getAggregationsCount() + ", sparkTrainingStats=" + this.getSparkTrainingStats() + ", listenerMetaData=" + this.getListenerMetaData() + ", listenerStaticInfo=" + this.getListenerStaticInfo() + ", listenerUpdates=" + this.getListenerUpdates() + ", minibatchesPerExecutor=" + this.getMinibatchesPerExecutor() + ", thresholdAlgorithmReducer=" + this.getThresholdAlgorithmReducer() + ")";
    }

    public SharedTrainingAccumulationTuple() {
    }

    public static class SharedTrainingAccumulationTupleBuilder {
        private INDArray updaterStateArray;
        private double scoreSum;
        private int aggregationsCount;
        private SparkTrainingStats sparkTrainingStats;
        private Collection<StorageMetaData> listenerMetaData;
        private Collection<Persistable> listenerStaticInfo;
        private Collection<Persistable> listenerUpdates;
        private Map<String, Integer> minibatchesPerExecutor;
        private ThresholdAlgorithmReducer thresholdAlgorithmReducer;

        SharedTrainingAccumulationTupleBuilder() {
        }

        public SharedTrainingAccumulationTupleBuilder updaterStateArray(INDArray updaterStateArray) {
            this.updaterStateArray = updaterStateArray;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder scoreSum(double scoreSum) {
            this.scoreSum = scoreSum;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder aggregationsCount(int aggregationsCount) {
            this.aggregationsCount = aggregationsCount;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder sparkTrainingStats(SparkTrainingStats sparkTrainingStats) {
            this.sparkTrainingStats = sparkTrainingStats;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder listenerMetaData(Collection<StorageMetaData> listenerMetaData) {
            this.listenerMetaData = listenerMetaData;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder listenerStaticInfo(Collection<Persistable> listenerStaticInfo) {
            this.listenerStaticInfo = listenerStaticInfo;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder listenerUpdates(Collection<Persistable> listenerUpdates) {
            this.listenerUpdates = listenerUpdates;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder minibatchesPerExecutor(Map<String, Integer> minibatchesPerExecutor) {
            this.minibatchesPerExecutor = minibatchesPerExecutor;
            return this;
        }

        public SharedTrainingAccumulationTupleBuilder thresholdAlgorithmReducer(ThresholdAlgorithmReducer thresholdAlgorithmReducer) {
            this.thresholdAlgorithmReducer = thresholdAlgorithmReducer;
            return this;
        }

        public SharedTrainingAccumulationTuple build() {
            return new SharedTrainingAccumulationTuple(this.updaterStateArray, this.scoreSum, this.aggregationsCount, this.sparkTrainingStats, this.listenerMetaData, this.listenerStaticInfo, this.listenerUpdates, this.minibatchesPerExecutor, this.thresholdAlgorithmReducer);
        }

        public String toString() {
            return "SharedTrainingAccumulationTuple.SharedTrainingAccumulationTupleBuilder(updaterStateArray=" + this.updaterStateArray + ", scoreSum=" + this.scoreSum + ", aggregationsCount=" + this.aggregationsCount + ", sparkTrainingStats=" + this.sparkTrainingStats + ", listenerMetaData=" + this.listenerMetaData + ", listenerStaticInfo=" + this.listenerStaticInfo + ", listenerUpdates=" + this.listenerUpdates + ", minibatchesPerExecutor=" + this.minibatchesPerExecutor + ", thresholdAlgorithmReducer=" + this.thresholdAlgorithmReducer + ")";
        }
    }
}

