/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class AlexNet
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private AlexNet() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return MultiLayerNetwork.class;
    }

    public MultiLayerConfiguration conf() {
        double nonZeroBias = 1.0;
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.seed).weightInit((Distribution)new NormalDistribution(0.0, 0.01)).activation(Activation.RELU).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).biasUpdater((IUpdater)new Nesterovs(0.02, 0.9)).convolutionMode(ConvolutionMode.Same).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cacheMode(this.cacheMode).l2(5.0E-4).miniBatch(false).list().layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{11, 11}, new int[]{4, 4}).name("cnn1")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).convolutionMode(ConvolutionMode.Truncate)).nIn(this.inputShape[0])).nOut(96)).build()).layer(1, (Layer)new LocalResponseNormalization.Builder().build()).layer(2, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX).kernelSize(new int[]{3, 3}).stride(new int[]{2, 2}).padding(new int[]{1, 1}).name("maxpool1")).build()).layer(3, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}, new int[]{1, 1}, new int[]{2, 2}).name("cnn2")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).convolutionMode(ConvolutionMode.Truncate)).nOut(256)).biasInit(nonZeroBias)).build()).layer(4, (Layer)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).convolutionMode(ConvolutionMode.Truncate)).name("maxpool2")).build()).layer(5, (Layer)new LocalResponseNormalization.Builder().build()).layer(6, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).name("cnn3")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(384)).build()).layer(7, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}).name("cnn4")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(384)).biasInit(nonZeroBias)).build()).layer(8, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}).name("cnn5")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(256)).biasInit(nonZeroBias)).build()).layer(9, (Layer)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).name("maxpool3")).convolutionMode(ConvolutionMode.Truncate)).build()).layer(10, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name("ffn1")).nIn(9216)).nOut(4096)).weightInit((Distribution)new NormalDistribution(0.0, 0.005))).biasInit(nonZeroBias)).build()).layer(11, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name("ffn2")).nOut(4096)).weightInit((Distribution)new NormalDistribution(0.0, 0.005))).biasInit(nonZeroBias)).dropOut(0.5)).build()).layer(12, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).name("output")).nOut(this.numClasses)).activation(Activation.SOFTMAX)).weightInit((Distribution)new NormalDistribution(0.0, 0.005))).biasInit(0.1)).build()).setInputType(InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])).build();
        return conf;
    }

    public MultiLayerNetwork init() {
        MultiLayerConfiguration conf = this.conf();
        MultiLayerNetwork network = new MultiLayerNetwork(conf);
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Nesterovs(0.01, 0.9);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static AlexNetBuilder builder() {
        return new AlexNetBuilder();
    }

    public AlexNet(long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class AlexNetBuilder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        AlexNetBuilder() {
        }

        public AlexNetBuilder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public AlexNetBuilder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public AlexNetBuilder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public AlexNetBuilder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public AlexNetBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public AlexNetBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public AlexNetBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public AlexNet build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = AlexNet.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = AlexNet.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = AlexNet.$default$numClasses();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = AlexNet.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = AlexNet.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = AlexNet.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = AlexNet.$default$cudnnAlgoMode();
            }
            return new AlexNet(seed$value, inputShape$value, numClasses$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "AlexNet.AlexNetBuilder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

