/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;

public class TinyYOLO
extends ZooModel {
    private int nBoxes;
    private double[][] priorBoxes;
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private TinyYOLO() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return "http://blob.deeplearning4j.org/models/tiny-yolo-voc_dl4j_inference.v2.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 1256226465L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        INDArray priors = Nd4j.create((double[][])this.priorBoxes);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).gradientNormalizationThreshold(1.0).updater(this.updater).l2(1.0E-5).activation(Activation.IDENTITY).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 16, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 16, 32, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 32, 64, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 4, 3, 64, 128, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 128, 256, 2, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 256, 512, 2, 1);
        DarknetHelper.addLayers(graphBuilder, 7, 3, 512, 1024, 0, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 1024, 1024, 0, 0);
        int layerNumber = 9;
        graphBuilder.addLayer("convolution2d_" + layerNumber, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(this.nBoxes * (5 + this.numClasses))).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).build(), new String[]{"activation_" + (layerNumber - 1)}).addLayer("outputs", (Layer)new Yolo2OutputLayer.Builder().boundingBoxPriors(priors).build(), new String[]{"convolution2d_" + layerNumber}).setOutputs(new String[]{"outputs"}).backprop(true).pretrain(false);
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static int $default$nBoxes() {
        return 5;
    }

    private static double[][] $default$priorBoxes() {
        return new double[][]{{1.08, 1.19}, {3.42, 4.41}, {6.63, 11.38}, {9.42, 5.11}, {16.62, 10.52}};
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 416, 416};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Adam(0.001);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static TinyYOLOBuilder builder() {
        return new TinyYOLOBuilder();
    }

    public TinyYOLO(int nBoxes, double[][] priorBoxes, long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.nBoxes = nBoxes;
        this.priorBoxes = priorBoxes;
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public int getNBoxes() {
        return this.nBoxes;
    }

    public double[][] getPriorBoxes() {
        return this.priorBoxes;
    }

    public static class TinyYOLOBuilder {
        private boolean nBoxes$set;
        private int nBoxes;
        private boolean priorBoxes$set;
        private double[][] priorBoxes;
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        TinyYOLOBuilder() {
        }

        public TinyYOLOBuilder nBoxes(int nBoxes) {
            this.nBoxes = nBoxes;
            this.nBoxes$set = true;
            return this;
        }

        public TinyYOLOBuilder priorBoxes(double[][] priorBoxes) {
            this.priorBoxes = priorBoxes;
            this.priorBoxes$set = true;
            return this;
        }

        public TinyYOLOBuilder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public TinyYOLOBuilder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public TinyYOLOBuilder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public TinyYOLOBuilder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public TinyYOLOBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public TinyYOLOBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public TinyYOLOBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public TinyYOLO build() {
            int nBoxes = this.nBoxes;
            if (!this.nBoxes$set) {
                nBoxes = TinyYOLO.$default$nBoxes();
            }
            double[][] priorBoxes = this.priorBoxes;
            if (!this.priorBoxes$set) {
                priorBoxes = TinyYOLO.$default$priorBoxes();
            }
            long seed = this.seed;
            if (!this.seed$set) {
                seed = TinyYOLO.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = TinyYOLO.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = TinyYOLO.$default$numClasses();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = TinyYOLO.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = TinyYOLO.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = TinyYOLO.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = TinyYOLO.$default$cudnnAlgoMode();
            }
            return new TinyYOLO(nBoxes, priorBoxes, seed, inputShape, numClasses, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "TinyYOLO.TinyYOLOBuilder(nBoxes=" + this.nBoxes + ", priorBoxes=" + Arrays.deepToString((Object[])this.priorBoxes) + ", seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

