/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.TruncatedNormalDistribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.NASNetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;
import org.nd4j.linalg.primitives.Pair;

public class NASNet
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private Distribution weightDistribution;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;
    private int numBlocks;
    private int penultimateFilters;
    private int stemFilters;
    private int filterMultiplier;
    private boolean skipReduction;

    private NASNet() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return "http://blob.deeplearning4j.org/models/nasnetmobile_dl4j_inference.v1.zip";
        }
        if (pretrainedType == PretrainedType.IMAGENETLARGE) {
            return "http://blob.deeplearning4j.org/models/nasnetlarge_dl4j_inference.v1.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3082463801L;
        }
        if (pretrainedType == PretrainedType.IMAGENETLARGE) {
            return 321395591L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        Pair<String, String> block;
        int i;
        if (this.penultimateFilters % 24 != 0) {
            throw new IllegalArgumentException("For NASNet-A models penultimate filters must be divisible by 24. Current value is " + this.penultimateFilters);
        }
        int filters = (int)Math.floor(this.penultimateFilters / 24);
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).dist(this.weightDistribution).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        if (!this.skipReduction) {
            graph.addLayer("stem_conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{2, 2}).nOut(this.stemFilters)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"});
        } else {
            graph.addLayer("stem_conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(this.stemFilters)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"});
        }
        graph.addLayer("stem_bn1", (Layer)new BatchNormalization.Builder().eps(0.001).gamma(0.9997).build(), new String[]{"stem_conv1"});
        String inputX = "stem_bn1";
        String inputP = null;
        if (!this.skipReduction) {
            Pair<String, String> stem1 = NASNetHelper.reductionA(graph, (int)Math.floor((double)this.stemFilters / Math.pow(this.filterMultiplier, 2.0)), "stem1", "stem_conv1", inputP);
            Pair<String, String> stem2 = NASNetHelper.reductionA(graph, (int)Math.floor(this.stemFilters / this.filterMultiplier), "stem2", (String)stem1.getFirst(), (String)stem1.getSecond());
            inputX = (String)stem2.getFirst();
            inputP = (String)stem2.getSecond();
        }
        for (int i2 = 0; i2 < this.numBlocks; ++i2) {
            Pair<String, String> block2 = NASNetHelper.normalA(graph, filters, String.valueOf(i2), inputX, inputP);
            inputX = (String)block2.getFirst();
            inputP = (String)block2.getSecond();
        }
        Pair<String, String> reduce = NASNetHelper.reductionA(graph, filters * this.filterMultiplier, "reduce" + this.numBlocks, inputX, inputP);
        inputX = (String)reduce.getFirst();
        String inputP0 = (String)reduce.getSecond();
        if (!this.skipReduction) {
            inputP = inputP0;
        }
        for (i = 0; i < this.numBlocks; ++i) {
            block = NASNetHelper.normalA(graph, filters * this.filterMultiplier, String.valueOf(i + this.numBlocks + 1), inputX, inputP);
            inputX = (String)block.getFirst();
            inputP = (String)block.getSecond();
        }
        reduce = NASNetHelper.reductionA(graph, filters * (int)Math.pow(this.filterMultiplier, 2.0), "reduce" + 2 * this.numBlocks, inputX, inputP);
        inputX = (String)reduce.getFirst();
        inputP0 = (String)reduce.getSecond();
        if (!this.skipReduction) {
            inputP = inputP0;
        }
        for (i = 0; i < this.numBlocks; ++i) {
            block = NASNetHelper.normalA(graph, filters * (int)Math.pow(this.filterMultiplier, 2.0), String.valueOf(i + 2 * this.numBlocks + 1), inputX, inputP);
            inputX = (String)block.getFirst();
            inputP = (String)block.getSecond();
        }
        graph.addLayer("act", (Layer)new ActivationLayer(Activation.RELU), new String[]{inputX}).addLayer("avg_pool", (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build(), new String[]{"act"}).addLayer("output", (Layer)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.MCXENT).activation(Activation.SOFTMAX)).build(), new String[]{"avg_pool"}).setOutputs(new String[]{"output"}).backprop(true).pretrain(false);
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static Distribution $default$weightDistribution() {
        return new TruncatedNormalDistribution(0.0, 0.5);
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.DEVICE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    private static int $default$numBlocks() {
        return 6;
    }

    private static int $default$penultimateFilters() {
        return 1056;
    }

    private static int $default$stemFilters() {
        return 96;
    }

    private static int $default$filterMultiplier() {
        return 2;
    }

    private static boolean $default$skipReduction() {
        return true;
    }

    public static NASNetBuilder builder() {
        return new NASNetBuilder();
    }

    public NASNet(long seed, int[] inputShape, int numClasses, WeightInit weightInit, Distribution weightDistribution, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode, int numBlocks, int penultimateFilters, int stemFilters, int filterMultiplier, boolean skipReduction) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.weightDistribution = weightDistribution;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
        this.numBlocks = numBlocks;
        this.penultimateFilters = penultimateFilters;
        this.stemFilters = stemFilters;
        this.filterMultiplier = filterMultiplier;
        this.skipReduction = skipReduction;
    }

    public static class NASNetBuilder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean weightInit$set;
        private WeightInit weightInit;
        private boolean weightDistribution$set;
        private Distribution weightDistribution;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;
        private boolean numBlocks$set;
        private int numBlocks;
        private boolean penultimateFilters$set;
        private int penultimateFilters;
        private boolean stemFilters$set;
        private int stemFilters;
        private boolean filterMultiplier$set;
        private int filterMultiplier;
        private boolean skipReduction$set;
        private boolean skipReduction;

        NASNetBuilder() {
        }

        public NASNetBuilder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public NASNetBuilder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public NASNetBuilder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public NASNetBuilder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public NASNetBuilder weightDistribution(Distribution weightDistribution) {
            this.weightDistribution = weightDistribution;
            this.weightDistribution$set = true;
            return this;
        }

        public NASNetBuilder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public NASNetBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public NASNetBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public NASNetBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public NASNetBuilder numBlocks(int numBlocks) {
            this.numBlocks = numBlocks;
            this.numBlocks$set = true;
            return this;
        }

        public NASNetBuilder penultimateFilters(int penultimateFilters) {
            this.penultimateFilters = penultimateFilters;
            this.penultimateFilters$set = true;
            return this;
        }

        public NASNetBuilder stemFilters(int stemFilters) {
            this.stemFilters = stemFilters;
            this.stemFilters$set = true;
            return this;
        }

        public NASNetBuilder filterMultiplier(int filterMultiplier) {
            this.filterMultiplier = filterMultiplier;
            this.filterMultiplier$set = true;
            return this;
        }

        public NASNetBuilder skipReduction(boolean skipReduction) {
            this.skipReduction = skipReduction;
            this.skipReduction$set = true;
            return this;
        }

        public NASNet build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = NASNet.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = NASNet.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = NASNet.$default$numClasses();
            }
            WeightInit weightInit = this.weightInit;
            if (!this.weightInit$set) {
                weightInit = NASNet.$default$weightInit();
            }
            Distribution weightDistribution = this.weightDistribution;
            if (!this.weightDistribution$set) {
                weightDistribution = NASNet.$default$weightDistribution();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = NASNet.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = NASNet.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = NASNet.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = NASNet.$default$cudnnAlgoMode();
            }
            int numBlocks = this.numBlocks;
            if (!this.numBlocks$set) {
                numBlocks = NASNet.$default$numBlocks();
            }
            int penultimateFilters = this.penultimateFilters;
            if (!this.penultimateFilters$set) {
                penultimateFilters = NASNet.$default$penultimateFilters();
            }
            int stemFilters = this.stemFilters;
            if (!this.stemFilters$set) {
                stemFilters = NASNet.$default$stemFilters();
            }
            int filterMultiplier = this.filterMultiplier;
            if (!this.filterMultiplier$set) {
                filterMultiplier = NASNet.$default$filterMultiplier();
            }
            boolean skipReduction = this.skipReduction;
            if (!this.skipReduction$set) {
                skipReduction = NASNet.$default$skipReduction();
            }
            return new NASNet(seed, inputShape, numClasses, weightInit, weightDistribution, updater, cacheMode, workspaceMode, cudnnAlgoMode, numBlocks, penultimateFilters, stemFilters, filterMultiplier, skipReduction);
        }

        public String toString() {
            return "NASNet.NASNetBuilder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", weightInit=" + this.weightInit + ", weightDistribution=" + this.weightDistribution + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ", numBlocks=" + this.numBlocks + ", penultimateFilters=" + this.penultimateFilters + ", stemFilters=" + this.stemFilters + ", filterMultiplier=" + this.filterMultiplier + ", skipReduction=" + this.skipReduction + ")";
        }
    }
}

