/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.L2NormalizeVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.CenterLossOutputLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.FaceNetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class FaceNetNN4Small2
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private Activation transferFunction;
    CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private FaceNetNN4Small2() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        int embeddingSize = 128;
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).activation(Activation.IDENTITY).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(WeightInit.RELU).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).convolutionMode(ConvolutionMode.Same).graphBuilder();
        graph.addInputs(new String[]{"input1"}).addLayer("stem-cnn1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}, new int[]{2, 2}, new int[]{3, 3}).nIn(this.inputShape[0])).nOut(64)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"input1"}).addLayer("stem-batch1", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).nIn(64)).nOut(64)).build(), new String[]{"stem-cnn1"}).addLayer("stem-activation1", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"stem-batch1"}).addLayer("stem-pool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}, new int[]{1, 1}).build(), new String[]{"stem-activation1"}).addLayer("stem-lrn1", (Layer)new LocalResponseNormalization.Builder(1.0, 5.0, 1.0E-4, 0.75).build(), new String[]{"stem-pool1"}).addLayer("inception-2-cnn1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(64)).nOut(64)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"stem-lrn1"}).addLayer("inception-2-batch1", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).nIn(64)).nOut(64)).build(), new String[]{"inception-2-cnn1"}).addLayer("inception-2-activation1", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"inception-2-batch1"}).addLayer("inception-2-cnn2", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}, new int[]{1, 1}).nIn(64)).nOut(192)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-2-activation1"}).addLayer("inception-2-batch2", (Layer)((BatchNormalization.Builder)((BatchNormalization.Builder)new BatchNormalization.Builder(false).nIn(192)).nOut(192)).build(), new String[]{"inception-2-cnn2"}).addLayer("inception-2-activation2", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"inception-2-batch2"}).addLayer("inception-2-lrn1", (Layer)new LocalResponseNormalization.Builder(1.0, 5.0, 1.0E-4, 0.75).build(), new String[]{"inception-2-activation2"}).addLayer("inception-2-pool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}, new int[]{1, 1}).build(), new String[]{"inception-2-lrn1"});
        FaceNetHelper.appendGraph(graph, "3a", 192, new int[]{3, 5}, new int[]{1, 1}, new int[]{128, 32}, new int[]{96, 16, 32, 64}, SubsamplingLayer.PoolingType.MAX, this.transferFunction, "inception-2-pool1");
        FaceNetHelper.appendGraph(graph, "3b", 256, new int[]{3, 5}, new int[]{1, 1}, new int[]{128, 64}, new int[]{96, 32, 64, 64}, SubsamplingLayer.PoolingType.PNORM, 2, this.transferFunction, "inception-3a");
        graph.addLayer("3c-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(320)).nOut(128)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-3b"}).addLayer("3c-1x1-norm", (Layer)FaceNetHelper.batchNorm(128, 128), new String[]{"3c-1x1"}).addLayer("3c-transfer1", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"3c-1x1-norm"}).addLayer("3c-3x3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(128)).nOut(256)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"3c-transfer1"}).addLayer("3c-3x3-norm", (Layer)FaceNetHelper.batchNorm(256, 256), new String[]{"3c-3x3"}).addLayer("3c-transfer2", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"3c-3x3-norm"}).addLayer("3c-2-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(320)).nOut(32)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-3b"}).addLayer("3c-2-1x1-norm", (Layer)FaceNetHelper.batchNorm(32, 32), new String[]{"3c-2-1x1"}).addLayer("3c-2-transfer3", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"3c-2-1x1-norm"}).addLayer("3c-2-5x5", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(32)).nOut(64)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"3c-2-transfer3"}).addLayer("3c-2-5x5-norm", (Layer)FaceNetHelper.batchNorm(64, 64), new String[]{"3c-2-5x5"}).addLayer("3c-2-transfer4", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"3c-2-5x5-norm"}).addLayer("3c-pool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}, new int[]{1, 1}).build(), new String[]{"inception-3b"}).addVertex("inception-3c", (GraphVertex)new MergeVertex(), new String[]{"3c-transfer2", "3c-2-transfer4", "3c-pool"});
        FaceNetHelper.appendGraph(graph, "4a", 640, new int[]{3, 5}, new int[]{1, 1}, new int[]{192, 64}, new int[]{96, 32, 128, 256}, SubsamplingLayer.PoolingType.PNORM, 2, this.transferFunction, "inception-3c");
        graph.addLayer("4e-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(640)).nOut(160)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-4a"}).addLayer("4e-1x1-norm", (Layer)FaceNetHelper.batchNorm(160, 160), new String[]{"4e-1x1"}).addLayer("4e-transfer1", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"4e-1x1-norm"}).addLayer("4e-3x3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(160)).nOut(256)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"4e-transfer1"}).addLayer("4e-3x3-norm", (Layer)FaceNetHelper.batchNorm(256, 256), new String[]{"4e-3x3"}).addLayer("4e-transfer2", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"4e-3x3-norm"}).addLayer("4e-2-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(640)).nOut(64)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-4a"}).addLayer("4e-2-1x1-norm", (Layer)FaceNetHelper.batchNorm(64, 64), new String[]{"4e-2-1x1"}).addLayer("4e-2-transfer3", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"4e-2-1x1-norm"}).addLayer("4e-2-5x5", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{2, 2}).nIn(64)).nOut(128)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"4e-2-transfer3"}).addLayer("4e-2-5x5-norm", (Layer)FaceNetHelper.batchNorm(128, 128), new String[]{"4e-2-5x5"}).addLayer("4e-2-transfer4", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"4e-2-5x5-norm"}).addLayer("4e-pool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}, new int[]{1, 1}).build(), new String[]{"inception-4a"}).addVertex("inception-4e", (GraphVertex)new MergeVertex(), new String[]{"4e-transfer2", "4e-2-transfer4", "4e-pool"});
        graph.addLayer("5a-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(1024)).nOut(256)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-4e"}).addLayer("5a-1x1-norm", (Layer)FaceNetHelper.batchNorm(256, 256), new String[]{"5a-1x1"}).addLayer("5a-transfer1", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5a-1x1-norm"}).addLayer("5a-2-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(1024)).nOut(96)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-4e"}).addLayer("5a-2-1x1-norm", (Layer)FaceNetHelper.batchNorm(96, 96), new String[]{"5a-2-1x1"}).addLayer("5a-2-transfer2", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5a-2-1x1-norm"}).addLayer("5a-2-3x3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}).nIn(96)).nOut(384)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"5a-2-transfer2"}).addLayer("5a-2-3x3-norm", (Layer)FaceNetHelper.batchNorm(384, 384), new String[]{"5a-2-3x3"}).addLayer("5a-transfer3", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5a-2-3x3-norm"}).addLayer("5a-3-pool", (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.PNORM, new int[]{3, 3}, new int[]{1, 1}).pnorm(2)).build(), new String[]{"inception-4e"}).addLayer("5a-3-1x1reduce", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(1024)).nOut(96)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"5a-3-pool"}).addLayer("5a-3-1x1reduce-norm", (Layer)FaceNetHelper.batchNorm(96, 96), new String[]{"5a-3-1x1reduce"}).addLayer("5a-3-transfer4", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"5a-3-1x1reduce-norm"}).addVertex("inception-5a", (GraphVertex)new MergeVertex(), new String[]{"5a-transfer1", "5a-transfer3", "5a-3-transfer4"});
        graph.addLayer("5b-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(736)).nOut(256)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-5a"}).addLayer("5b-1x1-norm", (Layer)FaceNetHelper.batchNorm(256, 256), new String[]{"5b-1x1"}).addLayer("5b-transfer1", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5b-1x1-norm"}).addLayer("5b-2-1x1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(736)).nOut(96)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"inception-5a"}).addLayer("5b-2-1x1-norm", (Layer)FaceNetHelper.batchNorm(96, 96), new String[]{"5b-2-1x1"}).addLayer("5b-2-transfer2", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5b-2-1x1-norm"}).addLayer("5b-2-3x3", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}).nIn(96)).nOut(384)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"5b-2-transfer2"}).addLayer("5b-2-3x3-norm", (Layer)FaceNetHelper.batchNorm(384, 384), new String[]{"5b-2-3x3"}).addLayer("5b-2-transfer3", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5b-2-3x3-norm"}).addLayer("5b-3-pool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{1, 1}, new int[]{1, 1}).build(), new String[]{"inception-5a"}).addLayer("5b-3-1x1reduce", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, new int[]{1, 1}).nIn(736)).nOut(96)).cudnnAlgoMode(ConvolutionLayer.AlgoMode.NO_WORKSPACE)).build(), new String[]{"5b-3-pool"}).addLayer("5b-3-1x1reduce-norm", (Layer)FaceNetHelper.batchNorm(96, 96), new String[]{"5b-3-1x1reduce"}).addLayer("5b-3-transfer4", (Layer)new ActivationLayer.Builder().activation(this.transferFunction).build(), new String[]{"5b-3-1x1reduce-norm"}).addVertex("inception-5b", (GraphVertex)new MergeVertex(), new String[]{"5b-transfer1", "5b-2-transfer3", "5b-3-transfer4"});
        graph.addLayer("avgpool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{3, 3}, new int[]{3, 3}).build(), new String[]{"inception-5b"}).addLayer("bottleneck", (Layer)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().nIn(2944)).nOut(embeddingSize)).activation(Activation.IDENTITY)).build(), new String[]{"avgpool"}).addVertex("embeddings", (GraphVertex)new L2NormalizeVertex(new int[0], 1.0E-6), new String[]{"bottleneck"}).addLayer("lossLayer", (Layer)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)((CenterLossOutputLayer.Builder)new CenterLossOutputLayer.Builder().lossFunction(LossFunctions.LossFunction.SQUARED_LOSS)).activation(Activation.SOFTMAX)).nIn(128)).nOut(this.numClasses)).lambda(1.0E-4).alpha(0.9).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer)).build(), new String[]{"embeddings"}).setOutputs(new String[]{"lossLayer"}).backprop(true).pretrain(false).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        return graph.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 96, 96};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Adam(0.1, 0.9, 0.999, 0.01);
    }

    private static Activation $default$transferFunction() {
        return Activation.RELU;
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static FaceNetNN4Small2Builder builder() {
        return new FaceNetNN4Small2Builder();
    }

    public FaceNetNN4Small2(long seed, int[] inputShape, int numClasses, IUpdater updater, Activation transferFunction, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.transferFunction = transferFunction;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class FaceNetNN4Small2Builder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean updater$set;
        private IUpdater updater;
        private boolean transferFunction$set;
        private Activation transferFunction;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        FaceNetNN4Small2Builder() {
        }

        public FaceNetNN4Small2Builder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder transferFunction(Activation transferFunction) {
            this.transferFunction = transferFunction;
            this.transferFunction$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public FaceNetNN4Small2Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public FaceNetNN4Small2 build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = FaceNetNN4Small2.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = FaceNetNN4Small2.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = FaceNetNN4Small2.$default$numClasses();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = FaceNetNN4Small2.$default$updater();
            }
            Activation transferFunction = this.transferFunction;
            if (!this.transferFunction$set) {
                transferFunction = FaceNetNN4Small2.$default$transferFunction();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = FaceNetNN4Small2.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = FaceNetNN4Small2.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = FaceNetNN4Small2.$default$cudnnAlgoMode();
            }
            return new FaceNetNN4Small2(seed, inputShape, numClasses, updater, transferFunction, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "FaceNetNN4Small2.FaceNetNN4Small2Builder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", updater=" + this.updater + ", transferFunction=" + this.transferFunction + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

