/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class Darknet19
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private Darknet19() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            if (this.inputShape[1] == 448 && this.inputShape[2] == 448) {
                return "http://blob.deeplearning4j.org/models/darknet19_448_dl4j_inference.v2.zip";
            }
            return "http://blob.deeplearning4j.org/models/darknet19_dl4j_inference.v2.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            if (this.inputShape[1] == 448 && this.inputShape[2] == 448) {
                return 1054319943L;
            }
            return 691100891L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).updater(this.updater).weightInit(this.weightInit).l2(1.0E-5).activation(Activation.IDENTITY).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 32, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 32, 64, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 64, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 4, 1, 128, 64, 0);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 64, 128, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 128, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 7, 1, 256, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 128, 256, 2);
        DarknetHelper.addLayers(graphBuilder, 9, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 10, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 11, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 12, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 13, 3, 256, 512, 2);
        DarknetHelper.addLayers(graphBuilder, 14, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 15, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 16, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 17, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 18, 3, 512, 1024, 0);
        int layerNumber = 19;
        graphBuilder.addLayer("convolution2d_" + layerNumber, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(this.numClasses)).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).build(), new String[]{"activation_" + (layerNumber - 1)}).addLayer("globalpooling", (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build(), new String[]{"convolution2d_" + layerNumber}).addLayer("softmax", (Layer)new ActivationLayer.Builder().activation(Activation.SOFTMAX).build(), new String[]{"globalpooling"}).addLayer("loss", (Layer)new LossLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).build(), new String[]{"softmax"}).setOutputs(new String[]{"loss"}).backprop(true).pretrain(false);
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static IUpdater $default$updater() {
        return new Nesterovs(0.001, 0.9);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static Darknet19Builder builder() {
        return new Darknet19Builder();
    }

    public Darknet19(long seed, int[] inputShape, int numClasses, WeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class Darknet19Builder {
        private boolean seed$set;
        private long seed;
        private boolean inputShape$set;
        private int[] inputShape;
        private boolean numClasses$set;
        private int numClasses;
        private boolean weightInit$set;
        private WeightInit weightInit;
        private boolean updater$set;
        private IUpdater updater;
        private boolean cacheMode$set;
        private CacheMode cacheMode;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode;

        Darknet19Builder() {
        }

        public Darknet19Builder seed(long seed) {
            this.seed = seed;
            this.seed$set = true;
            return this;
        }

        public Darknet19Builder inputShape(int[] inputShape) {
            this.inputShape = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public Darknet19Builder numClasses(int numClasses) {
            this.numClasses = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public Darknet19Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public Darknet19Builder updater(IUpdater updater) {
            this.updater = updater;
            this.updater$set = true;
            return this;
        }

        public Darknet19Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public Darknet19Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public Darknet19Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public Darknet19 build() {
            long seed = this.seed;
            if (!this.seed$set) {
                seed = Darknet19.$default$seed();
            }
            int[] inputShape = this.inputShape;
            if (!this.inputShape$set) {
                inputShape = Darknet19.$default$inputShape();
            }
            int numClasses = this.numClasses;
            if (!this.numClasses$set) {
                numClasses = Darknet19.$default$numClasses();
            }
            WeightInit weightInit = this.weightInit;
            if (!this.weightInit$set) {
                weightInit = Darknet19.$default$weightInit();
            }
            IUpdater updater = this.updater;
            if (!this.updater$set) {
                updater = Darknet19.$default$updater();
            }
            CacheMode cacheMode = this.cacheMode;
            if (!this.cacheMode$set) {
                cacheMode = Darknet19.$default$cacheMode();
            }
            WorkspaceMode workspaceMode = this.workspaceMode;
            if (!this.workspaceMode$set) {
                workspaceMode = Darknet19.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode = this.cudnnAlgoMode;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode = Darknet19.$default$cudnnAlgoMode();
            }
            return new Darknet19(seed, inputShape, numClasses, weightInit, updater, cacheMode, workspaceMode, cudnnAlgoMode);
        }

        public String toString() {
            return "Darknet19.Darknet19Builder(seed=" + this.seed + ", inputShape=" + Arrays.toString(this.inputShape) + ", numClasses=" + this.numClasses + ", weightInit=" + this.weightInit + ", updater=" + this.updater + ", cacheMode=" + this.cacheMode + ", workspaceMode=" + this.workspaceMode + ", cudnnAlgoMode=" + this.cudnnAlgoMode + ")";
        }
    }
}

