/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;
import org.deeplearning4j.zoo.InstantiableModel;
import org.deeplearning4j.zoo.PretrainedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZooModel<T>
implements InstantiableModel {
    private static final Logger log = LoggerFactory.getLogger(ZooModel.class);
    public static File ROOT_CACHE_DIR = new File(System.getProperty("user.home"), "/.deeplearning4j/");

    public boolean pretrainedAvailable(PretrainedType pretrainedType) {
        return this.pretrainedUrl(pretrainedType) != null;
    }

    public Model initPretrained() throws IOException {
        return this.initPretrained(PretrainedType.IMAGENET);
    }

    public <M extends Model> M initPretrained(PretrainedType pretrainedType) throws IOException {
        String remoteUrl = this.pretrainedUrl(pretrainedType);
        if (remoteUrl == null) {
            throw new UnsupportedOperationException("Pretrained " + (Object)((Object)pretrainedType) + " weights are not available for this model.");
        }
        String localFilename = new File(remoteUrl).getName();
        ROOT_CACHE_DIR.mkdirs();
        File cachedFile = new File(ROOT_CACHE_DIR.getAbsolutePath(), localFilename);
        if (!cachedFile.exists()) {
            log.info("Downloading model to " + cachedFile.toString());
            FileUtils.copyURLToFile((URL)new URL(remoteUrl), (File)cachedFile);
        } else {
            log.info("Using cached model at " + cachedFile.toString());
        }
        long expectedChecksum = this.pretrainedChecksum(pretrainedType);
        if (expectedChecksum != 0L) {
            log.info("Verifying download...");
            Adler32 adler = new Adler32();
            FileUtils.checksum((File)cachedFile, (Checksum)adler);
            long localChecksum = adler.getValue();
            log.info("Checksum local is " + localChecksum + ", expecting " + expectedChecksum);
            if (expectedChecksum != localChecksum) {
                log.error("Checksums do not match. Cleaning up files and failing...");
                cachedFile.delete();
                throw new IllegalStateException("Pretrained model file failed checksum. If this error persists, please open an issue at https://github.com/deeplearning4j/deeplearning4j.");
            }
        }
        if (this.modelType() == MultiLayerNetwork.class) {
            return (M)ModelSerializer.restoreMultiLayerNetwork((File)cachedFile);
        }
        if (this.modelType() == ComputationGraph.class) {
            return (M)ModelSerializer.restoreComputationGraph((File)cachedFile);
        }
        throw new UnsupportedOperationException("Pretrained models are only supported for MultiLayerNetwork and ComputationGraph.");
    }
}

