/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class VGG19
extends ZooModel {
    private int[] inputShape = new int[]{3, 224, 224};
    private int numLabels;
    private long seed;
    private int iterations;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public VGG19(int numLabels, long seed) {
        this(numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public VGG19(int numLabels, long seed, WorkspaceMode workspaceMode) {
        this.numLabels = numLabels;
        this.seed = seed;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return "http://blob.deeplearning4j.org/models/vgg19_dl4j_inference.zip";
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 2782932419L;
        }
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.VGG16;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public MultiLayerConfiguration conf() {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(Updater.NESTEROVS).activation(Activation.RELU).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).list().layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nIn(this.inputShape[0])).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(1, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(64)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(2, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build()).layer(3, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(4, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(128)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(5, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build()).layer(6, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(7, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(8, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(9, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(256)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(10, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build()).layer(11, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(12, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(13, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(14, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(15, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build()).layer(16, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(17, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(18, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(19, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder().kernelSize(new int[]{3, 3}).stride(new int[]{1, 1}).padding(new int[]{1, 1}).nOut(512)).cudnnAlgoMode(this.cudnnAlgoMode)).build()).layer(20, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder().poolingType(SubsamplingLayer.PoolingType.MAX)).kernelSize(new int[]{2, 2}).stride(new int[]{2, 2}).build()).layer(21, (Layer)((DenseLayer.Builder)new DenseLayer.Builder().nOut(4096)).build()).layer(22, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).name("output")).nOut(this.numLabels)).activation(Activation.SOFTMAX)).build()).backprop(true).pretrain(false).setInputType(InputType.convolutionalFlat((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])).build();
        return conf;
    }

    public MultiLayerNetwork init() {
        MultiLayerNetwork network = new MultiLayerNetwork(this.conf());
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public VGG19() {
    }
}

