/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.GaussianDistribution;
import org.deeplearning4j.nn.conf.distribution.NormalDistribution;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class AlexNet
extends ZooModel {
    private int[] inputShape = new int[]{3, 224, 224};
    private int numLabels = 1000;
    private long seed = 42L;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    public AlexNet(int numLabels, long seed) {
        this(numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public AlexNet(int numLabels, long seed, WorkspaceMode workspaceMode) {
        this.numLabels = numLabels;
        this.seed = seed;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = workspaceMode == WorkspaceMode.SINGLE ? ConvolutionLayer.AlgoMode.PREFER_FASTEST : ConvolutionLayer.AlgoMode.NO_WORKSPACE;
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public ZooType zooType() {
        return ZooType.ALEXNET;
    }

    @Override
    public Class<? extends Model> modelType() {
        return MultiLayerNetwork.class;
    }

    public MultiLayerConfiguration conf() {
        double nonZeroBias = 1.0;
        double dropOut = 0.5;
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.seed).weightInit(WeightInit.DISTRIBUTION).dist((Distribution)new NormalDistribution(0.0, 0.01)).activation(Activation.RELU).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater((IUpdater)new Nesterovs(0.01, 0.9)).biasUpdater((IUpdater)new Nesterovs(0.02, 0.9)).convolutionMode(ConvolutionMode.Same).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).trainingWorkspaceMode(WorkspaceMode.SINGLE).inferenceWorkspaceMode(WorkspaceMode.SINGLE).dropOut(0.5).l2(5.0E-4).miniBatch(false).list().layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{11, 11}, new int[]{4, 4}, new int[]{2, 2}).name("cnn1")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).convolutionMode(ConvolutionMode.Truncate)).nIn(this.inputShape[0])).nOut(64)).build()).layer(1, (Layer)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}, new int[]{1, 1}).convolutionMode(ConvolutionMode.Truncate)).name("maxpool1")).build()).layer(2, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}, new int[]{2, 2}, new int[]{2, 2}).convolutionMode(ConvolutionMode.Truncate)).name("cnn2")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(192)).biasInit(nonZeroBias)).build()).layer(3, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).name("maxpool2")).build()).layer(4, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}, new int[]{1, 1}).name("cnn3")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(384)).build()).layer(5, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}, new int[]{1, 1}).name("cnn4")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(256)).biasInit(nonZeroBias)).build()).layer(6, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}, new int[]{1, 1}, new int[]{1, 1}).name("cnn5")).cudnnAlgoMode(ConvolutionLayer.AlgoMode.PREFER_FASTEST)).nOut(256)).biasInit(nonZeroBias)).build()).layer(7, (Layer)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{7, 7}).name("maxpool3")).build()).layer(8, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name("ffn1")).nIn(256)).nOut(4096)).dist((Distribution)new GaussianDistribution(0.0, 0.005))).biasInit(nonZeroBias)).dropOut(dropOut)).build()).layer(9, (Layer)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)((DenseLayer.Builder)new DenseLayer.Builder().name("ffn2")).nOut(4096)).dist((Distribution)new GaussianDistribution(0.0, 0.005))).biasInit(nonZeroBias)).dropOut(dropOut)).build()).layer(10, (Layer)((OutputLayer.Builder)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).name("output")).nOut(this.numLabels)).activation(Activation.SOFTMAX)).build()).backprop(true).pretrain(false).setInputType(InputType.convolutionalFlat((int)this.inputShape[2], (int)this.inputShape[1], (int)this.inputShape[0])).build();
        return conf;
    }

    public MultiLayerNetwork init() {
        MultiLayerConfiguration conf = this.conf();
        MultiLayerNetwork network = new MultiLayerNetwork(conf);
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    public AlexNet() {
    }
}

