/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.AlexNet;
import org.deeplearning4j.zoo.model.Darknet19;
import org.deeplearning4j.zoo.model.FaceNetNN4Small2;
import org.deeplearning4j.zoo.model.GoogLeNet;
import org.deeplearning4j.zoo.model.InceptionResNetV1;
import org.deeplearning4j.zoo.model.LeNet;
import org.deeplearning4j.zoo.model.ResNet50;
import org.deeplearning4j.zoo.model.SimpleCNN;
import org.deeplearning4j.zoo.model.TextGenerationLSTM;
import org.deeplearning4j.zoo.model.TinyYOLO;
import org.deeplearning4j.zoo.model.VGG16;
import org.deeplearning4j.zoo.model.VGG19;
import org.deeplearning4j.zoo.model.YOLO2;

public class ModelSelector {
    public static Map<ZooType, ZooModel> select(ZooType zooType) {
        return ModelSelector.select(zooType, 1, 123, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels) {
        return ModelSelector.select(zooType, numLabels, 123, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, WorkspaceMode workspaceMode) {
        return ModelSelector.select(zooType, numLabels, 123, workspaceMode);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, int seed) {
        return ModelSelector.select(zooType, numLabels, seed, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, int seed, WorkspaceMode workspaceMode) {
        return ModelSelector.select(new HashMap<ZooType, ZooModel>(), zooType, numLabels, seed, workspaceMode);
    }

    public static Map<ZooType, ZooModel> select(WorkspaceMode workspaceMode, ZooType ... zooTypes) {
        return ModelSelector.select(0, 123, workspaceMode, zooTypes);
    }

    public static Map<ZooType, ZooModel> select(ZooType ... zooTypes) {
        return ModelSelector.select(0, 123, WorkspaceMode.SEPARATE, zooTypes);
    }

    public static Map<ZooType, ZooModel> select(int numLabels, int seed, WorkspaceMode workspaceMode, ZooType ... zooTypes) {
        HashMap<ZooType, ZooModel> netmap = new HashMap<ZooType, ZooModel>();
        for (ZooType zooType : zooTypes) {
            ModelSelector.select(netmap, zooType, numLabels, seed, workspaceMode);
        }
        return netmap;
    }

    private static Map<ZooType, ZooModel> select(Map<ZooType, ZooModel> netmap, ZooType zooType, int numLabels, int seed, WorkspaceMode workspaceMode) {
        switch (zooType) {
            case ALL: {
                netmap.putAll(ModelSelector.select(ZooType.CNN, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.RNN, numLabels, seed, workspaceMode));
                break;
            }
            case CNN: {
                netmap.putAll(ModelSelector.select(ZooType.SIMPLECNN, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.ALEXNET, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.LENET, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.GOOGLENET, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.RESNET50, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.VGG16, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.VGG19, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.DARKNET19, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.TINYYOLO, numLabels, seed, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.YOLO2, numLabels, seed, workspaceMode));
                break;
            }
            case RNN: {
                netmap.putAll(ModelSelector.select(ZooType.TEXTGENLSTM, numLabels, seed, workspaceMode));
                break;
            }
            case TEXTGENLSTM: {
                netmap.put(ZooType.TEXTGENLSTM, new TextGenerationLSTM(numLabels, seed, workspaceMode));
                break;
            }
            case SIMPLECNN: {
                netmap.put(ZooType.SIMPLECNN, new SimpleCNN(numLabels, seed, workspaceMode));
                break;
            }
            case ALEXNET: {
                netmap.put(ZooType.ALEXNET, new AlexNet(numLabels, seed, workspaceMode));
                break;
            }
            case LENET: {
                netmap.put(ZooType.LENET, new LeNet(numLabels, seed, workspaceMode));
                break;
            }
            case INCEPTIONRESNETV1: {
                netmap.put(ZooType.INCEPTIONRESNETV1, new InceptionResNetV1(numLabels, seed, workspaceMode));
                break;
            }
            case FACENETNN4SMALL2: {
                netmap.put(ZooType.FACENETNN4SMALL2, new FaceNetNN4Small2(numLabels, seed, workspaceMode));
                break;
            }
            case GOOGLENET: {
                netmap.put(ZooType.LENET, new GoogLeNet(numLabels, seed, workspaceMode));
                break;
            }
            case RESNET50: {
                netmap.put(ZooType.RESNET50, new ResNet50(numLabels, seed, workspaceMode));
                break;
            }
            case VGG16: {
                netmap.put(ZooType.VGG16, new VGG16(numLabels, seed, workspaceMode));
                break;
            }
            case VGG19: {
                netmap.put(ZooType.VGG19, new VGG19(numLabels, seed, workspaceMode));
                break;
            }
            case DARKNET19: {
                netmap.put(ZooType.DARKNET19, new Darknet19(numLabels, seed, workspaceMode));
                break;
            }
            case TINYYOLO: {
                netmap.put(ZooType.TINYYOLO, new TinyYOLO(numLabels, seed, workspaceMode));
                break;
            }
            case YOLO2: {
                netmap.put(ZooType.YOLO2, new YOLO2(numLabels, seed, workspaceMode));
                break;
            }
        }
        if (netmap.size() == 0) {
            throw new IllegalArgumentException("Zero models have been selected for benchmarking.");
        }
        return netmap;
    }
}

