/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.distribution.TruncatedNormalDistribution;
import org.deeplearning4j.nn.conf.graph.ElementWiseVertex;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.layers.ZeroPaddingLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInitDistribution;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class ResNet50
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IWeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private ResNet50() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/resnet50_dl4j_inference.v3.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3914447815L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    private void identityBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, String input) {
        String convName = "res" + stage + block + "_branch";
        String batchName = "bn" + stage + block + "_branch";
        String activationName = "act" + stage + block + "_branch";
        String shortcutName = "short" + stage + block + "_branch";
        graph.addLayer(convName + "2a", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[0])).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{input}).addLayer(batchName + "2a", (Layer)new BatchNormalization(), new String[]{convName + "2a"}).addLayer(activationName + "2a", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2a"}).addLayer(convName + "2b", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(kernelSize).nOut(filters[1])).cudnnAlgoMode(this.cudnnAlgoMode)).convolutionMode(ConvolutionMode.Same)).build(), new String[]{activationName + "2a"}).addLayer(batchName + "2b", (Layer)new BatchNormalization(), new String[]{convName + "2b"}).addLayer(activationName + "2b", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2b"}).addLayer(convName + "2c", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[2])).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{activationName + "2b"}).addLayer(batchName + "2c", (Layer)new BatchNormalization(), new String[]{convName + "2c"}).addVertex(shortcutName, (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{batchName + "2c", input}).addLayer(convName, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{shortcutName});
    }

    private void convBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, String input) {
        this.convBlock(graph, kernelSize, filters, stage, block, new int[]{2, 2}, input);
    }

    private void convBlock(ComputationGraphConfiguration.GraphBuilder graph, int[] kernelSize, int[] filters, String stage, String block, int[] stride, String input) {
        String convName = "res" + stage + block + "_branch";
        String batchName = "bn" + stage + block + "_branch";
        String activationName = "act" + stage + block + "_branch";
        String shortcutName = "short" + stage + block + "_branch";
        graph.addLayer(convName + "2a", (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, stride).nOut(filters[0])).build(), new String[]{input}).addLayer(batchName + "2a", (Layer)new BatchNormalization(), new String[]{convName + "2a"}).addLayer(activationName + "2a", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2a"}).addLayer(convName + "2b", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(kernelSize).nOut(filters[1])).convolutionMode(ConvolutionMode.Same)).build(), new String[]{activationName + "2a"}).addLayer(batchName + "2b", (Layer)new BatchNormalization(), new String[]{convName + "2b"}).addLayer(activationName + "2b", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{batchName + "2b"}).addLayer(convName + "2c", (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nOut(filters[2])).build(), new String[]{activationName + "2b"}).addLayer(batchName + "2c", (Layer)new BatchNormalization(), new String[]{convName + "2c"}).addLayer(convName + "1", (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}, stride).nOut(filters[2])).build(), new String[]{input}).addLayer(batchName + "1", (Layer)new BatchNormalization(), new String[]{convName + "1"}).addVertex(shortcutName, (GraphVertex)new ElementWiseVertex(ElementWiseVertex.Op.Add), new String[]{batchName + "2c", batchName + "1"}).addLayer(convName, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{shortcutName});
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).activation(Activation.IDENTITY).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).l1(1.0E-7).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])}).addLayer("stem-zero", (Layer)new ZeroPaddingLayer.Builder(3, 3).build(), new String[]{"input"}).addLayer("stem-cnn1", (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}, new int[]{2, 2}).nOut(64)).build(), new String[]{"stem-zero"}).addLayer("stem-batch1", (Layer)new BatchNormalization(), new String[]{"stem-cnn1"}).addLayer("stem-act1", (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build(), new String[]{"stem-batch1"}).addLayer("stem-maxpool1", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}, new int[]{2, 2}).build(), new String[]{"stem-act1"});
        this.convBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "a", new int[]{2, 2}, "stem-maxpool1");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "b", "res2a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{64, 64, 256}, "2", "c", "res2b_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "a", "res2c_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "b", "res3a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "c", "res3b_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{128, 128, 512}, "3", "d", "res3c_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "a", "res3d_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "b", "res4a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "c", "res4b_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "d", "res4c_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "e", "res4d_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{256, 256, 1024}, "4", "f", "res4e_branch");
        this.convBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "a", "res4f_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "b", "res5a_branch");
        this.identityBlock(graph, new int[]{3, 3}, new int[]{512, 512, 2048}, "5", "c", "res5b_branch");
        graph.addLayer("avgpool", (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.MAX, new int[]{3, 3}).build(), new String[]{"res5c_branch"}).addLayer("output", (Layer)((OutputLayer.Builder)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.NEGATIVELOGLIKELIHOOD).nOut(this.numClasses)).activation(Activation.SOFTMAX)).build(), new String[]{"avgpool"}).setOutputs(new String[]{"output"});
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IWeightInit $default$weightInit() {
        return new WeightInitDistribution((Distribution)new TruncatedNormalDistribution(0.0, 0.5));
    }

    private static IUpdater $default$updater() {
        return new RmsProp(0.1, 0.96, 0.001);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static ResNet50Builder builder() {
        return new ResNet50Builder();
    }

    public ResNet50(long seed, int[] inputShape, int numClasses, IWeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class ResNet50Builder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean weightInit$set;
        private IWeightInit weightInit$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        ResNet50Builder() {
        }

        public ResNet50Builder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public ResNet50Builder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public ResNet50Builder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public ResNet50Builder weightInit(IWeightInit weightInit) {
            this.weightInit$value = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public ResNet50Builder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public ResNet50Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public ResNet50Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public ResNet50Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public ResNet50 build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = ResNet50.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = ResNet50.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = ResNet50.$default$numClasses();
            }
            IWeightInit weightInit$value = this.weightInit$value;
            if (!this.weightInit$set) {
                weightInit$value = ResNet50.$default$weightInit();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = ResNet50.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = ResNet50.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = ResNet50.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = ResNet50.$default$cudnnAlgoMode();
            }
            return new ResNet50(seed$value, inputShape$value, numClasses$value, weightInit$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "ResNet50.ResNet50Builder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", weightInit$value=" + this.weightInit$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

