/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.deeplearning4j.zoo.util.ClassPrediction;
import org.deeplearning4j.zoo.util.Labels;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.resources.Downloader;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseLabels
implements Labels {
    protected ArrayList<String> labels;

    protected BaseLabels() throws IOException {
        this.labels = this.getLabels();
    }

    protected BaseLabels(String textResource) throws IOException {
        this.labels = this.getLabels(textResource);
    }

    protected ArrayList<String> getLabels() throws IOException {
        return null;
    }

    protected ArrayList<String> getLabels(String textResource) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        File resourceFile = this.getResourceFile();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(resourceFile));
             Scanner s = new Scanner(is);){
            while (s.hasNextLine()) {
                labels.add(s.nextLine());
            }
        }
        return labels;
    }

    @Override
    public String getLabel(int n) {
        Preconditions.checkArgument((n >= 0 && n < this.labels.size() ? 1 : 0) != 0, (String)"Invalid index: %s. Must be in range0 <= n < %s", (int)n, (int)this.labels.size());
        return this.labels.get(n);
    }

    @Override
    public List<List<ClassPrediction>> decodePredictions(INDArray predictions, int n) {
        if (predictions.rank() == 1) {
            predictions = predictions.reshape(1L, predictions.length());
        }
        Preconditions.checkState((predictions.size(1) == (long)this.labels.size() ? 1 : 0) != 0, (String)"Invalid input array: expected array with size(1) equal to numLabels (%s), got array with shape %s", (Object)this.labels.size(), (Object)predictions.shape());
        long rows = predictions.size(0);
        long cols = predictions.size(1);
        if (predictions.isColumnVectorOrScalar()) {
            predictions = predictions.ravel();
            rows = (int)predictions.size(0);
            cols = (int)predictions.size(1);
        }
        ArrayList<List<ClassPrediction>> descriptions = new ArrayList<List<ClassPrediction>>();
        int batch = 0;
        while ((long)batch < rows) {
            INDArray result = predictions.getRow((long)batch, true);
            result = Nd4j.vstack((INDArray[])new INDArray[]{Nd4j.linspace((DataType)result.dataType(), (long)0L, (long)cols, (long)1L).reshape(1L, cols), result});
            result = Nd4j.sortColumns((INDArray)result, (int)1, (boolean)false);
            ArrayList<ClassPrediction> current = new ArrayList<ClassPrediction>();
            for (int i = 0; i < n; ++i) {
                int label = result.getInt(new int[]{0, i});
                double prob = result.getDouble(1L, (long)i);
                current.add(new ClassPrediction(label, this.getLabel(label), prob));
            }
            descriptions.add(current);
            ++batch;
        }
        return descriptions;
    }

    protected abstract URL getURL();

    protected abstract String resourceName();

    protected abstract String resourceMD5();

    protected File getResourceFile() {
        URL url = this.getURL();
        String urlString = url.toString();
        String filename = urlString.substring(urlString.lastIndexOf(47) + 1);
        File resourceDir = DL4JResources.getDirectory((ResourceType)ResourceType.RESOURCE, (String)this.resourceName());
        File localFile = new File(resourceDir, filename);
        String expMD5 = this.resourceMD5();
        if (localFile.exists()) {
            try {
                if (Downloader.checkMD5OfFile((String)expMD5, (File)localFile)) {
                    return localFile;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            localFile.delete();
        }
        try {
            Downloader.download((String)this.resourceName(), (URL)url, (File)localFile, (String)expMD5, (int)3);
        }
        catch (IOException e) {
            throw new RuntimeException("Error downloading labels", e);
        }
        return localFile;
    }
}

