/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.util.imagenet;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.shade.jackson.databind.ObjectMapper;

public class ImageNetLabels {
    private static final String jsonUrl = "http://blob.deeplearning4j.org/utils/imagenet_class_index.json";
    private static ArrayList<String> predictionLabels = null;

    public ImageNetLabels() {
        predictionLabels = this.getLabels();
    }

    private static ArrayList<String> getLabels() {
        if (predictionLabels == null) {
            try {
                HashMap jsonMap = (HashMap)new ObjectMapper().readValue(new URL(jsonUrl), HashMap.class);
                predictionLabels = new ArrayList(jsonMap.size());
                for (int i = 0; i < jsonMap.size(); ++i) {
                    predictionLabels.add((String)((ArrayList)jsonMap.get(String.valueOf(i))).get(1));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return predictionLabels;
    }

    public String getLabel(int n) {
        return predictionLabels.get(n);
    }

    public String decodePredictions(INDArray predictions) {
        String predictionDescription = "";
        int[] top5 = new int[5];
        float[] top5Prob = new float[5];
        int i = 0;
        for (int batch = 0; batch < predictions.size(0); ++batch) {
            predictionDescription = predictionDescription + "Predictions for batch ";
            if (predictions.size(0) > 1) {
                predictionDescription = predictionDescription + String.valueOf(batch);
            }
            predictionDescription = predictionDescription + " :";
            INDArray currentBatch = predictions.getRow(batch).dup();
            while (i < 5) {
                top5[i] = Nd4j.argMax((INDArray)currentBatch, (int[])new int[]{1}).getInt(new int[]{0, 0});
                top5Prob[i] = currentBatch.getFloat(batch, top5[i]);
                currentBatch.putScalar(0, top5[i], 0.0);
                predictionDescription = predictionDescription + "\n\t" + String.format("%3f", Float.valueOf(top5Prob[i] * 100.0f)) + "%, " + predictionLabels.get(top5[i]);
                ++i;
            }
        }
        return predictionDescription;
    }
}

