/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo;

import java.util.HashMap;
import java.util.Map;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.AlexNet;
import org.deeplearning4j.zoo.model.FaceNetNN4Small2;
import org.deeplearning4j.zoo.model.GoogLeNet;
import org.deeplearning4j.zoo.model.InceptionResNetV1;
import org.deeplearning4j.zoo.model.LeNet;
import org.deeplearning4j.zoo.model.ResNet50;
import org.deeplearning4j.zoo.model.SimpleCNN;
import org.deeplearning4j.zoo.model.TextGenerationLSTM;
import org.deeplearning4j.zoo.model.VGG16;
import org.deeplearning4j.zoo.model.VGG19;

public class ModelSelector {
    public static Map<ZooType, ZooModel> select(ZooType zooType) {
        return ModelSelector.select(zooType, 1, 123, 1, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels) {
        return ModelSelector.select(zooType, numLabels, 123, 1, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, WorkspaceMode workspaceMode) {
        return ModelSelector.select(zooType, numLabels, 123, 1, workspaceMode);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, int seed, int iterations) {
        return ModelSelector.select(zooType, numLabels, 123, 1, WorkspaceMode.SEPARATE);
    }

    public static Map<ZooType, ZooModel> select(ZooType zooType, int numLabels, int seed, int iterations, WorkspaceMode workspaceMode) {
        return ModelSelector.select(new HashMap<ZooType, ZooModel>(), zooType, numLabels, seed, iterations, workspaceMode);
    }

    public static Map<ZooType, ZooModel> select(WorkspaceMode workspaceMode, ZooType ... zooTypes) {
        return ModelSelector.select(0, 123, 1, workspaceMode, zooTypes);
    }

    public static Map<ZooType, ZooModel> select(ZooType ... zooTypes) {
        return ModelSelector.select(0, 123, 1, WorkspaceMode.SEPARATE, zooTypes);
    }

    public static Map<ZooType, ZooModel> select(int numLabels, int seed, int iterations, WorkspaceMode workspaceMode, ZooType ... zooTypes) {
        HashMap<ZooType, ZooModel> netmap = new HashMap<ZooType, ZooModel>();
        for (ZooType zooType : zooTypes) {
            ModelSelector.select(netmap, zooType, numLabels, seed, iterations, workspaceMode);
        }
        return netmap;
    }

    private static Map<ZooType, ZooModel> select(Map<ZooType, ZooModel> netmap, ZooType zooType, int numLabels, int seed, int iterations, WorkspaceMode workspaceMode) {
        switch (zooType) {
            case ALL: {
                netmap.putAll(ModelSelector.select(ZooType.CNN, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.RNN, numLabels, seed, iterations, workspaceMode));
                break;
            }
            case CNN: {
                netmap.putAll(ModelSelector.select(ZooType.SIMPLECNN, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.ALEXNET, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.LENET, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.GOOGLENET, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.RESNET50, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.VGG16, numLabels, seed, iterations, workspaceMode));
                netmap.putAll(ModelSelector.select(ZooType.VGG19, numLabels, seed, iterations, workspaceMode));
                break;
            }
            case RNN: {
                netmap.putAll(ModelSelector.select(ZooType.TEXTGENLSTM, numLabels, seed, iterations, workspaceMode));
                break;
            }
            case TEXTGENLSTM: {
                netmap.put(ZooType.TEXTGENLSTM, new TextGenerationLSTM(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case SIMPLECNN: {
                netmap.put(ZooType.SIMPLECNN, new SimpleCNN(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case ALEXNET: {
                netmap.put(ZooType.ALEXNET, new AlexNet(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case LENET: {
                netmap.put(ZooType.LENET, new LeNet(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case INCEPTIONRESNETV1: {
                netmap.put(ZooType.INCEPTIONRESNETV1, new InceptionResNetV1(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case FACENETNN4SMALL2: {
                netmap.put(ZooType.FACENETNN4SMALL2, new FaceNetNN4Small2(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case GOOGLENET: {
                netmap.put(ZooType.LENET, new GoogLeNet(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case RESNET50: {
                netmap.put(ZooType.RESNET50, new ResNet50(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case VGG16: {
                netmap.put(ZooType.VGG16, new VGG16(numLabels, seed, iterations, workspaceMode));
                break;
            }
            case VGG19: {
                netmap.put(ZooType.VGG19, new VGG19(numLabels, seed, iterations, workspaceMode));
                break;
            }
        }
        if (netmap.size() == 0) {
            throw new IllegalArgumentException("Zero models have been selected for benchmarking.");
        }
        return netmap;
    }
}

