/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import org.nd4j.common.loader.Loader;
import org.nd4j.common.loader.Source;
import org.nd4j.common.loader.SourceFactory;
import org.nd4j.common.util.MathUtils;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class MultiDataSetLoaderIterator
implements MultiDataSetIterator {
    protected final List<String> paths;
    protected final Iterator<String> iter;
    protected final Loader<MultiDataSet> loader;
    protected final SourceFactory sourceFactory;
    protected final Random rng;
    protected final int[] order;
    protected MultiDataSetPreProcessor preProcessor;
    protected int position;

    public MultiDataSetLoaderIterator(Iterator<String> paths, Loader<MultiDataSet> loader, SourceFactory sourceFactory) {
        this.paths = null;
        this.iter = paths;
        this.loader = loader;
        this.sourceFactory = sourceFactory;
        this.rng = null;
        this.order = null;
    }

    public MultiDataSetLoaderIterator(Collection<String> paths, Loader<MultiDataSet> loader, SourceFactory sourceFactory) {
        this(paths, null, loader, sourceFactory);
    }

    public MultiDataSetLoaderIterator(Collection<String> paths, Random rng, Loader<MultiDataSet> loader, SourceFactory sourceFactory) {
        this.paths = paths instanceof List ? (List<Object>)paths : new ArrayList<String>(paths);
        this.rng = rng;
        this.loader = loader;
        this.sourceFactory = sourceFactory;
        this.iter = null;
        if (rng != null) {
            this.order = new int[paths.size()];
            for (int i = 0; i < this.order.length; ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        } else {
            this.order = null;
        }
    }

    public MultiDataSet next(int i) {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean resetSupported() {
        return this.paths != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (!this.resetSupported()) {
            throw new UnsupportedOperationException("Reset not supported when using Iterator<String> instead of Iterable<String>");
        }
        this.position = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    public boolean hasNext() {
        if (this.iter != null) {
            return this.iter.hasNext();
        }
        return this.position < this.paths.size();
    }

    public MultiDataSet next() {
        MultiDataSet mds;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        String path = this.iter != null ? this.iter.next() : (this.order != null ? this.paths.get(this.order[this.position++]) : this.paths.get(this.position++));
        Source s = this.sourceFactory.getSource(path);
        try {
            mds = (MultiDataSet)this.loader.load(s);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(mds);
        }
        return mds;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Iterator<String> getIter() {
        return this.iter;
    }

    public Loader<MultiDataSet> getLoader() {
        return this.loader;
    }

    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    public Random getRng() {
        return this.rng;
    }

    public int[] getOrder() {
        return this.order;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiDataSetLoaderIterator)) {
            return false;
        }
        MultiDataSetLoaderIterator other = (MultiDataSetLoaderIterator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Iterator<String> this$iter = this.getIter();
        Iterator<String> other$iter = other.getIter();
        if (this$iter == null ? other$iter != null : !this$iter.equals(other$iter)) {
            return false;
        }
        Loader<MultiDataSet> this$loader = this.getLoader();
        Loader<MultiDataSet> other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        SourceFactory this$sourceFactory = this.getSourceFactory();
        SourceFactory other$sourceFactory = other.getSourceFactory();
        if (this$sourceFactory == null ? other$sourceFactory != null : !this$sourceFactory.equals(other$sourceFactory)) {
            return false;
        }
        Random this$rng = this.getRng();
        Random other$rng = other.getRng();
        if (this$rng == null ? other$rng != null : !this$rng.equals(other$rng)) {
            return false;
        }
        if (!Arrays.equals(this.getOrder(), other.getOrder())) {
            return false;
        }
        MultiDataSetPreProcessor this$preProcessor = this.getPreProcessor();
        MultiDataSetPreProcessor other$preProcessor = other.getPreProcessor();
        if (this$preProcessor == null ? other$preProcessor != null : !this$preProcessor.equals(other$preProcessor)) {
            return false;
        }
        return this.getPosition() == other.getPosition();
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiDataSetLoaderIterator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Iterator<String> $iter = this.getIter();
        result = result * 59 + ($iter == null ? 43 : $iter.hashCode());
        Loader<MultiDataSet> $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        SourceFactory $sourceFactory = this.getSourceFactory();
        result = result * 59 + ($sourceFactory == null ? 43 : $sourceFactory.hashCode());
        Random $rng = this.getRng();
        result = result * 59 + ($rng == null ? 43 : $rng.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOrder());
        MultiDataSetPreProcessor $preProcessor = this.getPreProcessor();
        result = result * 59 + ($preProcessor == null ? 43 : $preProcessor.hashCode());
        result = result * 59 + this.getPosition();
        return result;
    }

    public String toString() {
        return "MultiDataSetLoaderIterator(paths=" + this.getPaths() + ", iter=" + this.getIter() + ", loader=" + this.getLoader() + ", sourceFactory=" + this.getSourceFactory() + ", rng=" + this.getRng() + ", order=" + Arrays.toString(this.getOrder()) + ", preProcessor=" + this.getPreProcessor() + ", position=" + this.getPosition() + ")";
    }
}

