/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.api.storage.Persistable;

public class ConvolutionListenerPersistable
implements Persistable {
    private static final String TYPE_ID = "ConvolutionalListener";
    private String sessionID;
    private String workerID;
    private long timestamp;
    private transient BufferedImage img;

    public ConvolutionListenerPersistable() {
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public String getTypeID() {
        return TYPE_ID;
    }

    public String getWorkerID() {
        return this.workerID;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int encodingLengthBytes() {
        return 0;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public void decode(byte[] decode) {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
            ConvolutionListenerPersistable p = (ConvolutionListenerPersistable)ois.readObject();
            this.sessionID = p.sessionID;
            this.workerID = p.workerID;
            this.timestamp = p.getTimeStamp();
            this.img = p.img;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        this.decode(arr);
    }

    public void decode(InputStream inputStream) throws IOException {
        byte[] b = IOUtils.toByteArray((InputStream)inputStream);
        this.decode(b);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        ImageIO.write((RenderedImage)this.img, "png", oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.img = ImageIO.read(ois);
    }

    public ConvolutionListenerPersistable(String sessionID, String workerID, long timestamp, BufferedImage img) {
        this.sessionID = sessionID;
        this.workerID = workerID;
        this.timestamp = timestamp;
        this.img = img;
    }

    public BufferedImage getImg() {
        return this.img;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setWorkerID(String workerID) {
        this.workerID = workerID;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setImg(BufferedImage img) {
        this.img = img;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionListenerPersistable)) {
            return false;
        }
        ConvolutionListenerPersistable other = (ConvolutionListenerPersistable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sessionID = this.getSessionID();
        String other$sessionID = other.getSessionID();
        if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
            return false;
        }
        String this$workerID = this.getWorkerID();
        String other$workerID = other.getWorkerID();
        if (this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID)) {
            return false;
        }
        return this.getTimeStamp() == other.getTimeStamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionListenerPersistable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sessionID = this.getSessionID();
        result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
        String $workerID = this.getWorkerID();
        result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
        long $timestamp = this.getTimeStamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public String toString() {
        return "ConvolutionListenerPersistable(sessionID=" + this.getSessionID() + ", workerID=" + this.getWorkerID() + ", timestamp=" + this.getTimeStamp() + ", img=" + this.getImg() + ")";
    }
}

