/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage.mapdb;

import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;

public class MapDBStatsStorage
implements StatsStorage {
    private static final String COMPOSITE_KEY_HEADER = "&&&";
    private static final String COMPOSITE_KEY_SEPARATOR = "@@@";
    private boolean isClosed = false;
    private DB db;
    private Set<String> sessionIDs;
    private Map<SessionTypeId, StorageMetaData> storageMetaData;
    private Map<SessionTypeWorkerId, Persistable> staticInfo;
    private Map<String, Integer> classToInteger;
    private Map<Integer, String> integerToClass;
    private Atomic.Integer classCounter;
    private Map<SessionTypeWorkerId, Map<Long, Persistable>> updates = new HashMap<SessionTypeWorkerId, Map<Long, Persistable>>();
    private List<StatsStorageListener> listeners = new ArrayList<StatsStorageListener>();

    public MapDBStatsStorage() {
        this(new Builder());
    }

    public MapDBStatsStorage(File f) {
        this(new Builder().file(f));
    }

    private MapDBStatsStorage(Builder builder) {
        File f = builder.getFile();
        this.db = f == null ? DBMaker.memoryDB().make() : DBMaker.fileDB((File)f).closeOnJvmShutdown().transactionEnable().make();
        this.sessionIDs = (Set)this.db.hashSet("sessionIDs", (Serializer)Serializer.STRING).createOrOpen();
        this.storageMetaData = this.db.hashMap("storageMetaData").keySerializer((Serializer)new SessionTypeIdSerializer()).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.staticInfo = this.db.hashMap("staticInfo").keySerializer((Serializer)new SessionTypeWorkerIdSerializer()).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.classToInteger = this.db.hashMap("classToInteger").keySerializer((Serializer)Serializer.STRING).valueSerializer((Serializer)Serializer.INTEGER).createOrOpen();
        this.integerToClass = this.db.hashMap("integerToClass").keySerializer((Serializer)Serializer.INTEGER).valueSerializer((Serializer)Serializer.STRING).createOrOpen();
        this.classCounter = (Atomic.Integer)this.db.atomicInteger("classCounter").createOrOpen();
        for (String s : this.db.getAllNames()) {
            if (!s.startsWith(COMPOSITE_KEY_HEADER)) continue;
            HTreeMap m = this.db.hashMap(s).keySerializer((Serializer)Serializer.LONG).valueSerializer(new PersistableSerializer()).open();
            String[] arr = s.split(COMPOSITE_KEY_SEPARATOR);
            arr[0] = arr[0].substring(COMPOSITE_KEY_HEADER.length());
            SessionTypeWorkerId id = new SessionTypeWorkerId(arr[0], arr[1], arr[2]);
            this.updates.put(id, (Map<Long, Persistable>)m);
        }
    }

    private synchronized Map<Long, Persistable> getUpdateMap(String sessionID, String typeID, String workerID, boolean createIfRequired) {
        SessionTypeWorkerId id = new SessionTypeWorkerId(sessionID, typeID, workerID);
        if (this.updates.containsKey(id)) {
            return this.updates.get(id);
        }
        if (!createIfRequired) {
            return null;
        }
        String compositeKey = COMPOSITE_KEY_HEADER + sessionID + COMPOSITE_KEY_SEPARATOR + typeID + COMPOSITE_KEY_SEPARATOR + workerID;
        HTreeMap updateMap = this.db.hashMap(compositeKey).keySerializer((Serializer)Serializer.LONG).valueSerializer(new PersistableSerializer()).createOrOpen();
        this.updates.put(id, (Map<Long, Persistable>)updateMap);
        return updateMap;
    }

    private List<StatsStorageEvent> checkStorageEvents(Persistable p) {
        if (this.listeners.size() == 0) {
            return null;
        }
        int count = 0;
        StatsStorageEvent newSID = null;
        StatsStorageEvent newTID = null;
        StatsStorageEvent newWID = null;
        if (!this.sessionIDs.contains(p.getSessionID())) {
            newSID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewSessionID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
            ++count;
        }
        boolean foundTypeId = false;
        boolean foundWorkerId = false;
        String typeId = p.getTypeID();
        String wid = p.getWorkerID();
        for (SessionTypeId ts : this.storageMetaData.keySet()) {
            if (!typeId.equals(ts.getTypeID())) continue;
            foundTypeId = true;
            break;
        }
        for (SessionTypeWorkerId stw : this.staticInfo.keySet()) {
            if (!foundTypeId && typeId.equals(stw.getTypeID())) {
                foundTypeId = true;
            }
            if (!foundWorkerId && wid.equals(stw.getWorkerID())) {
                foundWorkerId = true;
            }
            if (!foundTypeId || !foundWorkerId) continue;
            break;
        }
        if (!foundTypeId || !foundWorkerId) {
            for (SessionTypeWorkerId stw : this.updates.keySet()) {
                if (!foundTypeId && typeId.equals(stw.getTypeID())) {
                    foundTypeId = true;
                }
                if (!foundWorkerId && wid.equals(stw.getWorkerID())) {
                    foundWorkerId = true;
                }
                if (!foundTypeId || !foundWorkerId) continue;
                break;
            }
        }
        if (!foundTypeId) {
            newTID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewTypeID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
            ++count;
        }
        if (!foundWorkerId) {
            newWID = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.NewWorkerID, p.getSessionID(), p.getTypeID(), p.getWorkerID(), p.getTimeStamp());
            ++count;
        }
        if (count == 0) {
            return null;
        }
        ArrayList<StatsStorageEvent> sses = new ArrayList<StatsStorageEvent>(count);
        if (newSID != null) {
            sses.add(newSID);
        }
        if (newTID != null) {
            sses.add(newTID);
        }
        if (newWID != null) {
            sses.add(newWID);
        }
        return sses;
    }

    private void notifyListeners(List<StatsStorageEvent> sses) {
        if (sses == null || sses.size() == 0 || this.listeners.size() == 0) {
            return;
        }
        for (StatsStorageListener l : this.listeners) {
            for (StatsStorageEvent e : sses) {
                l.notify(e);
            }
        }
    }

    public void close() {
        this.db.commit();
        this.db.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public List<String> listSessionIDs() {
        return new ArrayList<String>(this.sessionIDs);
    }

    public boolean sessionExists(String sessionID) {
        return this.sessionIDs.contains(sessionID);
    }

    public Persistable getStaticInfo(String sessionID, String typeID, String workerID) {
        SessionTypeWorkerId id = new SessionTypeWorkerId(sessionID, typeID, workerID);
        return this.staticInfo.get(id);
    }

    public List<Persistable> getAllStaticInfos(String sessionID, String typeID) {
        ArrayList<Persistable> out = new ArrayList<Persistable>();
        for (SessionTypeWorkerId key : this.staticInfo.keySet()) {
            if (!sessionID.equals(key.getSessionID()) || !typeID.equals(key.getTypeID())) continue;
            out.add(this.staticInfo.get(key));
        }
        return out;
    }

    public List<String> listTypeIDsForSession(String sessionID) {
        HashSet<String> typeIDs = new HashSet<String>();
        for (SessionTypeId st : this.storageMetaData.keySet()) {
            if (!sessionID.equals(st.getSessionID())) continue;
            typeIDs.add(st.getTypeID());
        }
        for (SessionTypeWorkerId stw : this.staticInfo.keySet()) {
            if (!sessionID.equals(stw.getSessionID())) continue;
            typeIDs.add(stw.getTypeID());
        }
        for (SessionTypeWorkerId stw : this.updates.keySet()) {
            if (!sessionID.equals(stw.getSessionID())) continue;
            typeIDs.add(stw.getTypeID());
        }
        return new ArrayList<String>(typeIDs);
    }

    public List<String> listWorkerIDsForSession(String sessionID) {
        ArrayList<String> out = new ArrayList<String>();
        for (SessionTypeWorkerId ids : this.staticInfo.keySet()) {
            if (!sessionID.equals(ids.getSessionID())) continue;
            out.add(ids.getWorkerID());
        }
        return out;
    }

    public List<String> listWorkerIDsForSessionAndType(String sessionID, String typeID) {
        ArrayList<String> out = new ArrayList<String>();
        for (SessionTypeWorkerId ids : this.staticInfo.keySet()) {
            if (!sessionID.equals(ids.getSessionID()) || !typeID.equals(ids.getTypeID())) continue;
            out.add(ids.getWorkerID());
        }
        return out;
    }

    public int getNumUpdateRecordsFor(String sessionID) {
        int count = 0;
        for (SessionTypeWorkerId id : this.updates.keySet()) {
            Map<Long, Persistable> map;
            if (!sessionID.equals(id.getSessionID()) || (map = this.updates.get(id)) == null) continue;
            count += map.size();
        }
        return count;
    }

    public int getNumUpdateRecordsFor(String sessionID, String typeID, String workerID) {
        SessionTypeWorkerId id = new SessionTypeWorkerId(sessionID, typeID, workerID);
        Map<Long, Persistable> map = this.updates.get(id);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    public Persistable getLatestUpdate(String sessionID, String typeID, String workerID) {
        SessionTypeWorkerId id = new SessionTypeWorkerId(sessionID, typeID, workerID);
        Map<Long, Persistable> map = this.updates.get(id);
        if (map == null || map.isEmpty()) {
            return null;
        }
        long maxTime = Long.MIN_VALUE;
        for (Long l : map.keySet()) {
            maxTime = Math.max(maxTime, l);
        }
        return map.get(maxTime);
    }

    public Persistable getUpdate(String sessionID, String typeID, String workerID, long timestamp) {
        SessionTypeWorkerId id = new SessionTypeWorkerId(sessionID, typeID, workerID);
        Map<Long, Persistable> map = this.updates.get(id);
        if (map == null) {
            return null;
        }
        return map.get(timestamp);
    }

    public List<Persistable> getLatestUpdateAllWorkers(String sessionID, String typeID) {
        ArrayList<Persistable> list = new ArrayList<Persistable>();
        for (SessionTypeWorkerId id : this.updates.keySet()) {
            Persistable p;
            if (!sessionID.equals(id.getSessionID()) || !typeID.equals(id.getTypeID()) || (p = this.getLatestUpdate(sessionID, typeID, id.workerID)) == null) continue;
            list.add(p);
        }
        return list;
    }

    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, String workerID, long timestamp) {
        ArrayList<Persistable> list = new ArrayList<Persistable>();
        Map<Long, Persistable> map = this.getUpdateMap(sessionID, typeID, workerID, false);
        if (map == null) {
            return list;
        }
        for (Long time : map.keySet()) {
            if (time <= timestamp) continue;
            list.add(map.get(time));
        }
        Collections.sort(list, new Comparator<Persistable>(){

            @Override
            public int compare(Persistable o1, Persistable o2) {
                return Long.compare(o1.getTimeStamp(), o2.getTimeStamp());
            }
        });
        return list;
    }

    public List<Persistable> getAllUpdatesAfter(String sessionID, String typeID, long timestamp) {
        ArrayList<Persistable> list = new ArrayList<Persistable>();
        for (SessionTypeWorkerId stw : this.staticInfo.keySet()) {
            Map<Long, Persistable> u;
            if (!stw.getSessionID().equals(sessionID) || !stw.getTypeID().equals(typeID) || (u = this.updates.get(stw)) == null) continue;
            for (long l : u.keySet()) {
                if (l <= timestamp) continue;
                list.add(u.get(l));
            }
        }
        Collections.sort(list, new Comparator<Persistable>(){

            @Override
            public int compare(Persistable o1, Persistable o2) {
                return Long.compare(o1.getTimeStamp(), o2.getTimeStamp());
            }
        });
        return list;
    }

    public StorageMetaData getStorageMetaData(String sessionID, String typeID) {
        return this.storageMetaData.get(new SessionTypeId(sessionID, typeID));
    }

    public void putStaticInfo(Persistable staticInfo) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(staticInfo);
        if (!this.sessionIDs.contains(staticInfo.getSessionID())) {
            this.sessionIDs.add(staticInfo.getSessionID());
        }
        SessionTypeWorkerId id = new SessionTypeWorkerId(staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID());
        this.staticInfo.put(id, staticInfo);
        this.db.commit();
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostStaticInfo, staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID(), staticInfo.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    public void putStaticInfo(Collection<? extends Persistable> staticInfo) {
        for (Persistable persistable : staticInfo) {
            this.putStaticInfo(persistable);
        }
    }

    public void putUpdate(Persistable update) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(update);
        Map<Long, Persistable> updateMap = this.getUpdateMap(update.getSessionID(), update.getTypeID(), update.getWorkerID(), true);
        updateMap.put(update.getTimeStamp(), update);
        this.db.commit();
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostUpdate, update.getSessionID(), update.getTypeID(), update.getWorkerID(), update.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    public void putUpdate(Collection<? extends Persistable> updates) {
        for (Persistable persistable : updates) {
            this.putUpdate(persistable);
        }
    }

    public void putStorageMetaData(StorageMetaData storageMetaData) {
        List<StatsStorageEvent> sses = this.checkStorageEvents((Persistable)storageMetaData);
        SessionTypeId id = new SessionTypeId(storageMetaData.getSessionID(), storageMetaData.getTypeID());
        this.storageMetaData.put(id, storageMetaData);
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostMetaData, storageMetaData.getSessionID(), storageMetaData.getTypeID(), storageMetaData.getWorkerID(), storageMetaData.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    public void putStorageMetaData(Collection<? extends StorageMetaData> storageMetaData) {
        for (StorageMetaData storageMetaData2 : storageMetaData) {
            this.putStorageMetaData(storageMetaData2);
        }
    }

    public void registerStatsStorageListener(StatsStorageListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void deregisterStatsStorageListener(StatsStorageListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public List<StatsStorageListener> getListeners() {
        return new ArrayList<StatsStorageListener>(this.listeners);
    }

    private synchronized int getIntForClass(Class<?> c) {
        String str = c.getName();
        if (this.classToInteger.containsKey(str)) {
            return this.classToInteger.get(str);
        }
        int idx = this.classCounter.getAndIncrement();
        this.classToInteger.put(str, idx);
        this.integerToClass.put(idx, str);
        this.db.commit();
        return idx;
    }

    private synchronized String getClassForInt(int integer) {
        String c = this.integerToClass.get(integer);
        if (c == null) {
            throw new RuntimeException("Unknown class index: " + integer);
        }
        return c;
    }

    private class PersistableSerializer<T extends Persistable>
    implements Serializer<T> {
        private PersistableSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull Persistable value) throws IOException {
            int classIdx = MapDBStatsStorage.this.getIntForClass(value.getClass());
            out.writeInt(classIdx);
            value.encode((OutputStream)out);
        }

        public T deserialize(@NotNull DataInput2 input, int available) throws IOException {
            Persistable p;
            Class<?> clazz;
            int classIdx = input.readInt();
            String className = MapDBStatsStorage.this.getClassForInt(classIdx);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                p = (Persistable)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            int remainingLength = available - 4;
            byte[] temp = new byte[remainingLength];
            input.readFully(temp);
            p.decode(temp);
            return (T)p;
        }

        public int compare(Persistable p1, Persistable p2) {
            int c = p1.getSessionID().compareTo(p2.getSessionID());
            if (c != 0) {
                return c;
            }
            c = p1.getTypeID().compareTo(p2.getTypeID());
            if (c != 0) {
                return c;
            }
            return p1.getWorkerID().compareTo(p2.getWorkerID());
        }
    }

    private static class SessionTypeIdSerializer
    implements Serializer<SessionTypeId> {
        private SessionTypeIdSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SessionTypeId value) throws IOException {
            ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)out);
            out2.writeObject(value);
            out2.flush();
        }

        public SessionTypeId deserialize(@NotNull DataInput2 in, int available) throws IOException {
            try {
                ObjectInputStream in2 = new ObjectInputStream((InputStream)new DataInput2.DataInputToStream((DataInput)in));
                return (SessionTypeId)in2.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public int compare(SessionTypeId w1, SessionTypeId w2) {
            return w1.compareTo(w2);
        }
    }

    private static class SessionTypeWorkerIdSerializer
    implements Serializer<SessionTypeWorkerId> {
        private SessionTypeWorkerIdSerializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull SessionTypeWorkerId value) throws IOException {
            ObjectOutputStream out2 = new ObjectOutputStream((OutputStream)out);
            out2.writeObject(value);
            out2.flush();
        }

        public SessionTypeWorkerId deserialize(@NotNull DataInput2 in, int available) throws IOException {
            try {
                ObjectInputStream in2 = new ObjectInputStream((InputStream)new DataInput2.DataInputToStream((DataInput)in));
                return (SessionTypeWorkerId)in2.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public int compare(SessionTypeWorkerId w1, SessionTypeWorkerId w2) {
            return w1.compareTo(w2);
        }
    }

    public static class SessionTypeId
    implements Serializable,
    Comparable<SessionTypeId> {
        private final String sessionID;
        private final String typeID;

        @Override
        public int compareTo(SessionTypeId o) {
            int c = this.sessionID.compareTo(o.sessionID);
            if (c != 0) {
                return c;
            }
            return this.typeID.compareTo(o.typeID);
        }

        public String toString() {
            return "(" + this.sessionID + "," + this.typeID + ")";
        }

        @ConstructorProperties(value={"sessionID", "typeID"})
        public SessionTypeId(String sessionID, String typeID) {
            this.sessionID = sessionID;
            this.typeID = typeID;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public String getTypeID() {
            return this.typeID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SessionTypeId)) {
                return false;
            }
            SessionTypeId other = (SessionTypeId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sessionID = this.getSessionID();
            String other$sessionID = other.getSessionID();
            if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
                return false;
            }
            String this$typeID = this.getTypeID();
            String other$typeID = other.getTypeID();
            return !(this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SessionTypeId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sessionID = this.getSessionID();
            result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
            String $typeID = this.getTypeID();
            result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
            return result;
        }
    }

    public static class SessionTypeWorkerId
    implements Serializable,
    Comparable<SessionTypeWorkerId> {
        private final String sessionID;
        private final String typeID;
        private final String workerID;

        public SessionTypeWorkerId(String sessionID, String typeID, String workerID) {
            this.sessionID = sessionID;
            this.typeID = typeID;
            this.workerID = workerID;
        }

        @Override
        public int compareTo(SessionTypeWorkerId o) {
            int c = this.sessionID.compareTo(o.sessionID);
            if (c != 0) {
                return c;
            }
            c = this.typeID.compareTo(o.typeID);
            if (c != 0) {
                return c;
            }
            return this.workerID.compareTo(this.workerID);
        }

        public String toString() {
            return "(" + this.sessionID + "," + this.typeID + "," + this.workerID + ")";
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public String getTypeID() {
            return this.typeID;
        }

        public String getWorkerID() {
            return this.workerID;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SessionTypeWorkerId)) {
                return false;
            }
            SessionTypeWorkerId other = (SessionTypeWorkerId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sessionID = this.getSessionID();
            String other$sessionID = other.getSessionID();
            if (this$sessionID == null ? other$sessionID != null : !this$sessionID.equals(other$sessionID)) {
                return false;
            }
            String this$typeID = this.getTypeID();
            String other$typeID = other.getTypeID();
            if (this$typeID == null ? other$typeID != null : !this$typeID.equals(other$typeID)) {
                return false;
            }
            String this$workerID = this.getWorkerID();
            String other$workerID = other.getWorkerID();
            return !(this$workerID == null ? other$workerID != null : !this$workerID.equals(other$workerID));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SessionTypeWorkerId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sessionID = this.getSessionID();
            result = result * 59 + ($sessionID == null ? 43 : $sessionID.hashCode());
            String $typeID = this.getTypeID();
            result = result * 59 + ($typeID == null ? 43 : $typeID.hashCode());
            String $workerID = this.getWorkerID();
            result = result * 59 + ($workerID == null ? 43 : $workerID.hashCode());
            return result;
        }
    }

    public static class Builder {
        private File file;
        private boolean useWriteAheadLog = true;

        public Builder() {
            this(null);
        }

        public Builder(File file) {
            this.file = file;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        public Builder useWriteAheadLog(boolean useWriteAheadLog) {
            this.useWriteAheadLog = useWriteAheadLog;
            return this;
        }

        public MapDBStatsStorage build() {
            return new MapDBStatsStorage(this);
        }

        public File getFile() {
            return this.file;
        }

        public boolean isUseWriteAheadLog() {
            return this.useWriteAheadLog;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setUseWriteAheadLog(boolean useWriteAheadLog) {
            this.useWriteAheadLog = useWriteAheadLog;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            return this.isUseWriteAheadLog() == other.isUseWriteAheadLog();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            result = result * 59 + (this.isUseWriteAheadLog() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "MapDBStatsStorage.Builder(file=" + this.getFile() + ", useWriteAheadLog=" + this.isUseWriteAheadLog() + ")";
        }
    }
}

