/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.components.chart;

import java.awt.Color;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.ui.api.Utils;
import org.deeplearning4j.ui.components.chart.Chart;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChartTimeline
extends Chart {
    public static final String COMPONENT_TYPE = "ChartTimeline";
    private List<String> laneNames = new ArrayList<String>();
    private List<List<TimelineEntry>> laneData = new ArrayList<List<TimelineEntry>>();

    public ChartTimeline() {
        super(COMPONENT_TYPE);
    }

    private ChartTimeline(Builder builder) {
        super(COMPONENT_TYPE, builder);
        this.laneNames = builder.laneNames;
        this.laneData = builder.laneData;
    }

    public List<String> getLaneNames() {
        return this.laneNames;
    }

    public List<List<TimelineEntry>> getLaneData() {
        return this.laneData;
    }

    public void setLaneNames(List<String> laneNames) {
        this.laneNames = laneNames;
    }

    public void setLaneData(List<List<TimelineEntry>> laneData) {
        this.laneData = laneData;
    }

    @Override
    public String toString() {
        return "ChartTimeline(laneNames=" + this.getLaneNames() + ", laneData=" + this.getLaneData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartTimeline)) {
            return false;
        }
        ChartTimeline other = (ChartTimeline)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$laneNames = this.getLaneNames();
        List<String> other$laneNames = other.getLaneNames();
        if (this$laneNames == null ? other$laneNames != null : !((Object)this$laneNames).equals(other$laneNames)) {
            return false;
        }
        List<List<TimelineEntry>> this$laneData = this.getLaneData();
        List<List<TimelineEntry>> other$laneData = other.getLaneData();
        return !(this$laneData == null ? other$laneData != null : !((Object)this$laneData).equals(other$laneData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChartTimeline;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<String> $laneNames = this.getLaneNames();
        result = result * 59 + ($laneNames == null ? 43 : ((Object)$laneNames).hashCode());
        List<List<TimelineEntry>> $laneData = this.getLaneData();
        result = result * 59 + ($laneData == null ? 43 : ((Object)$laneData).hashCode());
        return result;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class TimelineEntry {
        private String entryLabel;
        private long startTimeMs;
        private long endTimeMs;
        private String color;

        public TimelineEntry(String entryLabel, long startTimeMs, long endTimeMs) {
            this.entryLabel = entryLabel;
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
        }

        public TimelineEntry(String entryLabel, long startTimeMs, long endTimeMs, Color color) {
            this.entryLabel = entryLabel;
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.color = Utils.colorToHex(color);
        }

        public String getEntryLabel() {
            return this.entryLabel;
        }

        public long getStartTimeMs() {
            return this.startTimeMs;
        }

        public long getEndTimeMs() {
            return this.endTimeMs;
        }

        public String getColor() {
            return this.color;
        }

        public void setEntryLabel(String entryLabel) {
            this.entryLabel = entryLabel;
        }

        public void setStartTimeMs(long startTimeMs) {
            this.startTimeMs = startTimeMs;
        }

        public void setEndTimeMs(long endTimeMs) {
            this.endTimeMs = endTimeMs;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimelineEntry)) {
                return false;
            }
            TimelineEntry other = (TimelineEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$entryLabel = this.getEntryLabel();
            String other$entryLabel = other.getEntryLabel();
            if (this$entryLabel == null ? other$entryLabel != null : !this$entryLabel.equals(other$entryLabel)) {
                return false;
            }
            if (this.getStartTimeMs() != other.getStartTimeMs()) {
                return false;
            }
            if (this.getEndTimeMs() != other.getEndTimeMs()) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            return !(this$color == null ? other$color != null : !this$color.equals(other$color));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TimelineEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entryLabel = this.getEntryLabel();
            result = result * 59 + ($entryLabel == null ? 43 : $entryLabel.hashCode());
            long $startTimeMs = this.getStartTimeMs();
            result = result * 59 + (int)($startTimeMs >>> 32 ^ $startTimeMs);
            long $endTimeMs = this.getEndTimeMs();
            result = result * 59 + (int)($endTimeMs >>> 32 ^ $endTimeMs);
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            return result;
        }

        public String toString() {
            return "ChartTimeline.TimelineEntry(entryLabel=" + this.getEntryLabel() + ", startTimeMs=" + this.getStartTimeMs() + ", endTimeMs=" + this.getEndTimeMs() + ", color=" + this.getColor() + ")";
        }

        public TimelineEntry() {
        }

        @ConstructorProperties(value={"entryLabel", "startTimeMs", "endTimeMs", "color"})
        public TimelineEntry(String entryLabel, long startTimeMs, long endTimeMs, String color) {
            this.entryLabel = entryLabel;
            this.startTimeMs = startTimeMs;
            this.endTimeMs = endTimeMs;
            this.color = color;
        }
    }

    public static class Builder
    extends Chart.Builder<Builder> {
        private List<String> laneNames = new ArrayList<String>();
        private List<List<TimelineEntry>> laneData = new ArrayList<List<TimelineEntry>>();

        public Builder(String title, StyleChart style) {
            super(title, style);
        }

        public Builder addLane(String name, List<TimelineEntry> data) {
            this.laneNames.add(name);
            this.laneData.add(data);
            return this;
        }

        public ChartTimeline build() {
            return new ChartTimeline(this);
        }
    }
}

