/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.testsupport;

import java.io.File;
import org.canova.api.conf.Configuration;
import org.deeplearning4j.scaleout.actor.runner.DeepLearning4jDistributed;
import org.deeplearning4j.scaleout.api.statetracker.StateTracker;
import org.deeplearning4j.scaleout.job.JobIterator;
import org.deeplearning4j.scaleout.statetracker.hazelcast.HazelCastStateTracker;

public abstract class BaseTestDistributed {
    protected JobIterator iterator;
    protected DeepLearning4jDistributed distributed;
    protected StateTracker stateTracker;
    protected String workPerformFactoryClassName;
    private Configuration conf;

    public void init() throws Exception {
        if (this.stateTracker != null) {
            this.stateTracker.finish();
            this.stateTracker.shutdown();
        }
        this.stateTracker = this.createStateTracker();
        this.iterator = this.createIterator();
        this.workPerformFactoryClassName = this.workPerformFactoryClassName();
        this.conf = this.createConfiguration();
        this.distributed = new DeepLearning4jDistributed(this.iterator, this.stateTracker);
        this.distributed.setup(this.conf);
    }

    public void tearDown() throws Exception {
        if (this.stateTracker != null) {
            this.stateTracker.finish();
            this.stateTracker.shutdown();
            this.distributed.shutdown();
        }
        if (new File("model-saver").exists()) {
            new File("model-saver").delete();
        }
        Thread.sleep(10000L);
    }

    public Configuration createConfiguration() {
        Configuration conf = new Configuration();
        conf.set("org.deeplearning4j.scaleout.perform.workerperformer", this.workPerformFactoryClassName);
        return conf;
    }

    public StateTracker createStateTracker() throws Exception {
        if (this.stateTracker != null) {
            this.stateTracker.finish();
            this.stateTracker.shutdown();
        }
        return new HazelCastStateTracker();
    }

    public abstract String workPerformFactoryClassName();

    public abstract JobIterator createIterator();
}

